/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef XMLRPC_SERVER_UTIL_H
#define XMLRPC_SERVER_UTIL_H

#include <xmlrpc.h>

typedef struct {
    apr_pool_t *pool;
    rast_db_t *db;
} xmlrpc_server_t;

xmlrpc_value *xmlrpc_server_register(xmlrpc_env *env,
                                     xmlrpc_value *param_array,
                                     void *user_data);
xmlrpc_value *xmlrpc_server_search(xmlrpc_env *env, xmlrpc_value *param_array,
                                   void *user_data);
xmlrpc_value *xmlrpc_server_delete(xmlrpc_env *env, xmlrpc_value *param_array,
                                   void *user_data);
xmlrpc_value *xmlrpc_server_update(xmlrpc_env *env, xmlrpc_value *param_array,
                                   void *user_data);
xmlrpc_value *xmlrpc_server_get_text(xmlrpc_env *env,
                                     xmlrpc_value *param_array,
                                     void *user_data);
xmlrpc_value *xmlrpc_server_encoding(xmlrpc_env *env,
                                     xmlrpc_value *param_array,
                                     void *user_data);
xmlrpc_value *xmlrpc_server_properties(xmlrpc_env *env,
                                       xmlrpc_value *param_array,
                                       void *user_data);

#endif
