/****************************************************************************
** Client - class
**
**   Created : Fri Jun 6 12:09:08 2008
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef RENDER_RENDER_H
#define RENDER_RENDER_H

#include <QMutex>
#include <QThread>
#include <QTcpSocket>
#include <QEventLoop>
#include <QWaitCondition>

#include "logger.h"

class QFile;
class CXmlSlideshow;

namespace Render
{
// The block size we shuffle over the socket at once.
#define BLOCK_LEN 1024
// Throttling transfere over socket for better debugging (delay in usec)
#define THROTTLE 0

class Render : public QThread
{
  Q_OBJECT

  template<class type> class Message  {
  public:
    Message ( ) { };
    static QByteArray create ( type value )
    {
      char cBuffer[ sizeof ( type ) ];
      (type &)cBuffer = value;
      return QByteArray ( cBuffer, sizeof ( type ) );
    }
  };

public:
           Render ( int, QObject * );
  virtual ~Render ( );

  void run  (     );
  void exit ( int );
  QString getHashName ( QString & );
  void sendProgress   (   float   );
  bool isLocalServer  ( );
  Logger &logger      ( );
  Logger &status      ( );

protected:
  virtual void timerEvent  ( QTimerEvent * );
  quint64 fileFromSocket   ( );
  void    createSlideshow  ( );
  bool    loadSlideshowXML ( QString );
  quint64 createXMLHash    ( QString );
  unsigned long long SDBMHash ( QString & );

  void sendMessage        ( quint16, QString );
  bool sendFile           ( QString );
  void sendServerState    ( bool );
  void sendNextPacket     ( );
  void sendVersionAndHost ( );
  void receivedXMLName    ( );

protected slots:
  virtual void slotReadSocket  (       );
  virtual void slotExiting     (       );

signals:
  void error ( QTcpSocket::SocketError );
  void signalIAmDone        ( Render * );

private:
  CXmlSlideshow *m_pSlideshow;
  // this var is used to determine if the XML file has changed
  quint64 m_iXMLHash; // between a previous run and now.
  Logger  m_logger;
  Logger  m_status;
  QString m_qsTempPath;
  // Receiving from Client :
  quint16 m_iMessageID;
  quint64 m_iMessageLen;
  QFile  *m_pFile;

  bool m_bLocalClientAndServer;
  QString m_qsClientTempPath;
  QWaitCondition m_waiter;
  QMutex         m_mutex;

  int m_iSocketDescriptor;
  int m_iTimerID;
  QTcpSocket m_tcpSocket;
};

}; // end of namespace Render

#endif
