###################################################
##                                               ##
##            'Q'Render project file             ##
##                                               ##
##             Created using Kate by             ##
##                                               ##
##                   Varol Okan                  ##
##                                               ##
##                  December 2008                ##
##                                               ##
###################################################

WHICH_PREFIX = $$(PREFIX)
WHICH_FFMPEG = $$(FFMPEG)
WHICH_FFMPEG_INC = $$(FFMPEG_INC)
WHICH_FFMPEG_LIB = $$(FFMPEG_LIB)
STATIC_FFMPEG    = $$(STATIC_FFMPEG)

isEmpty (WHICH_FFMPEG)  {
  exists ( ffmpeg/ )  {
    WHICH_FFMPEG=$$(PWD)/ffmpeg
  }
  else  {
    WHICH_FFMPEG=/usr/local
  }
}
isEmpty (WHICH_FFMPEG_INC)  {
  WHICH_FFMPEG_INC=$${WHICH_FFMPEG}/include
}
isEmpty (WHICH_FFMPEG_LIB)  {
  WHICH_FFMPEG_LIB=$${WHICH_FFMPEG}/lib
}

# First check is for qmake version.
! contains ( QT_MAJOR_VERSION, "4" )  {
  error ( "qmake version $${QT_VERSION} to old. Please use qt 4.x" )
}

system  ( echo )
message ( Qt version: $$[QT_VERSION] )
message ( Qt is installed in $$[QT_INSTALL_PREFIX] )
message ( Using ffmpeg lib from : $$WHICH_FFMPEG )

unix {
  UI_DIR       = .ui
  MOC_DIR      = .moc
  OBJECTS_DIR  = .obj
}
win32 {
  UI_DIR       = ui
  MOC_DIR      = moc
  OBJECTS_DIR  = obj
}

HEADERS       = utils.h\
		shared.h\
		server.h \
                render.h  \
		parser.h   \
		logger.h    \
		slideshow.h  \
		encoder.h     \
		engine/ffmpeg_enc.h \
		../qdvdauthor/xml_slideshow.h

SOURCES       = main.cpp \
		utils.cpp \
		server.cpp \
                render.cpp  \
		parser.cpp   \
		logger.cpp    \
		slideshow.cpp  \
	encoder.cpp     \
		engine/ffmpeg_enc.cpp \
		../qdvdauthor/xml_slideshow.cpp

WHICH_PREFIX = $$(PREFIX)
isEmpty(WHICH_PREFIX) {
        WHICH_PREFIX =/usr
}


# Next we try to find the where abouts of the ffmpeg library
! isEmpty ( STATIC_FFMPEG )  {
  exists  ( $${WHICH_FFMPEG_LIB}/libavcodec.a ) {
    LIBS += $${WHICH_FFMPEG_LIB}/libavformat.a $${WHICH_FFMPEG_LIB}/libavcodec.a $${WHICH_FFMPEG_LIB}/libavutil.a $${WHICH_FFMPEG_LIB}/libavdevice.a
    message ( Using static ffmpeg library )
  }
  else  {
    LIBS += -lavformat -lavcodec -lavutil -lavdevice 
    message ( Using shared ffmpeg libary )
    message ( ..for static ffmpeg : > export STATIC_FFMPEG; qmake )
  }
}
else  {
  LIBS += -lavformat -lavcodec -lavutil -lavdevice
  message ( Using shared ffmpeg libary )
  message ( ..for static ffmpeg : > export STATIC_FFMPEG; qmake )
}
system ( echo )
# remove theora, and vorbisenc if not installed
#LIBS        += -L$${WHICH_FFMPEG_LIB} -ltheora -lvorbisenc -lbz2
LIBS        += -L$${WHICH_FFMPEG_LIB}  -lvorbisenc -lbz2

target.path  = $${WHICH_PREFIX}/bin

INCLUDEPATH += $${WHICH_FFMPEG_INC}
TEMPLATE     = app
INSTALLS    += target
DESTDIR      = ../bin
DEFINES     += QDVD_RENDER
CONFIG      += debug
QMAKE_CXXFLAGS_DEBUG += -O0 -ggdb3
QMAKE_CFLAGS_DEBUG   += -O0 -ggdb3
QT          += xml network


