/****************************************************************************
** Parser - class
**
**   Created : Tue Jun 24 12:09:08 2008
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will parse the command line options and execute the propper
** actions.
**
****************************************************************************/

#ifndef RENDER_PARSER_H
#define RENDER_PARSER_H

#include <QString>

namespace Render
{

class Parser
{
public:
           Parser ( );
  virtual ~Parser ( );

  bool    parseCommandLine ( int, char ** );
  QString getLogfileName   ( );
  int     getServerPort    ( );
  int     getLogLevel      ( );
  bool    isTTY            ( );

protected:
  void printHelp ( );
  bool createSlideshow ( );

private:
  QString m_qsTempPath;
  QString m_qsInputName;
  QString m_qsOutputName;
  int     m_iServerPort;
  bool    m_bTTY;
  int     m_iLogLevel;
  QString m_qsLogFileName;
};

}; // end of namespace Render

#endif
