/****************************************************************************
** Main file
**
**   Created : Wed Jun 25 07:53:05 2008
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This is the main file.
**
****************************************************************************/

#include <unistd.h>

#include <QApplication>
#include <QtCore>

#include "shared.h"
#include "server.h"
#include "parser.h"

int main(int argc, char *argv[])
{
  QApplication app ( argc, argv );

  // The parser class handles user input.
  // We can exit here if QRender is
  // not executed as deamon ( Client-Server )
  Render::Parser parser;
  if ( parser.parseCommandLine ( argc, argv ) )
    return 0;

  pid_t iPid = getpid ( );

  if ( ! parser.isTTY ( ) )  {
    printf ( "\nStarting QRender[%d] in deamon mode, Listening to port : %d\n\n", (int)iPid+1, parser.getServerPort ( ) );
    daemon ( 1, 1 );
  }
  else 
    printf ( "\nStarting QRender[%d] in the foreground, Listening to port : %d\n\n", (int)iPid+1, parser.getServerPort ( ) );

  // At this point we start the server thread and listen to the set port.
  Render::Server server;
  server.setLogInfo ( parser.getLogLevel ( ), parser.getLogfileName ( ) );

  if ( ! server.listen ( QHostAddress::Any, parser.getServerPort ( ) ) )
    printf ( "ERROR: Can not bind to port 5066\n%s\n", (const char *)server.errorString ( ).toAscii ( ) );
  else
    return app.exec ( );

  return -1;
}
