/****************************************************************************
 ** Encode - class
 **
 **   Created : Wed 18 2008
 **        by : Varol Okan using kate editor
 ** Copyright : (c) Varol Okan
 ** License   : GPL v 2.0
 **
 ** FFRMpeg based encoder class.
 **
 ** Goal: take images and add it to stream to be written 
 **       to a file in VOB format
 **
 ****************************************************************************/

#ifndef ENCODER_FFMPEG_ENC_H
#define ENCODER_FFMPEG_ENC_H

#include "../encoder.h"

class QString;

struct AVFormatContext;
struct AVStream;
struct AVFrame;

namespace Encoder
{

class FFmpeg : public Encoder
{
public:
           FFmpeg ( );
  virtual ~FFmpeg ( );

  virtual bool initStream ( QString , enVideo, enAudio, uint i=1 );
  virtual bool addImage   ( QImage *, int );
  virtual void endStream  ( );

protected:
  bool addVideoStream    ( int, enVideo, int );
  bool addAudioStream    ( int );
  bool OpenAudioEncoder  ( );
  void CloseAudioEncoder ( );
  AVFrame *allocPicture  ( int, int, int );
  bool OpenVideoEncoder  ( );
  void CloseVideoEncoder ( );
  bool writeAudioFrame   ( );
  bool writeVideoFrame   ( );
  void RGBtoYUV420P      ( const uint8_t *, uint8_t *, uint, bool, int, int, bool b=false );

private:
  AVFormatContext *m_pOutputCtx;
  AVStream        *m_pVideoStream;
  AVStream        *m_pAudioStream;
  AVFrame         *m_pFrame;
  uint8_t         *m_pAudioBuffer;
  uint8_t         *m_pVideoBuffer;
  int16_t         *m_pSamples;
};

}; // end of namespace Encoder

#endif // ENCODER_FFMPEG_ENC_H
