
#ifndef __PLUGIN_SOURCE_GROUPS_H__
#define __PLUGIN_SOURCE_GROUPS_H__

namespace Plugin
{

class SourceGroup
{
  public:
    enum type       { NTSC, PAL };
    enum filterType { FadeIn, CrossFade, FadeOut };

    class SourceEntry  {
    public:
      SourceEntry ( ) { iLength=0; };
      QString    qsFileName;
      unsigned long iLength; // in MSec
    };
             SourceGroup ( ) { enType=NTSC; bSlideshow=false; bCreateChapterMenu=false; };
    virtual ~SourceGroup ( ) {
      QValueList<SourceEntry *>::iterator it=listFiles.begin ( );
      while ( it != listFiles.end ( ) )
        delete *it++;
    };

  public:
    // General :
    type          enType;
    QString       qsGroupName; // could be different then pEntry->qsDisplayName
    bool          bCreateChapterMenu;
    QDateTime     dateStart;   // The starting date of the Slideshow / Videos
    QDateTime     dateEnd;     // The ending date of the Slideshow  / Videos

    QValueList<SourceEntry *> listFiles;
    QString     qsScreenshot;
    bool        bSlideshow;
    int         iFilterLength;
    QString     qsBackground;
    QStringList listAudio;
}; // end class SourceGroup

}; // end namespace Plugin

#endif // __PLUGIN_SOURCE_GROUPS_H__ 

