/****************************************************************************
** dialogslideshow.cpp
**
**   Created : Wed Jun 4'th 2008 
**        by : Varol Okan using vi
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
*****************************************************************************/

#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpixmap.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <qfileinfo.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcolordialog.h>

#include "global.h"
#include "messagebox.h"
#include "qdvdauthor.h"
#include "xml_slideshow.h"
#include "dialogslideshow.h"
#include "filepreviewdialog.h"

namespace Input
{

DialogSlideshow::DialogSlideshow ( QWidget *pParent )
  : uiSlideshow ( pParent )
{
  connect ( m_pButtonOkay,   SIGNAL ( clicked ( ) ), this, SLOT ( accept ( ) ) );
  connect ( m_pButtonCancel, SIGNAL ( clicked ( ) ), this, SLOT ( reject ( ) ) );

  connect ( m_pButtonImage,  SIGNAL ( clicked ( ) ), this, SLOT ( slotImage       ( ) ) );
  connect ( m_pButtonColor,  SIGNAL ( clicked ( ) ), this, SLOT ( slotColor       ( ) ) );
  connect ( m_pButtonAdd,    SIGNAL ( clicked ( ) ), this, SLOT ( slotAddAudio    ( ) ) );
  connect ( m_pButtonDelete, SIGNAL ( clicked ( ) ), this, SLOT ( slotDeleteAudio ( ) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
DialogSlideshow::~DialogSlideshow ( )
{

}

QString DialogSlideshow::background ( )
{
  return m_qsBackground;
}

QStringList &DialogSlideshow::audioList ( )
{
  return m_listAudio;
}

void DialogSlideshow::initMe ( CXmlSlideshow *pSlideshow, bool bEnableName )
{
  m_pSlideshow = pSlideshow;
  if ( ! pSlideshow )
    return;

  m_pSpinImageDelay->setValue   ( pSlideshow->delay          );
  m_pCheckIntroPage->setChecked ( pSlideshow->intro_page     );
  m_pSpinFilterDelay->setValue  ( pSlideshow->filter_delay   );
  m_pEditName->setText          ( pSlideshow->slideshow_name );
  m_pEditName->setEnabled       ( bEnableName                );

  QString   qsAudio;
  QFileInfo fileInfo;
  QStringList::iterator it = pSlideshow->audio_list.begin ( );
  while ( it  !=  pSlideshow->audio_list.end ( ) )  {
    qsAudio = *it++;
    fileInfo.setFile ( qsAudio );
    qsAudio = fileInfo.fileName ( );
    m_pListAudio->insertItem    ( qsAudio );
  }
  m_listAudio = pSlideshow->audio_list;

  if ( pSlideshow->background[0] == '#' )  {
//    QColor theColor ( pSlideshow->background );
//    m_pLabelBckground->setPaletteBackgroundColor ( theColor );
  }
  else if ( pSlideshow->background.isEmpty ( ) )
    pSlideshow->background = "#000000";
  else  {
    QFileInfo fileInfo   ( pSlideshow->background );
    if ( fileInfo.exists ( ) )  {
      // in order to get the correct size I need to show the dialog now.
      show ( );
      QPixmap thePixmap;
      QImage theImage ( pSlideshow->background );
      m_qsBackground  = pSlideshow->background;
      thePixmap.convertFromImage ( theImage.smoothScale ( m_pLabelBackground->size ( ), QImage::ScaleFree ) );
      m_pLabelBackground->setPixmap ( thePixmap );
      return;
    }
    else
      pSlideshow->background = "#000000";
  }
  m_qsBackground  = pSlideshow->background;
  QColor theColor ( pSlideshow->background );
  m_pLabelBackground->setPaletteBackgroundColor ( theColor );
}

void DialogSlideshow::slotImage ( )
{
  QString qsFilter   = Global::pApp->getImageFilter ( );
  QString qsFileName = FilePreviewDialog::getOpenFileName ( NULL, Global::qsCurrentPath, qsFilter, this );

  if ( qsFileName.isEmpty ( ) )
    return;

  QImage  theImg ( qsFileName );
  QPixmap thePix;
  if ( theImg.isNull ( ) )
    return;

  thePix.convertFromImage ( theImg.smoothScale ( m_pLabelBackground->size ( ), QImage::ScaleFree ) );
  m_pLabelBackground->setPixmap ( thePix );
  m_qsBackground = qsFileName;
}

void DialogSlideshow::slotColor ( )
{
  QColor theColor;

  theColor.setNamedColor ( m_pSlideshow->background );

  if ( ! theColor.isValid ( ) )
    theColor.setNamedColor ( "#000000" );

  theColor = QColorDialog::getColor ( theColor, this );
  if ( ! theColor.isValid ( ) )
      return;

  QPixmap emptyPix;
  m_pLabelBackground->setPixmap  ( emptyPix );
  m_pLabelBackground->setBackgroundColor ( theColor );
  m_qsBackground = theColor.name ( );
}

void DialogSlideshow::slotAddAudio ( )
{
  MessageBox::warning ( NULL, tr ( "Not supported."), tr ( "Audio is currently not supported for Slideshows.\n"), QMessageBox::Ok, QMessageBox::NoButton );

  QString qsFilter = "Audio ( " + Global::pApp->getSoundFilter  ( ) + ")";
  QStringList list = QFileDialog::getOpenFileNames ( qsFilter, Global::qsCurrentPath, this );

  if ( list.count ( ) < 1 )
    return;

  m_listAudio += list;

  QString   qsAudio;
  QFileInfo fileInfo;
  QStringList::iterator it = list.begin ( );
  while ( it  !=  list.end ( ) )  {
    qsAudio = *it++;
    fileInfo.setFile ( qsAudio );
    qsAudio = fileInfo.fileName ( );
    m_pListAudio->insertItem    ( qsAudio );
  }
}

void DialogSlideshow::slotDeleteAudio ( )
{
  QString qsAudio = m_pListAudio->currentText ( );
  if ( qsAudio.isEmpty ( ) )
    return;

  m_pListAudio->removeItem ( m_pListAudio->currentItem ( ) );

  // The listBox only holds the file name, and not the whol path
  // thus we need to search for the right entry.
  QString qsInList;
  QStringList::iterator it = m_listAudio.begin ( );
  while ( it != m_listAudio.end ( ) )  {
    qsInList = *it++;
    if ( qsInList.find   ( qsAudio  ) > -1 ) {
      m_listAudio.remove ( qsInList );
      return;
    }
  }
}

}; // End of namespace Input

