#
# PHREL
# $Id: dgt.m4,v 1.1 2006/03/20 06:17:02 sella Exp $
# Copyright (c) 2005-2006 Digital Genesis Software. All Rights Reserved.
# Released under the GPL Version 2 License.
# http://www.digitalgenesis.com
#

# AC Archive: http://www.gnu.org/software/ac-archive/

AC_DEFUN([AC_ADD_SEARCH_PATH],[
  if test "x$1" != x -a -d $1; then
     if test -d $1/lib; then
       LDFLAGS="-L$1/lib $LDFLAGS"
     fi
     if test -d $1/include; then
       CPPFLAGS="-I$1/include $CPPFLAGS"
     fi
  fi
])

AC_DEFUN([AC_CHECK_STATIC], [
  AC_MSG_CHECKING(if static build is desired)

  USE_STATIC="no"

  AC_ARG_ENABLE(
    static,
    [  --enable-static         enable static build rather than shared],
    USE_STATIC="yes")

  AC_MSG_RESULT($USE_STATIC)
  if test "$USE_STATIC" = "yes"; then
    STATIC=1
    LIB_EXT="a"
    AC_DEFINE(USE_STATIC, 1, [Define if 'use_static' is enabled.])
    AC_MSG_ERROR([Static support won't compile. Needs development. Sorry.])
  else
    LIB_EXT="so"
  fi

  AC_SUBST(STATIC)
  AC_SUBST(LIB_EXT)
])

dnl Stores the CFLAGS and CXXFLAGS values before AC_PROG_CC and AC_PROG_CXX adjust them.
AC_DEFUN([AC_SAVE_FLAGS], [
  saved_CFLAGS=$CFLAGS
  saved_CXXFLAGS=$CXXFLAGS
])

dnl Restores the original values of CFLAGS and CXXFLAGS prior to AC_PROG_CC and AC_PROG_CXX adjust them.
AC_DEFUN([AC_RESTORE_FLAGS], [
  CFLAGS=$saved_CFLAGS
  CXXFLAGS=$saved_CXXFLAGS
])

AC_DEFUN([AC_CHECK_DEBUG], [
  AC_MSG_CHECKING(whether to enable debugging)

  WITH_DEBUG="no"

  AC_ARG_ENABLE(
    debug,
    [  --enable-debug          enable debug (enables -O0 -g -Wall -fno-inline)],
    WITH_DEBUG="yes")

  if test "$WITH_DEBUG" = "no"; then
    AC_MSG_RESULT(no)

    if test -z "$CXXFLAGS"; then
      CXXFLAGS="$CXXFLAGS -w -O3 -s"
    else
      CXXFLAGS="$CXXFLAGS -w"
    fi

    if test -z "$CFLAGS"; then
      CFLAGS="$CFLAGS -O3 -s -w"
    else
      CFLAGS="$CFLAGS -w"
    fi
  else
    AC_MSG_RESULT(yes)

    if test "$WITH_DEBUG" = "yes"; then
      AC_DEFINE(USE_DEBUG, 1, [Define if 'use_debug' is enabled.])
      CFLAGS="$CFLAGS -O0 -g -Wall -fno-inline -DDEBUG"
      CXXFLAGS="$CXXFLAGS -O0 -g -Wall -fno-inline -DDEBUG"
    fi
  fi
])

AC_DEFUN([AC_WITH_MARCH], [
  AC_MSG_CHECKING(which cpu-type for march)

  AC_ARG_WITH(march,
  [  --with-march=CPU        use cpu-type (ie: i686, pentium4, athlon64) [[no]]],
      if test "$withval" = "yes"; then
        WITH_MARCH="i386"
      elif test "$withval" = "no"; then
        WITH_MARCH="no"
      else
        WITH_MARCH="$withval"
      fi,
      WITH_MARCH="no"
  )
  if test "$WITH_MARCH" = "no"; then
    AC_MSG_RESULT(no)
  else
    old_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$INCLUDES $CPPFLAGS -march=$WITH_MARCH"
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([
        #include <stdio.h>
      ],[
        int x = 0;
      ],[
        dnl Success
        CPPFLAGS="$old_CPPFLAGS -march=$WITH_MARCH"
      ],[
        dnl Failure
        WITH_MARCH="no"
        CPPFLAGS="$old_CPPFLAGS"
      ])
    if test "$WITH_MARCH" = "no"; then
      AC_MSG_RESULT([not compatible with compiler])
    else
      AC_MSG_RESULT($WITH_MARCH)
    fi
  fi
])

AC_DEFUN([AC_RESOLVE_CONFIGURE_PATHS], [
  if test "x$prefix" = "xNONE"; then
    eval "prefix=$ac_default_prefix"
    eval "resolved_datadir=$datadir"
    eval "resolved_sysconfdir=$sysconfdir"
    eval "resolved_localstatedir=$localstatedir"
    eval "resolved_htmldir=$htmldir"
    eval "resolved_rrddir=$rrddir"
    eval "prefix=NONE"
  else
    eval "resolved_datadir=\"$datadir\""
    eval "resolved_sysconfdir=$sysconfdir"
    eval "resolved_localstatedir=\"$localstatedir\""
    eval "resolved_htmldir=\"$htmldir\""
    eval "resolved_rrddir=\"$rrddir\""
  fi

  if test "x$exec_prefix" = "xNONE"; then
    if test "x$prefix" = "xNONE"; then
      eval "exec_prefix=$ac_default_prefix"
    else
      eval "exec_prefix=${prefix}"
    fi
    eval "resolved_bindir=$bindir"
    eval "resolved_sbindir=$sbindir"
    eval "resolved_libdir=$libdir"
    eval "resolved_libexecdir=$libexecdir"
    eval "exec_prefix=NONE"
  else
    eval "resolved_bindir=\"$bindir\""
    eval "resolved_sbindir=\"$sbindir\""
    eval "resolved_libdir=\"$libdir\""
    eval "resolved_libexecdir=\"$libexecdir\""
  fi

  AC_SUBST(resolved_datadir)
  AC_SUBST(resolved_sysconfdir)
  AC_SUBST(resolved_localstatedir)
  AC_SUBST(resolved_htmldir)
  AC_SUBST(resolved_rrddir)
  AC_SUBST(resolved_bindir)
  AC_SUBST(resolved_sbindir)
  AC_SUBST(resolved_libdir)
  AC_SUBST(resolved_libexecdir)
]) 

AC_DEFUN([AC_CHECK_LIBUCDSNMP], [
  AC_MSG_CHECKING(for SNMP support)

  AC_ARG_ENABLE(
    snmp,
    [  --disable-snmp          disable SNMP support (www.netsnmp.org)],
    WITH_SNMP="$enableval", WITH_SNMP="yes")

  AC_ARG_WITH(
    snmp-inc,
    [  --with-snmp-inc=PATH    include path for SNMP headers],
    snmp_incdir="$withval", snmp_incdir="no")

  AC_ARG_WITH(
    snmp-lib,
    [  --with-snmp-lib=PATH    library path for SNMP libraries],
    snmp_libdir="$withval", snmp_libdir="no")


  dnl Test for net-snmp
  if test "$WITH_SNMP" = "no"; then 
    AC_MSG_RESULT(no)
  elif test "$WITH_SNMP" = "yes"; then
    AC_MSG_RESULT(yes)
    AC_PATH_PROG(SNMP_CONFIG, net-snmp-config, , [/usr/local/bin:$PATH])
  else
    AC_MSG_RESULT(yes)
    SNMP_CONFIG="$WITH_SNMP/bin/net-snmp-config"
  fi

  if test "$WITH_SNMP" = "no"; then
    SNMP_LIBDIR=""
    SNMP_INCDIR=""
  elif test -x "$SNMP_CONFIG"; then
    SNMP_LIBS="`$SNMP_CONFIG --netsnmp-libs`"
    SNMP_LIBS="$SNMP_LIBS `$SNMP_CONFIG --external-libs`"
    SNMP_PREFIX="`$SNMP_CONFIG --prefix`"

    if test -n "$SNMP_LIBS" && test -n "$SNMP_PREFIX"; then
      if test "${SNMP_PREFIX}" != "/usr"; then
        SNMP_INCDIR="-I${SNMP_PREFIX}/include"
      fi
      SNMP_LIBDIR="${SNMP_LIBS}"

      old_LIBS="$LIBS"
      old_CPPFLAGS="$CPPFLAGS"
      CPPFLAGS="$SNMP_INCDIR $CPPFLAGS"
      LIBS="$SNMP_LIBDIR $LIBS"
    
      AC_CHECK_HEADER(net-snmp/net-snmp-config.h)
      AC_CHECK_LIB(netsnmp, snmp_open)
  
      LIBS="$old_LIBS"
      CPPFLAGS="$old_CPPFLAGS"

      if test "$ac_cv_lib_netsnmp_snmp_open" = "yes" -a "$ac_cv_header_net_snmp_net_snmp_config_h" = "yes"; then
        AC_DEFINE(HAVE_NET_SNMP, 1, [Define if 'have_net_snmp' is enabled.])
      fi
    fi
  else 
    unset ac_cv_header_ucd_snmp_ucd_snmp_config_h
    unset ac_cv_header_ucd_snmp_parse_h
    unset ac_cv_lib_snmp_snmp_open
    unset ac_cv_lib_crypto_SSLeay

    if test "$snmp_incdir" != "no"; then
        SNMP_INCDIR=-I$snmp_incdir
    elif test "$WITH_SNMP" != "yes"; then
      SNMP_INCDIR=-I$WITH_SNMP/include
      test -d $WITH_SNMP/include/ucd-snmp && SNMP_INCDIR="-I$withval/include"
    else
      SNMP_INCDIR=""
      test -f /usr/local/include/ucd-snmp/ucd-snmp-config.h && SNMP_INCDIR=""
      test -f /usr/include/snmp/include/ucd-snmp/ucd-snmp-config.h && SNMP_INCDIR="-I/usr/include/snmp/include"
      test -f /usr/local/include/snmp/include/ucd-snmp/ucd-snmp-config.h && SNMP_INCDIR="-I/usr/local/include/snmp/include"
    fi
    if test "$snmp_libdir" != "no"; then
      SNMP_LIBDIR=-L$snmp_libdir
    elif test "$WITH_SNMP" != "yes"; then
      SNMP_LIBDIR=-L$WITH_SNMP/lib
    else
      SNMP_LIBDIR=-L/usr/local/lib
      test -f /usr/lib/libsnmp.a && SNMP_LIBDIR=-L/usr/lib
      test -f /usr/lib/libsnmp.so && SNMP_LIBDIR=-L/usr/lib
      test -f /usr/local/lib/libsnmp.a && SNMP_LIBDIR=-L/usr/local/lib
      test -f /usr/local/lib/libsnmp.so && SNMP_LIBDIR=-L/usr/local/lib
      test -f /usr/local/snmp/lib/libsnmp.a && SNMP_LIBDIR=-L/usr/local/snmp/lib
      test -f /usr/local/snmp/lib/libsnmp.so && SNMP_LIBDIR=-L/usr/local/snmp/lib
    fi

    old_LIBS="$LIBS"
    old_CPPFLAGS="$CPPFLAGS"
    INCLUDES="$SNMP_INCDIR $INCLUDES"
    CPPFLAGS="$INCLUDES $CPPFLAGS"
    LIBS="$SNMP_LIBDIR $LIBS"
  
    AC_CHECK_HEADERS(ucd-snmp/ucd-snmp-config.h ucd-snmp/parse.h)
    if test "$ac_cv_header_ucd_snmp_ucd_snmp_config_h" = "yes"; then
      dnl UCD SNMP 4.x
      AC_TRY_RUN([
          #include <ucd-snmp/ucd-snmp-config.h>
          main() { exit(USE_OPENSSL != 1); }
        ],[
          SNMP_SSL=yes
        ],[
          SNMP_SSL=no
        ],[
          SNMP_SSL=no
        ])
      if test "$SNMP_SSL" = "yes"; then
        AC_DEFINE(HAVE_UCD_SNMP_SSL, 1, [Define if 'have_snmp_ssl' is enabled.])
      fi
    fi
  
    if test "$SNMP_SSL" = "yes"; then
      dnl This is required if crypto was used to build libsnmp.
      SSL_LIBDIR=""
      test -f /usr/local/ssl/lib/libcrypto.a && SSL_LIBDIR=-L/usr/local/ssl/lib
      test -f /usr/local/ssl/lib/libcrypto.so && SSL_LIBDIR=-L/usr/local/ssl/lib
      LIBS="$SSL_LIBDIR -lcrypto $LIBS"
    fi
  
    AC_CHECK_LIB(snmp, snmp_open, SNMP_LIBDIR="$SNMP_LIBDIR -lsnmp")
    AC_CHECK_LIB(crypto, SSLeay, SNMP_LIBDIR="$SNMP_LIBDIR $SSL_LIBDIR -lcrypto")
  
    LIBS="$old_LIBS"
    CPPFLAGS="$old_CPPFLAGS"

    if test "$ac_cv_lib_snmp_snmp_open" = "yes" -a "$ac_cv_header_ucd_snmp_parse_h" = "yes" -a "$ac_cv_header_ucd_snmp_ucd_snmp_config_h" = "yes"; then
      AC_DEFINE(HAVE_UCD_SNMP, 1, [Define if 'have_ucd_snmp' is enabled.])
    fi
  fi

  AC_SUBST(SNMP_LIBDIR)
  AC_SUBST(SNMP_INCDIR)
])

dnl Automake macro adapted from PHP.
AC_DEFUN([BOLD_MSG],[
  AC_MSG_RESULT()
  AC_MSG_RESULT([${term_bold}$1${term_norm}])
])

#
# Local Variables:
# c-basic-offset: 3
# vim: noet ts=3 sw=3
#
