/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: seriessourcecontext.cxx,v $
 *
 *  $Revision: 1.1.2.2 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/13 14:38:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/seriessourcecontext.hxx"
#include "oox/drawingml/chart/seriessourcemodel.hxx"

using ::rtl::OUString;
using ::oox::core::ContextHandler2Helper;
using ::oox::core::ContextWrapper;

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

SeriesSourceContext::SeriesSourceContext( ContextHandler2Helper& rParent, SeriesSourceModel& rModel ) :
    ChartContextBase< SeriesSourceModel >( rParent, rModel ),
    mnPtIndex( -1 )
{
}

SeriesSourceContext::~SeriesSourceContext()
{
}

// oox.core.ContextHandler2Helper interface -----------------------------------

ContextWrapper SeriesSourceContext::onCreateContext( sal_Int32 nElement, const AttributeList& )
{
    switch( getCurrentElement() )
    {
        case C_TOKEN( tx ):
            return  (nElement == C_TOKEN( v )) ||
                    (nElement == C_TOKEN( strRef ));
        case C_TOKEN( cat ):
        case C_TOKEN( xVal ):
            return  (nElement == C_TOKEN( numLit )) ||
                    (nElement == C_TOKEN( numRef )) ||
                    (nElement == C_TOKEN( strLit )) ||
                    (nElement == C_TOKEN( strRef )) ||
                    (nElement == C_TOKEN( multiLvlStrRef ));
        case C_TOKEN( val ):
        case C_TOKEN( yVal ):
        case C_TOKEN( bubbleSize ):
            return  (nElement == C_TOKEN( numLit )) ||
                    (nElement == C_TOKEN( numRef ));

        case C_TOKEN( numLit ):
            return  (nElement == C_TOKEN( formatCode )) ||
                    (nElement == C_TOKEN( ptCount )) ||
                    (nElement == C_TOKEN( pt ));

        case C_TOKEN( strLit ):
            return  (nElement == C_TOKEN( ptCount )) ||
                    (nElement == C_TOKEN( pt ));

        case C_TOKEN( pt ):
            return  (nElement == C_TOKEN( v ));

        case C_TOKEN( numRef ):
        case C_TOKEN( strRef ):
        case C_TOKEN( multiLvlStrRef ):
            return  (nElement == C_TOKEN( f ));
    }
    return false;
}

void SeriesSourceContext::onStartElement( const AttributeList& rAttribs )
{
    switch( getCurrentElement() )
    {
        case C_TOKEN( ptCount ):
            getModel().getData().mnPointCount = rAttribs.getInteger( XML_val, -1 );
        break;
        case C_TOKEN( pt ):
            mnPtIndex = rAttribs.getInteger( XML_idx, -1 );
        break;
    }
}

void SeriesSourceContext::onEndElement( const OUString& rChars )
{
    switch( getCurrentElement() )
    {
        case C_TOKEN( v ):
            switch( getPreviousElement() )
            {
                case C_TOKEN( tx ):
                    getModel().getData().maText = rChars;
                break;
                case C_TOKEN( pt ):
                    if( mnPtIndex >= 0 ) switch( getPreviousElement( 2 ) )
                    {
                        case C_TOKEN( numLit ):
                            getModel().getData().maValues[ mnPtIndex ] = rChars.toDouble();
                        break;
                        case C_TOKEN( strLit ):
                            getModel().getData().maStrings[ mnPtIndex ] = rChars;
                        break;
                    }
                break;
            }
        break;
        case C_TOKEN( formatCode ):
            getModel().getData().maFormatCode = rChars;
        break;
        case C_TOKEN( f ):
            getModel().getData().maFormula = rChars;
        break;
    }
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

