/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartformatinfo.cxx,v $
 *
 *  $Revision: 1.1.2.4 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/15 15:41:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/chartformatinfo.hxx"
#include "oox/helper/helper.hxx"
#include "tokens.hxx"

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

namespace {

static const ChartFormatInfo spFmtInfos[] =
{
    // object type             property mode              missing frame type   auto-line-color  auto-linewt auto-patt-color  create delete isframe
    { OBJECTTYPE_BACKGROUND,   PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  true,  true,  true  },
    { OBJECTTYPE_PLOTFRAME,    PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  true,  true,  true  },
    { OBJECTTYPE_WALL3D,       PROPERTYMODE_COMMON,       FRAMETYPE_AUTO,      true,  XML_tx1,  XML_hair,   true,  XML_bg1,  true,  false, true  },
    { OBJECTTYPE_FLOOR3D,      PROPERTYMODE_COMMON,       FRAMETYPE_AUTO,      true,  XML_tx1,  XML_hair,   false, 0x808080, true,  false, true  },
    { OBJECTTYPE_TEXT,         PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, true,  true  },
    { OBJECTTYPE_LEGEND,       PROPERTYMODE_COMMON,       FRAMETYPE_AUTO,      true,  XML_tx1,  XML_hair,   true,  XML_bg1,  true,  true,  true  },
    { OBJECTTYPE_LINEARSERIES, PROPERTYMODE_LINEARSERIES, FRAMETYPE_AUTO,      true,  XML_tx1,  XML_single, true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_FILLEDSERIES, PROPERTYMODE_FILLEDSERIES, FRAMETYPE_AUTO,      false, 0x000000, XML_single, true,  XML_bg1,  false, false, true  },
    { OBJECTTYPE_AXISLINE,     PROPERTYMODE_COMMON,       FRAMETYPE_AUTO,      true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_GRIDLINE,     PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, true,  false },
    { OBJECTTYPE_TRENDLINE,    PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_double, true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_ERRORBAR,     PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_single, true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_CONNECTLINE,  PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_HILOLINE,     PROPERTYMODE_LINEARSERIES, FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, false, false },
    { OBJECTTYPE_WHITEDROPBAR, PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_bg1,  false, false, true  },
    { OBJECTTYPE_BLACKDROPBAR, PROPERTYMODE_COMMON,       FRAMETYPE_INVISIBLE, true,  XML_tx1,  XML_hair,   true,  XML_tx1,  false, false, true  }
};

}

// ----------------------------------------------------------------------------

ChartFormatInfoProvider::ChartFormatInfoProvider()
{
    const ChartFormatInfo* pEnd = STATIC_ARRAY_END( spFmtInfos );
    for( const ChartFormatInfo* pIt = spFmtInfos; pIt != pEnd; ++pIt )
        maInfoMap[ pIt->meObjType ] = pIt;
}

const ChartFormatInfo& ChartFormatInfoProvider::getFormatInfo( ChartObjectType eObjType ) const
{
    FmtInfoMap::const_iterator aIt = maInfoMap.find( eObjType );
    OSL_ENSURE( aIt != maInfoMap.end(), "ChartFormatInfoProvider::getFormatInfo - unknown object type" );
    return (aIt == maInfoMap.end()) ? *spFmtInfos : *aIt->second;
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

