/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: seriessourcemodel.hxx,v $
 *
 *  $Revision: 1.1.2.4 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/18 14:39:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_DRAWINGML_CHART_SERIESSOURCEMODEL_HXX
#define OOX_DRAWINGML_CHART_SERIESSOURCEMODEL_HXX

#include <map>
#include "oox/drawingml/chart/modelbase.hxx"

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

struct SeriesSourceData
{
    typedef ::std::map< sal_Int32, double >             DoubleMap;
    typedef ::std::map< sal_Int32, ::rtl::OUString >    StringMap;

    DoubleMap           maValues;           /// List of numeric values.
    StringMap           maStrings;          /// List of string values.
    ::rtl::OUString     maFormatCode;       /// Number format for literal values.
    ::rtl::OUString     maText;             /// Single text, e.g. series title.
    ::rtl::OUString     maFormula;          /// Formula reference, e.g. into a spreadsheet.
    sal_Int32           mnPointCount;       /// Number of points in this series source.

    explicit            SeriesSourceData();
};

// ----------------------------------------------------------------------------

class SeriesSourceModel : public ModelData< SeriesSourceData >
{
public:
    explicit            SeriesSourceModel();
    virtual             ~SeriesSourceModel();
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif

