/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: charttypeinfo.hxx,v $
 *
 *  $Revision: 1.1.2.4 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/15 15:41:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_DRAWINGML_CHART_CHARTTYPEINFO_HXX
#define OOX_DRAWINGML_CHART_CHARTTYPEINFO_HXX

#include <map>
#include <rtl/ustring.hxx>

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

/** Enumerates different chart types. */
enum ChartTypeId
{
    TYPEID_BAR,                     /// Vertical bar chart.
    TYPEID_HORBAR,                  /// Horizontal bar chart.
    TYPEID_LINE,                    /// Line chart.
    TYPEID_AREA,                    /// Area chart.
    TYPEID_STOCK,                   /// Stock chart.
    TYPEID_RADARLINE,               /// Linear radar chart.
    TYPEID_RADARAREA,               /// Filled radar chart.
    TYPEID_PIE,                     /// Pie chart.
    TYPEID_DOUGHNUT,                /// Doughnut (ring) chart.
    TYPEID_OFPIE,                   /// Pie-to-pie or pie-to-bar chart.
    TYPEID_SCATTER,                 /// Scatter (XY) chart.
    TYPEID_BUBBLE,                  /// Bubble chart.
    TYPEID_SURFACE,                 /// Surface chart.
    TYPEID_UNKNOWN                  /// Default for unknown chart types.
};

// ----------------------------------------------------------------------------

/** Enumerates different categories of similar chart types. */
enum ChartTypeCategory
{
    TYPECATEGORY_BAR,               /// Bar charts (horizontal or vertical).
    TYPECATEGORY_LINE,              /// Line charts (line, area, stock charts).
    TYPECATEGORY_RADAR,             /// Radar charts (linear or filled).
    TYPECATEGORY_PIE,               /// Pie and donut charts.
    TYPECATEGORY_SCATTER,           /// Scatter and bubble charts.
    TYPECATEGORY_SURFACE            /// Surface charts.
};

// ----------------------------------------------------------------------------

/** Enumerates modes for varying point colors in a series. */
enum ChartVarPointMode
{
    VARPOINTMODE_NONE,              /// No varied colors supported.
    VARPOINTMODE_SINGLE,            /// Only supported, if type group contains only one series.
    VARPOINTMODE_MULTI              /// Supported for multiple series in a chart type group.
};

// ============================================================================

/** Contains info for a chart type related to the OpenOffice.org chart module. */
struct ChartTypeInfo
{
    ChartTypeId         meTypeId;               /// Unique chart type identifier.
    ChartTypeCategory   meTypeCategory;         /// Chart type category this type belongs to.
    const sal_Char*     mpcServiceName;         /// Service name of the type.
    ChartVarPointMode   meVarPointMode;         /// Mode for varying point colors.
    bool                mbCombinable2d;         /// True = types can be combined in one axes set.
    bool                mbSupports3d;           /// True = 3D type allowed, false = only 2D type.
    bool                mbWalls3d;              /// True = 3D type includes wall and floor format.
    bool                mbPolarCoordSystem;     /// True = polar, false = cartesian.
    bool                mbSeriesIsFrame2d;      /// True = 2D type series with area formatting.
    bool                mbSeriesIsFrame3d;      /// True = 3D type series with area formatting.
    bool                mbSingleSeriesVis;      /// True = only first series visible (e.g. pie charts).
    bool                mbCategoryAxis;         /// True = X axis contains categories.
    bool                mbSwappedAxesSet;       /// True = X axis and Y axis are swapped.
    bool                mbSupportsStacking;     /// True = data points can be stacked on each other.
    bool                mbReverseSeries;        /// True = insert unstacked series in reverse order.
    bool                mbTicksBetweenCateg;    /// True = X axis ticks between categories.
};

// ============================================================================

/** Provides access to chart type info structs for all available chart types.
 */
class ChartTypeInfoProvider
{
public:
    explicit            ChartTypeInfoProvider();

    /** Returns chart type info for a unique chart type identifier (XML token). */
    const ChartTypeInfo& getTypeInfo( ChartTypeId eTypeId ) const;

    /** Returns the first fitting chart type info for an XML chart type element identifier. */
    const ChartTypeInfo& getTypeInfoFromElement( sal_Int32 nElement ) const;

    /** Returns the first fitting chart type info for the passed service name. */
    const ChartTypeInfo& getTypeInfoFromService( const ::rtl::OUString& rServiceName ) const;

private:
    typedef ::std::map< ChartTypeId, const ChartTypeInfo* > TypeInfoMap;
    TypeInfoMap         maInfoMap;          /// Maps chart types to type info structs.
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif

