/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartformatinfo.hxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/12 12:02:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_DRAWINGML_CHART_CHARTFORMATINFO_HXX
#define OOX_DRAWINGML_CHART_CHARTFORMATINFO_HXX

#include <map>
#include <sal/types.h>

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

/** Enumerates different object types for specific automatic formatting behaviour. */
enum ChartObjectType
{
    OBJECTTYPE_BACKGROUND,              /// Chart background.
    OBJECTTYPE_PLOTFRAME,               /// Wall formatting in 2d charts.
    OBJECTTYPE_WALL3D,                  /// Wall formatting in 3d charts.
    OBJECTTYPE_FLOOR3D,                 /// Floor formatting in 3d charts.
    OBJECTTYPE_TEXT,                    /// Text boxes (titles, data point labels).
    OBJECTTYPE_LEGEND,                  /// Chart legend.
    OBJECTTYPE_LINEARSERIES,            /// Series formatting in a chart supporting line formatting only.
    OBJECTTYPE_FILLEDSERIES,            /// Series formatting in a chart supporting area formatting.
    OBJECTTYPE_AXISLINE,                /// Axis line format.
    OBJECTTYPE_GRIDLINE,                /// Axis grid line format.
    OBJECTTYPE_TRENDLINE,               /// Series trend line.
    OBJECTTYPE_ERRORBAR,                /// Series error bar.
    OBJECTTYPE_CONNECTLINE,             /// Data point connector line.
    OBJECTTYPE_HILOLINE,                /// High/low lines in stock charts.
    OBJECTTYPE_WHITEDROPBAR,            /// White-day drop bar in stock charts.
    OBJECTTYPE_BLACKDROPBAR             /// Black-day drop bar in stock charts.
};

// ----------------------------------------------------------------------------

/** Specifies the type of a formatting. This results in different property names. */
enum ChartPropertyType
{
    PROPERTYMODE_COMMON,                /// Common objects, no special handling.
    PROPERTYMODE_LINEARSERIES,          /// Specific to data series drawn as lines.
    PROPERTYMODE_FILLEDSERIES           /// Specific to data series drawn as areas.
};

// ----------------------------------------------------------------------------

/** Enumerates different types to handle missing frame objects. */
enum ChartFrameType
{
     FRAMETYPE_AUTO,                    /// Missing frame represents automatic formatting.
     FRAMETYPE_INVISIBLE                /// Missing frame represents invisible formatting.
};

// ============================================================================

/** Contains information about auto formatting of a specific chart object type. */
struct ChartFormatInfo
{
    ChartObjectType     meObjType;          /// Object type for automatic format.
    ChartPropertyType   mePropType;         /// Property type for propertyset helper.
    ChartFrameType      meDefFrameType;     /// Default format type for missing frame objects.
    bool                mbAutoLineTheme;    /// True = mnAutoLineColor as theme, false = as RGB.
    sal_Int32           mnAutoLineColor;    /// Automatic line color (XML token, e.g. XML_tx1).
    sal_Int32           mnAutoLineWeight;   /// Automatic line weight (XML token: hairline, single, ...).
    bool                mbAutoPattTheme;    /// True = mnAutoPattColor as theme, false = as RGB.
    sal_Int32           mnAutoPattColor;    /// Automatic fill pattern color (XML token, e.g. XML_bg1).
    bool                mbCreateDefFrame;   /// True = create missing frame objects on import.
    bool                mbDeleteDefFrame;   /// True = delete default frame formatting on export.
    bool                mbIsFrame;          /// True = object is a frame, false = object is a line.
};

// ----------------------------------------------------------------------------

/** Provides access to chart auto formatting for all available object types. */
class ChartFormatInfoProvider
{
public:
    explicit            ChartFormatInfoProvider();

    /** Returns an info struct about auto formatting for the passed object type. */
    const ChartFormatInfo& getFormatInfo( ChartObjectType eObjType ) const;

private:
    typedef ::std::map< ChartObjectType, const ChartFormatInfo* > FmtInfoMap;
    FmtInfoMap          maInfoMap;          /// Maps object type to formatting data.
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif

