/*************************************************************************
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Kohei Yoshida.
 *    1039 Kingsway Dr., Apex, NC 27502, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _GLOBAL_HXX_
#define _GLOBAL_HXX_

#include <string>
#include <iterator>
#include <iostream>

#define SCSOLVER_DEBUG 0

#define REWRITE_FOR_SUN_STUDIO_COMPILER 1

#if defined(SCSOLVER_UNO_COMPONENT) || defined(SCSOLVER_UNITTEST)

#ifndef OSL_ASSERT
#define OSL_ASSERT assert
#endif

#else
#include <osl/diagnose.h>
#endif

namespace {

//---------------------------------------------------------------------------
// Function templates (need to be implemented in header)

template<typename Container>
void printElements( const Container& cn, const char* sep = " " )
{
	using namespace ::std;
	copy( cn.begin(), cn.end(), ostream_iterator<typename Container::value_type>( cout, sep ) );
	cout << endl;
}

}

namespace scsolver {

/**
 * Outputs debug message when SCSOLVER_DEBUG is defined.
 * 
 * @param s      message to output
 */
void Debug( const char* s );
std::string repeatString( const char*, unsigned long );

}

#endif
