/******************************************************************************
 * mod_uploader / TemplateVariableCreator.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateVariableCreator.h 355 2005-05-08 05:19:50Z svn $
 *****************************************************************************/

#ifndef TEMPLATEVARIABLECREATOR_H
#define TEMPLATEVARIABLECREATOR_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "TemplateExecutor.h"
#include "UploadItem.h"

#include "apr_pools.h"
#include "apr_hash.h"
#include "apr_tables.h"

using namespace std;

/**
 * ƥץ졼ȤŬѤѿ륯饹
 */
class TemplateVariableCreator
{
 public:
    typedef TemplateExecutor::variable variable;
    typedef TemplateExecutor::scalar scalar;

    static TemplateExecutor::variable *create(apr_pool_t *pool, UploadItem *item);
    static TemplateExecutor::variable *create(apr_pool_t *pool, const char *str);
    static TemplateExecutor::variable *create(apr_pool_t *pool, apr_hash_t *hash);
    static TemplateExecutor::variable *create(apr_pool_t *pool, apr_array_header_t *array);

private:
    TemplateVariableCreator(const TemplateVariableCreator &);
    TemplateVariableCreator &operator=(const TemplateVariableCreator &);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
