/*  Window monitor / clipboard handler
 *  Copyright (C) 2004 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "windowmonitor.h"

enum {
  TARGET_STRING,
  TARGET_TEXT,
  TARGET_COMPOUND_TEXT,
  TARGET_UTF8_STRING
};      /* copied from gtkclipboard.c */

static GtkClipboard *_clipboard;
static GtkClipboard *_primary;

/* GtkClipboardTextReceivedFunc */
static void
clipboardTextReceived(GtkClipboard *clipboard, const gchar *text, gpointer data);

void initClipboard()
{
    _clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
    _primary   = gtk_clipboard_get(GDK_SELECTION_PRIMARY);

    gtk_clipboard_request_text(_clipboard, clipboardTextReceived, NULL);
    gtk_clipboard_request_text(_primary  , clipboardTextReceived, NULL);
}

/* copied from gtk/gtkclipboard.c */
static void 
text_get_func (GtkClipboard     *clipboard,
	       GtkSelectionData *selection_data,
	       guint             info,
	       gpointer          data)
{
    gtk_selection_data_set_text (selection_data, data, -1);
}

static void 
text_clear_func (GtkClipboard *clipboard,
		 gpointer      data)
{
    g_free (data);
    gtk_clipboard_request_text(clipboard, clipboardTextReceived, NULL);
}

static void
clipboard_set_text(GtkClipboard *clipboard, const char *text, int len)
{
  /* copied from gtk_clipboard_set_text() in gtk/gtkclipboard.c */
  static const GtkTargetEntry targets[] = {
    { "STRING", 0, TARGET_STRING },
    { "TEXT",   0, TARGET_TEXT }, 
    { "COMPOUND_TEXT", 0, TARGET_COMPOUND_TEXT },
    { "UTF8_STRING", 0, TARGET_UTF8_STRING }
  };

  g_return_if_fail (clipboard != NULL);
  g_return_if_fail (text != NULL);
  
  if (len < 0)
    len = strlen (text);
  
  gtk_clipboard_set_with_data (clipboard, 
			       targets, G_N_ELEMENTS (targets),
			       text_get_func, text_clear_func,
			       g_strndup (text, len));
}

void
clipboardSetText(const char *text, int len)
{
    g_return_if_fail (_clipboard != NULL);
    g_return_if_fail (_primary   != NULL);
    g_return_if_fail (text != NULL);
    clipboard_set_text(_clipboard, text, len);
    clipboard_set_text(_primary  , text, len);
}

static void
clipboardTextReceived(GtkClipboard *clipboard, const gchar *text, gpointer data)
{
    if (text) {
        int len = strlen(text);
	clipboard_set_text(clipboard, text, len);
        SendClientCutText((const char *)text, len);
    }
}
