# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import gobject
import gnomevfs
import os
from time import time
import urllib
from xml.dom import minidom

from library import Library,Playlist,library_wrapper
from helper import helper
from song import Song,VALID_EXTENTIONS,sType
import song

from widget.progress import action_progress  

import stock
import utils
import const
import config


class LocalPlaylist(Playlist):
    
    def sanitarise_songs(self,songs):
        if self.is_podcast():
            return []
        elif self.is_iradio():
            return [s for s in songs if s.get_type() in  sType.webradio]
        else:
            return [s for s in songs if s.get_type() in sType.file_transfert_from]  
    
    def append(self,songs):
        Playlist.append(self,self.sanitarise_songs(songs))
    
    def insert(self,songs,pos):   
        Playlist.insert(self,self.sanitarise_songs(songs),pos)
        
class LocalLibrary(Library):
    def __init__(self):   
        Library.__init__(self,"local")
        self.monitor_id = None
        self.monitored_folders = {}

    def load(self):
        #song.SONG_SET_NO_FORMAT = True
        objs = utils.load_db("songs.db")
        if objs: self.songs = objs
        objs = utils.load_db("playlists.db")
        if objs: self.playlists = objs
        #song.SONG_SET_NO_FORMAT = False
        
        Library.load(self)
        if False:
            print len(self.songs),"songs and",len(self.playlists),"playlists loaded"
            for pl in self.playlists:
                #Clean broken playlist 
                #uris = self.songs.keys()
                #pl.songs = [ uri for uri in pl.songs if uri in uris ]
                print len(pl.songs)," in pl ",pl.name
        
        gobject.timeout_add(1500,self.start_monitoring,True)
        self.monitored_folders = {}
               
        self.build_cache()
        gobject.timeout_add(const.AUTOSAVE_TIMEOUT,self.auto_save)
        helper.library_loaded(self)

    def start_monitoring(self,parse_library_location = False):
        self.stop_monitoring()
        monitored_folder = gnomevfs.make_uri_canonical(os.path.expanduser(config.get("library","location"))+"/")
        
            
        import threading
        t = threading.Thread(target=self.start_monitoring_thread,args=(monitored_folder,parse_library_location))
        t.setDaemon(True)
        t.start()
    
    def start_monitoring_thread(self,monitored_folder,parse_library_location=False):
        if config.getboolean("library","watcher"):
            dirs = utils.get_folder_in_folder(monitored_folder)
            for dir in dirs:
                self.monitored_folders[dir] = gnomevfs.monitor_add(dir, gnomevfs.MONITOR_DIRECTORY, self.monitor_notify)
            self.monitored_folders[monitored_folder] = gnomevfs.monitor_add(monitored_folder, gnomevfs.MONITOR_DIRECTORY, self.monitor_notify)
            print len(self.monitored_folders),"folder monitored"
        if parse_library_location:
            if config.getboolean("library","startup_added"):
                gobject.idle_add(self.import_folder_real,[monitored_folder],_("Checking for new file..."))
            if config.getboolean("library","startup_deleted"):
                gobject.idle_add(self.check_db,monitored_folder)    
            
            
    def stop_monitoring(self):
        for dir,id in self.monitored_folders.iteritems():
            try:gnomevfs.monitor_cancel(self.monitored_folders[monitored_folder])
            except:pass
        self.monitored_folders = {}
        
    def mobitor_folder_cb(self,uris):
        for uri in uris:
            print "File added",uri 
            song = Song()
            song.set_type(sType.LOCAL_FILE)
            song["uri"] = uri
            if song.read_from_file():
                self.get_pl_master().append([song])    
        
    def monitor_notify(self,monitor_uri,uri,event):
        #print "W:monitor_notify:",uri,event
        if event == gnomevfs.MONITOR_EVENT_DELETED:  
            for monitored_folder in self.monitored_folders:
                if monitored_folder[:len(uri)] == uri:
                    try:gnomevfs.monitor_cancel(self.monitored_folders[monitored_folder])
                    except:pass
            deleted = []
            for library_uri in self.songs.keys():
                if library_uri == uri:
                    deleted.append(self.songs[library_uri])
                else:
                    if uri[-1:] != "/": uri = uri+"/"
                    if library_uri[:len(uri)] == uri:
                        deleted.append(self.songs[library_uri])  
                          
            self.delete_songs(deleted)  
            
        try: fileinfo = gnomevfs.get_file_info(uri)
        except gnomevfs.NotFoundError,gnomevfs.NotADirectoryError: return   
        if fileinfo.name[0] == ".": return
        
        if event == gnomevfs.MONITOR_EVENT_CREATED and  fileinfo.type == gnomevfs.FILE_TYPE_DIRECTORY:
                self.monitored_folders[uri] = gnomevfs.monitor_add(uri, gnomevfs.MONITOR_DIRECTORY, self.monitor_notify)
                
                #FIXME: NEed found a better way
                #Perhaps made a thread with a directory queue
                #When no notify append after 10sec parse all new directory
                import threading
                thread = threading.Thread(target=utils.parse_uris,args=([uri],True,False,self.mobitor_folder_cb))
                gobject.timeout_add(5000,thread.start)
                
                thread = threading.Thread(target=utils.parse_uris,args=([uri],True,False,self.mobitor_folder_cb))
                gobject.timeout_add(30000,thread.start)
                                   
                    
        elif event == gnomevfs.MONITOR_EVENT_CREATED or event == gnomevfs.MONITOR_EVENT_CHANGED or event == gnomevfs.MONITOR_EVENT_METADATA_CHANGED: 
            if fileinfo.type == gnomevfs.FILE_TYPE_REGULAR and VALID_EXTENTIONS.has_key(utils.get_ext(uri)):
                if uri in self.get_pl_master().songs:
                    if fileinfo.ctime > self.songs[uri].get("#ctime"):
                        print "File changed",uri
                        song = Song()
                        song.set_type(sType.LOCAL_FILE)
                        song["uri"] = uri
                        song.read_from_file()
                        self.change_songs([song])
                else:
                    song = Song()
                    song.set_type(sType.LOCAL_FILE)
                    song["uri"] = uri
                    song.read_from_file()
                    self.get_pl_master().append([song])        
                    
        else:
            print "event not catched",event
        
    def auto_save(self):
        self.save()
        for pl in self.playlists:
            pl.library = self
        return True
     
    def save(self):    
        if not self.is_loaded: return
        Library.prepare_save(self)
        
        #Delete prepared tag (~) for speed up listen startup
#        for uri,s in self.songs.iteritems():
#            keys = s.keys()
#            keys_to_del = [key for key in keys if key[0]=="~"]
#            for key in keys_to_del:
#                try: del s[key]
#                except: pass
#                            
        utils.save_db(self.songs,"songs.db")
        utils.save_db(self.playlists,"playlists.db")
        Library.save(self)
        print len(self.songs),"songs and",len(self.playlists),"playlists saved"
            
        
        
    def check_db(self,monitored_folder):
        def background_check(monitored_folder):
            deleted = []
            total = len(self.songs)
            i = 0
            for uri,song in self.songs.iteritems():
                i += 1
                if not song.exists():
                    deleted.append(song)
                yield "Checking for removed files",float(i)/float(total),False
            gobject.idle_add(self.delete_songs,deleted)
            
        id = action_progress.add_queue("Checking for removed files",background_check,monitored_folder)
        
    def reload_db(self):
        def background_check():
            deleted = []
            changed = []
            songs = self.get_pl_master().get_songs()
            total = len(songs)
            i = 0
            for song in songs:
                i += 1
                if not song.exists():
                    deleted.append(song)
                else:
                    if song.get_type() == sType.LOCAL_FILE:
                        song.read_from_file()
                        changed.append(song)
                
                if len(changed)>=const.IMPORT_SUBMIT:
                    gobject.idle_add(helper.change_songs,changed)
                    changed = []
                    
                yield "Reload database %d/%s"%(i,total),float(i)/float(total),False
            
            if len(changed)>0: 
                gobject.idle_add(helper.change_songs,changed)

            if len(deleted)>0: 
                gobject.idle_add(self.delete_songs,deleted)
            
        id = action_progress.add_thread_queue("Reload database",background_check)
        
    def import_file(self,*param):
        from widget.dialog import WinFile    
        w = WinFile()
        uri = w.run()
        if uri and VALID_EXTENTIONS.has_key(utils.get_ext(uri)):
            song = Song()
            song.set_type(sType.LOCAL_FILE)
            song["uri"] = uri
            if song.read_from_file():
               self.get_pl_master().append([song])
        
    def import_folder(self,*param):
        from widget.dialog import WinDir
        
        w = WinDir()
        dir = w.run()
        if not dir : return
        
        print _("Checking %s") % dir
        self.import_folder_real([dir])
    
    def import_folder_real(self,dirs,message=_("Reading directories...")):
        def parse_dir(dirs):
            start = time()
            
            added = []
            t = 1
            last_estimated = estimated = 0 
                        

                
            while len(dirs)>0:
                dir = dirs.pop(0)
                try:hdir = gnomevfs.DirectoryHandle(dir,gnomevfs.DIRECTORY_VISIT_LOOPCHECK)
                except: 
                    print dir,"Not found"
                    continue
                try: fileinfo = hdir.next()
                except StopIteration: continue;
                while fileinfo:
                    if fileinfo.name[0] in [".",".."] or fileinfo.flags != gnomevfs.FILE_FLAGS_LOCAL: 
                        pass
                    elif fileinfo.type == gnomevfs.FILE_TYPE_DIRECTORY:
                        dirs.append(dir+"/"+gnomevfs.escape_string(fileinfo.name))
                        t += 1
                    else:
                        try:
                            uri = gnomevfs.make_uri_canonical(dir+"/"+gnomevfs.escape_string(fileinfo.name))
                            if fileinfo.type == gnomevfs.FILE_TYPE_REGULAR and VALID_EXTENTIONS.has_key(utils.get_ext(uri)):
                                if uri not in self.get_pl_master().songs:
                                    added.append(uri) 
                                elif fileinfo.ctime > self.songs[uri].get("#ctime"):
                                    added.append(uri)
                        except UnicodeDecodeError:
                            raise "UnicodeDecodeError",uri
                    try: fileinfo = hdir.next()
                    except StopIteration: break;
                estimated = 1.0-float(len(dirs))/float(t)
                yield message,max(estimated,last_estimated),False
                last_estimated = estimated

            i = 0
            total = len(added)
            finish = []
            added.sort()
            for uri in added:
                i += 1
                song = Song()
                song.set_type(sType.LOCAL_FILE)
                song["uri"] = uri
                if song.read_from_file():
                    finish.append(song)
                    if len(finish)>=const.IMPORT_SUBMIT:
                        gobject.idle_add(self.idle_send_song,self.get_pl_master(),finish)
                        finish = []
                
                yield _("Reading file")+" %d/%d..."%(i,total),float(i)/float(total),False
            
            if len(finish)>0: 
                gobject.idle_add(self.idle_send_song,self.get_pl_master(),finish)
            
            end = time()
            print total,"songs loaded in ",(end-start)," seconds"
            
        action_progress.add_thread_queue(_("Loading..."),parse_dir,dirs)
        
    def idle_send_song(self,pl,songs):
        pl.append(songs)
        if pl.is_podcast():
           self.download_podcasts(songs)
      
        
    def refresh_podcasts(self,songs):
        uris = {}
        for song in songs:
            if not uris.has_key(song.get("podcastrss")) or song.get("#daterss") > uris[song.get("podcastrss")]:
                uris[song.get("podcastrss")] = song.get("#daterss")
        for uri,date in uris.iteritems():
            self.download_podcast_feed(uri,date)
              
    def download_podcast_feed(self,uri,start_date=None):
        uri = gnomevfs.make_uri_canonical(uri)
        """if not gnomevfs.exists(uri):
            print "W:LocalLibrary:Podcast uri not exist"
            return False"""
        def parse_feed(uri):
            """ Some node navigation """
            def get_child(node,name):
                return node.getElementsByTagName(name)
        
            def get_value(node):
                if hasattr(node,"firstChild") and node.firstChild!=None:
                    return node.firstChild.nodeValue
                else:
                    return ""
        
            def get_first_child_value(node,node_name):
                node = get_child(node,node_name)
                if node!=None and len(node)>0:
                    return get_value(node[0])
                else:
                    return "";
            try:
                #FIXME: Add porxies configuration
                """proxies = {}
                f = urllib.FancyURLopener(proxies).open(uri)
                data_len = 1024
                block = f.read(data_len)
                data = block
                while len(block)==data_len:
                    block = f.read(data_len)
                    data += block
                    yield _("Download feed..."),0,True"""
                    
                sock = urllib.urlopen(uri)
                xmldoc = minidom.parse(sock).documentElement
                root_node = xmldoc.getElementsByTagName('channel')[0]
            except:
                print "Podcast feed load failed, ",uri
                return 
    
            
            podcastrss = uri
            album = get_first_child_value(root_node,"title")
            descriptionrss = get_first_child_value(root_node,"description")
            lastBuildDate = utils.strdate_to_time(get_first_child_value(root_node,"lastBuildDate"))
            pubDate = utils.strdate_to_time(get_first_child_value(root_node,"pubDate"))
            
            """ choose the good date prefer pubDate"""
            if pubDate=="":
                daterss = lastBuildDate
            else:
                daterss = pubDate
                
            img_node = root_node.getElementsByTagName("image")
            if img_node!=None and len(img_node)>0:
                imagerss = get_first_child_value(img_node[0],"url")
            else:
                imagerss = None
                
            if start_date and daterss <= start_date:
                return 
    
            """ some check """
            if album=="" or daterss=="":
                print "Can't add podcast, no title or date found"
                return
    
            added = []
            items = root_node.getElementsByTagName("item")
            total = len(items)
            i = 0
            for item in items:
                i += 1
                song = Song()
                song.set_type(sType.LOCAL_PODCAST)
                song["progress_text"] = _("Not downloaded")
                song["#progress_value"] = float(0)
                song["album"] = album
                song["descriptionrss"] = descriptionrss
                song["#daterss"] = daterss
                song["imagerss"] = imagerss
                song["podcastrss"] = uri
                song["title"] = get_first_child_value(item,"title")
                #rss_item["link"] = self.get_first_child_value(item,"link")
                song["description"] = get_first_child_value(item,"description")
                enclosure_node = get_child(item,"enclosure")                
                #song["#duration"] = enclosure_node[0].getAttribute("length")
                song["#duration"] = "" # to show the not download message
                if enclosure_node and len(enclosure_node)>0:
                    song["uri"] = enclosure_node[0].getAttribute("url")
                    song["podcasturl"] = song["uri"]
                    song["#date"] = utils.strdate_to_time(get_first_child_value(item,"pubDate"))
        
                    """ Only feed with tile,date and mp3 uri """
                    if song["uri"]  and song["title"]  and song["#date"] \
                         and (not start_date or song["#date"] > start_date) and not self.songs.has_key(song["uri"]):
                        added.append(song)
                        if len(added)>=const.IMPORT_SUBMIT:
                            gobject.idle_add(self.idle_send_song,self.get_pl_podcast(),added)
                            added = []
                            
                        
                yield _("Reading podcast")+" %d/%d..."%(i,total),float(i)/float(total),False
                
            if len(added)>0: 
                gobject.idle_add(self.idle_send_song,self.get_pl_podcast(),added)
               
            # Update old podcast, the date is very important because the podcast have the hightest date is used for refresh podcast with correct date
            podcast_songs = [s for s in self.get_pl_podcast().get_songs() if s.get("podcastrss") == uri and s.get("#daterss") < daterss]
            for song in podcast_songs:
                song["descriptionrss"] = descriptionrss
                song["#daterss"] = daterss
                song["imagerss"] = imagerss
                song["podcastrss"] = uri
                
        action_progress.add_queue(_("Download feed..."),parse_feed,uri)
        
        
    def download_podcasts(self,songs):        
        action_progress.add_thread_queue(_("Download podcasts..."),self.download_podcasts_background,songs)

    def download_podcasts_background(self,songs):
        total = len(songs)
        i = 0 
        print total,"podcasts to download"
        for song in songs:
            i += 1
            if song.get("uri") != song.get("podcasturl"):
                yield _("Download podcasts...")+" (%d/%d)"%(i,total),float(i)/float(total),False
                continue
            
            
            podcast_path = os.path.expanduser(config.get("podcast","folder")+"/")
            podcast_path += song.get_str("album")+"/"
            if not os.path.isdir(os.path.dirname(podcast_path)):
                os.makedirs(os.path.dirname(podcast_path))
            filename =  song.get_filename()
            for char in [":","/"]:
                filename = filename.replace(char,"_")
            podcast_path += filename
            new_uri =  gnomevfs.make_uri_canonical(gnomevfs.get_uri_from_local_path(podcast_path))
            print new_uri
            
            if gnomevfs.exists(new_uri): 
                if new_uri == song.get("uri") or gnomevfs.unlink(new_uri):
                    print "Podcast already exists or can't delete the incomplete file"
                    yield _("Download podcasts...")+" (%d/%d)"%(i,total),float(i)/float(total),False
                    continue
            
            uri = gnomevfs.make_uri_canonical(song.get("podcasturl"))
            try:
                handle_read = gnomevfs.Handle(uri)
                handle_write = gnomevfs.create(new_uri, open_mode=gnomevfs.OPEN_WRITE, exclusive=False, perm=0660)
                info = handle_read.get_file_info()
                buffer_len = 1024
            
                totalsize = info.size
                currentsize = 0
                
                data = handle_read.read(buffer_len)
                handle_write.write(data)
                currentsize += len(data)
                
                while currentsize!=totalsize:
                    if buffer_len>totalsize-currentsize:
                        buffer_len = totalsize-currentsize
                    data = handle_read.read(buffer_len)
                    currentsize += len(data)
                    handle_write.write(data)
                    percent = currentsize*100/totalsize
                    progress = (float(i-1)*100+float(percent))/(float(total)*float(100))
                    yield _("Download podcasts")+" %d%% (%d/%d)"%(percent,i,total),progress,False

                handle_read.close()
                handle_write.close()
            except Exception, e:
                print "E:Podcast:Error while downloading ",uri,e
                continue
            
            # Hum, read all tag from file only for the duration.
            tmp_song = Song()
            tmp_song["uri"] = new_uri
            tmp_song.read_from_file()
            
            #Don't modify song in the thread
            def save(song,new_uri,duration,ctime,mtime):
                pl = self.get_pl_podcast()
                pl.library.delete_songs([song])
                song["uri"] = new_uri
                song["#duration"] = duration
                song["#ctime"] = ctime
                song["#mtime"] = mtime
                pl.append([song])

            gobject.idle_add( save, song, new_uri,tmp_song["duration"],tmp_song["#ctime"], tmp_song["#mtime"]  )

            yield _("Download podcasts")+"... (%d/%d)"%(i,total),float(i)/float(total),False


    def download_all_cover(self):
        def bg_download_cover():    
            l = library_wrapper.get_library("local")
            songs = [l.songs[album[0][0]] for name,album in l.albums_cache.iteritems()]

            songs = [s for s in songs if const.DEFAULT_COVER == s.get_cover(False)]
            total = len(songs)
            song_has_new_cover = []
            for i in range(0,total):
                if const.DEFAULT_COVER != songs[i].get_cover():
                    song_has_new_cover.append(songs[i])
                progress = float(i)/float(total)
                yield _("Download cover ")+" %d/%d"%(i,total),progress,False
            
            gobject.idle_add(helper.change_songs,song_has_new_cover)
        action_progress.add_thread_queue(_("Download cover..."),bg_download_cover)
        
