# these are all substituted by autoconf
%define major 2
%define minor 0
%define sub 1
%define extralevel %{nil}
%define release_name libsmbios
%define release_version %{major}.%{minor}.%{sub}%{extralevel}

Name: %{release_name}
Version: %{release_version}
Release: 1%{?dist}
License: GPLv2+ or OSL
Group: System Environment/Libraries
Source: http://linux.dell.com/libsmbios/download/%{name}/%{name}-%{version}/%{name}-%{version}.tar.gz
URL: http://linux.dell.com/libsmbios/main
Summary: Libsmbios shared libraries
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Provides: libsmbios-libs = %{version}-%{release}
BuildRequires: libxml2-devel

# libsmbios only ever makes sense on intel compatible arches
# no DMI tables on ppc, s390, etc.
ExclusiveArch: x86_64 ia64 %{ix86}

#EPEL4/5 dont have cppunit/cppunit-devel, so skip build tests
# everything else should be able to pull in cppunit to run unit tests
# during build. Doesnt affect binaries produced, so doesnt affect
# build reproducability.
%if %(test "%{dist}" != ".el4" -a "%{dist}" != ".el5" && echo 1 || echo 0)
BuildRequires: cppunit-devel
%endif

# no doxygen native for suse
%if %(test ! -e /etc/SuSE-release && echo 1 || echo 0)
BuildRequires: doxygen
%endif


%description
Libsmbios is a library and utilities that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%package -n smbios-utils
Summary: The "supported" sample binaries that use libsmbios
Group: Applications/System
Requires: libsmbios = %{version}-%{release}
Obsoletes: libsmbios-bin < 0:0.13.11
Provides: libsmbios-bin = %{version}-%{release}
Obsoletes: libsmbios-unsupported-bin < 0.13.11
Provides: libsmbios-unsupported-bin = %{version}-%{release}

%package devel
Summary: Development headers and archives
Group: Development/Libraries
Requires: libsmbios = %{version}-%{release}

%description devel
Libsmbios is a library and utilities that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains the headers and .a files necessary to compile new 
client programs against libsmbios.

%description -n smbios-utils
Libsmbios is a library and utilities that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%prep
%setup -q 
find . -type d -exec chmod -f 755 {} \;
find doc include libraries bin-unsupported build bin-supported cppunit -type f -exec chmod -f 644 {} \;
chmod 755 cppunit/*.sh

%build
export EXTRA_CXXFLAGS="%{optflags}" 
export EXTRA_CFLAGS="%{optflags}" 
export RELEASE_MAJOR=%{major} 
export RELEASE_MINOR=%{minor} 
export RELEASE_SUBLEVEL=%{sub} 
export RELEASE_EXTRALEVEL=%{extralevel}
%configure
mkdir -p doc/full/html 
make -e %{?_smp_mflags} 
[ ! -d /usr/include/cppunit ] || make -e check

%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot} INSTALL="%{__install} -p"
mkdir -p %{buildroot}/usr/include
cp -a include/smbios %{buildroot}/usr/include/
rm -f %{buildroot}/%{_libdir}/lib*.la
find %{buildroot}/usr/include -exec touch -r configure.ac {} \;
find doc/full -exec touch -r configure.ac {} \;

# backwards compatible:
ln -s /usr/sbin/dellWirelessCtl %{buildroot}/usr/bin/dellWirelessCtl

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING-GPL COPYING-OSL README
%{_libdir}/libsmbios.so.*

%files devel
%defattr(-,root,root,-)
%doc COPYING-GPL COPYING-OSL README bin-unsupported/getopts_LICENSE.txt
/usr/include/smbios
%{_libdir}/libsmbios.a
%{_libdir}/libsmbios.so
%doc doc/full/html

%files -n smbios-utils
%defattr(-,root,root,-)
%doc COPYING-GPL COPYING-OSL README
%doc bin-unsupported/getopts_LICENSE.txt include/smbios/config/boost_LICENSE_1_0_txt
%{_sbindir}/assetTag
%{_sbindir}/dellBiosUpdate
%{_sbindir}/getSystemId
%{_sbindir}/propertyTag
%{_sbindir}/serviceTag
%{_sbindir}/verifySmiPassword
%{_sbindir}/wakeupCtl
%{_sbindir}/dellLcdBrightness

# used by HAL in old location, so keep it around until HAL is updated.
%{_sbindir}/dellWirelessCtl
%{_bindir}/dellWirelessCtl

# community supported stuff...
# may or may not work
%{_sbindir}/dellLEDCtl
%{_sbindir}/activateCmosToken
%{_sbindir}/ascii2enUS_scancode
%{_sbindir}/createUnitTestFiles
%{_sbindir}/disable_console_redir
%{_sbindir}/dumpCmos
%{_sbindir}/getPasswordFormat
%{_sbindir}/isCmosTokenActive
%{_sbindir}/probes
%{_sbindir}/smitest
%{_sbindir}/stateByteCtl
%{_sbindir}/upBootCtl
%{_sbindir}/dumpSmbios

# ./ChangeLog is appended by configure
%changelog
