/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/
#ifndef YumConfTab_h
#define YumConfTab_h

#include <qwidget.h>

#include "YumConfView.h"

class OptionsView;
class CfgGroup;

class YumConfTab : public QWidget
  {
    Q_OBJECT

    private:
      YumConfView   * m_pYumConfView;
      OptionsView   * m_pOptionsView;

    private:
      void            updateOptionTable(const CfgGroup * pGroup);


    public:
                      YumConfTab    (QWidget * pParent = 0);

      YumConfView *   getYumConfView()        { return m_pYumConfView; }

      const
      YumConfView *   getYumConfView() const  { return m_pYumConfView; }

      bool            isCfgChanged  () const  { return getYumConfView()->isDirty(); }

    private slots:
      void            slotOptionChanged(QString strKey, QString strValue);
      void            slotConfigChanged();
  };

#endif
