/* GNU assembler no-op patterns from
   binutils-2.17/gas/config/tc-i386.c */

/* Various efficient no-op patterns for aligning code labels.
   Note: Don't try to assemble the instructions in the comments.
   0L and 0w are not legal. */

#define NUM_NOPS 15

static const unsigned char nops[NUM_NOPS][15] =
{ {0x90},					/* nop                  */
{0x89, 0xf6},					/* movl %esi,%esi       */
{0x8d, 0x76, 0x00},				/* leal 0(%esi),%esi    */
{0x8d, 0x74, 0x26, 0x00},			/* leal 0(%esi,1),%esi  */
{0x90,						/* nop                  */
 0x8d, 0x74, 0x26, 0x00},			/* leal 0(%esi,1),%esi  */
{0x8d, 0xb6, 0x00, 0x00, 0x00, 0x00},		/* leal 0L(%esi),%esi   */
{0x8d, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%esi,1),%esi */
{0x90,						/* nop                  */
 0x8d, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%esi,1),%esi */
{0x89, 0xf6,					/* movl %esi,%esi       */
 0x8d, 0xbc, 0x27, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%edi,1),%edi */
{0x8d, 0x76, 0x00,				/* leal 0(%esi),%esi    */
 0x8d, 0xbc, 0x27, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%edi,1),%edi */
{0x8d, 0x74, 0x26, 0x00,			/* leal 0(%esi,1),%esi  */
 0x8d, 0xbc, 0x27, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%edi,1),%edi */
{0x8d, 0xb6, 0x00, 0x00, 0x00, 0x00,		/* leal 0L(%esi),%esi   */
 0x8d, 0xbf, 0x00, 0x00, 0x00, 0x00},		/* leal 0L(%edi),%edi   */
{0x8d, 0xb6, 0x00, 0x00, 0x00, 0x00,		/* leal 0L(%esi),%esi   */
 0x8d, 0xbc, 0x27, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%edi,1),%edi */
{0x8d, 0xb4, 0x26, 0x00, 0x00, 0x00, 0x00,	/* leal 0L(%esi,1),%esi */
 0x8d, 0xbc, 0x27, 0x00, 0x00, 0x00, 0x00},	/* leal 0L(%edi,1),%edi */
{0xeb, 0x0d, 0x90, 0x90, 0x90, 0x90, 0x90,	/* jmp .+15; lotsa nops */
 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90}
};
