/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* textstyleconfig.h
 */
#ifndef textstyleconfig_h
#define textstyleconfig_h

#include <qwidget.h>

class KColorButton;
class QPushButton;
class QBoxLayout;
class QColor;

namespace KoverArtist { class TextStyle; }


/** A high level gui widget for changing the various configuration elements
 * of a koverartist text style.
 */
class TextStyleConfig: public QWidget
{
   Q_OBJECT
   typedef QWidget Inherited;

public:
   TextStyleConfig(KoverArtist::TextStyle* ts, bool alignHoriz=true,
                   bool alignVert=true, QWidget* parent=0, const char* name=0);

   virtual ~TextStyleConfig();

signals:
   /** Emitted when the user changed text-style settings. */
   void changed();

public slots:
   /** Update the gui elements from the text-style object. */
   virtual void update();

   virtual void changeFont();
   virtual void setColor(const QColor&);
   virtual void alignLeft();
   virtual void alignHCenter();
   virtual void alignRight();
   virtual void alignTop();
   virtual void alignVCenter();
   virtual void alignBottom();

protected:
   QPushButton* createButton(const char* icon, QWidget* parent,
                             const char* slot, QBoxLayout* box=0) const;

protected:
   KoverArtist::TextStyle *mStyle;
   QPushButton *mBtnAlignLeft, *mBtnAlignHCenter, *mBtnAlignRight;
   QPushButton *mBtnAlignTop, *mBtnAlignVCenter, *mBtnAlignBottom;
   KColorButton *mBtnColor;
};


#endif /*textstyleconfig_h*/
