/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORREMOVEJOB_H_
#define _KOMPARATORREMOVEJOB_H_

#include <kio/job.h>

#include "komparatorjob.h"

class KomparatorRemoveJob : public KomparatorJob
{
	Q_OBJECT

	public:
		KomparatorRemoveJob( QWidget *_parent );
		virtual ~KomparatorRemoveJob();

		bool initialize( KURL::List *url_list, bool trash_files, QString status );

		virtual void run();

		const KURL::List &getFinishedList();

	private slots:
		void slotFinished( KIO::Job *job );

	private:
		KURL::List m_url_list;
		bool m_trash_files;
		KURL::List m_finished_list;

		int m_running;
		int m_progress;
		QString m_status;
};

#endif
