/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "kleansweepcfg.h"
#include <qfileinfo.h>

const Utility::EnumMap<DistroPkg> KleanSweepConfig::pkgtype2string[] = {
        {"other", OTHER},
	{"tgz", TGZ},
        {"deb", DPKG},
        {"rpm",   RPM},
        {QString::null}
};

KleanSweepConfig::KleanSweepConfig(): KConfigSkeleton()
{
	QStringList def;
	
	setCurrentGroup("Global");
	def << "/mnt" << "/media" << "/proc" << "/sys" << "/dev";
	addItemStringList("ExcludePaths", glob_excludepth, def);
	addItemBool("ShowProgress", progress, false);
	addItemBool("ShowScore", score, true);
	addItemBool("OptimizeSearch", optsearch, true);
	//addItemInt("OldFilesAge", oldfiles, 30);
	
	setCurrentGroup("Orphaned Files");
	def.clear();
	def << "/usr/local" << "/opt" << "/root" << "/home";
	addItemStringList("ExcludePaths", orphans_excludepath, def);
	addItemString("DistroType", orphans_distrotype, Utility::convert(pkgtype2string, discoverDistroPkg()));

	def.clear();
	def << "/bin" << "/sbin" << "/usr" << "/etc" << "/boot";
	addItemStringList("IncludePaths", orphans_includepath, def);
}

KleanSweepConfig::~KleanSweepConfig()
{
}

KleanSweepConfig& KleanSweepConfig::instance()
{
	static KleanSweepConfig cfg;
	return cfg;
}

QStringList KleanSweepConfig::globalExcludePaths() const
{
	return glob_excludepth;
}

void KleanSweepConfig::globalExcludePaths(const QStringList &list)
{
	glob_excludepth = list;
}

QStringList KleanSweepConfig::orphansExcludePaths() const
{
	return orphans_excludepath;
}

void KleanSweepConfig::orphansExcludePaths(const QStringList &list)
{
	orphans_excludepath = list;
}

QStringList KleanSweepConfig::orphansIncludePaths() const
{
	return orphans_includepath;
}

void KleanSweepConfig::orphansIncludePaths(const QStringList &list)
{
	orphans_includepath = list;
}

bool KleanSweepConfig::showProgress() const
{
	return progress;
}

bool KleanSweepConfig::showScore() const
{
	return score;
}

DistroPkg KleanSweepConfig::distroPackageManager() const
{
	return Utility::convert(pkgtype2string, orphans_distrotype);
}

void KleanSweepConfig::showProgress(bool f)
{
	progress = f;
}

void KleanSweepConfig::showScore(bool f)
{
	score = f;
}

bool KleanSweepConfig::optimizeSearches() const
{
	return optsearch;
}

void KleanSweepConfig::optimizeSearches(bool f)
{
	optsearch = f;
}

/*int KleanSweepConfig::oldFilesAge() const
{
	return oldfiles;
}*/

/*void KleanSweepConfig::oldFilesAge(int d)
{
	oldfiles = d;
}*/

void KleanSweepConfig::distroPackageManager(DistroPkg p)
{
	orphans_distrotype = Utility::convert(pkgtype2string, p);
}

DistroPkg KleanSweepConfig::discoverDistroPkg()
{
	QFileInfo finfo("/var/lib/dpkg/status");
	if (finfo.exists())
		return DPKG;
	finfo.setFile("/var/lib/packages");
	if (finfo.exists())
		return TGZ;
	finfo.setFile("/var/lib/rpm");
	if (finfo.exists())
		return RPM;
	return OTHER;
}

