/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "configdlg.h"
#include "kleansweep.h"
#include "dirlistwidget.h"
#include <qlayout.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <klocale.h>
#include <kleansweepcfg.h>

KleanSweepConfigDialog::KleanSweepConfigDialog(QWidget *parent): KDialogBase(KDialogBase::Tabbed, i18n("KleanSweep settings"), KDialogBase::Apply|KDialogBase::Cancel, KDialogBase::NoDefault, parent, 0, true)
{
	setMinimumSize(500, 380);
	setupGeneralPage();
	setupOrphansPage();
}

KleanSweepConfigDialog::~KleanSweepConfigDialog()
{
}

void KleanSweepConfigDialog::setupGeneralPage()
{
	KleanSweepConfig *cfg = &KleanSweepConfig::instance();

	QFrame *page = addPage(i18n("General"));
	QVBoxLayout *lay = new QVBoxLayout(page, 0, KDialog::spacingHint());
	globalexcl = new DirListWidget(i18n("Directories to exclude (all scans)"), page);
	globalexcl->insertStringList(cfg->globalExcludePaths());
	lay->addWidget(globalexcl);
	showprogress = new QCheckBox(i18n("Show progress"), page);
	showprogress->setChecked(cfg->showProgress());
	lay->addWidget(showprogress);
	showscore = new QCheckBox(i18n("Show score column"), page);
	showscore->setChecked(cfg->showScore());
	lay->addWidget(showscore);
	optimizesearch = new QCheckBox(i18n("Optimize single searches"), page);
	optimizesearch->setChecked(cfg->optimizeSearches());
	optimizesearch->setDisabled(true);
	lay->addWidget(optimizesearch);

	/*QHBoxLayout *lay1 = new QHBoxLayout(lay);
	QLabel *lunused = new QLabel(i18n("Consider file as unused if not accessed within"), page);
	oldfilesage = new QSpinBox(1, 365, 1, page);
	oldfilesage->setSuffix(" " + i18n("days"));
	oldfilesage->setValue(cfg->oldFilesAge());
	oldfilesage->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum));*/
	
	/*lay1->addWidget(lunused);
	lay1->addStretch(1);
	lay1->addWidget(oldfilesage);*/
}

void KleanSweepConfigDialog::setupOrphansPage()
{
	KleanSweepConfig *cfg = &KleanSweepConfig::instance();

	QFrame *page = addPage(i18n("Orphaned files searching"));
	QVBoxLayout *lay = new QVBoxLayout(page, 0, KDialog::spacingHint());

	DistroPkg pkg = cfg->distroPackageManager();

	QVButtonGroup *grp0 = new QVButtonGroup(i18n("Linux distribution"), page);
	rb_deb = new QRadioButton(i18n("Debian/Ubuntu deb-based"), grp0);
	rb_rpm = new QRadioButton(i18n("Fedora Core/Mandriva/Suse or other rpm-based"), grp0);
	rb_other = new QRadioButton(i18n("Other (unsupported)"), grp0);

	if (pkg == RPM)
		rb_rpm->setChecked(true);
	else if (pkg == DPKG)
		rb_deb->setChecked(true);
	else
		rb_other->setChecked(true);
	
	lay->addWidget(grp0);
	
	orphincl = new DirListWidget(i18n("Directories to include"), page);
	orphincl->insertStringList(cfg->orphansIncludePaths());
	orphexcl = new DirListWidget(i18n("Directories to exclude"), page);
	orphexcl->insertStringList(cfg->orphansExcludePaths());
	lay->addWidget(orphincl);
	lay->addWidget(orphexcl);
}

void KleanSweepConfigDialog::slotApply()
{
	KleanSweepConfig *cfg = &KleanSweepConfig::instance();
	//cfg->oldFilesAge(oldfilesage->value());
	cfg->globalExcludePaths(globalexcl->getAllPaths());
	cfg->orphansExcludePaths(orphexcl->getAllPaths());
	cfg->orphansIncludePaths(orphincl->getAllPaths());
	cfg->showScore(showscore->isChecked());
	cfg->showProgress(showprogress->isChecked());
	if (rb_deb->isChecked())
		cfg->distroPackageManager(DPKG);
	else if (rb_rpm->isChecked())
		cfg->distroPackageManager(RPM);
	else
		cfg->distroPackageManager(OTHER);
	cfg->writeConfig();
	QDialog::accept();
}

#include "configdlg.moc"
