# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

require 'singleton'

class FavoriteBoards
  include Singleton

  def initialize
    load
  end

  def load
    @favorites = []

    conf_path = ENV['HOME'] + "/.kita/favorite_board"
    return unless File.exist?(conf_path)

    File::open(conf_path).each_line {|line|
      line.chomp!
      type, id = line.split(",")
      @favorites.push([type, id])
    }
  end

  def register(type, id)
    @favorites.push([type, id])

    conf_path = ENV['HOME'] + "/.kita/favorite_board"
    File::open(conf_path, "w") {|file|
      @favorites.each {|type, id|
        file.puts "#{type},#{id}"
      }
    }
  end

  def delete(type, id)
    @favorites.delete([type, id])

    conf_path = ENV['HOME'] + "/.kita/favorite_board"
    File::open(conf_path, "w") {|file|
      @favorites.each {|type, id|
        file.puts "#{type},#{id}"
      }
    }
  end

  def each
    @favorites.each {|favorite|
      yield favorite
    }
  end
end
