#!/bin/sh
# A Kino export script that outputs to Ogg Theora using gstreamer

# find gst-launch and gst-inspect
isgstlaunch=$( which gst-launch > /dev/null 2>&1 ; echo $? )
isgstlaunch10=$( which gst-launch-0.10 > /dev/null 2>&1 ; echo $? )
isgstinspect=$( which gst-inspect > /dev/null 2>&1 ; echo $? )
isgstinspect10=$( which gst-inspect-0.10 > /dev/null 2>&1 ; echo $? )
gstlaunch=$( ( [ $isgstlaunch -eq 0 ] && echo gst-launch ) || ( [ $isgstlaunch10 -eq 0 ] && echo gst-launch-0.10 ) )
gstinspect=$( ( [ $isgstinspect -eq 0 ] && echo gst-inspect ) || ( [ $isgstinspect10 -eq 0 ] && echo gst-inspect-0.10 ) )

usage()
{
	# Title
	echo "Title: Ogg Theora (gstreamer)"

	# Usable?
	if [ "$gstinspect" != "" ] && [ "$gstlaunch" != "" ]; then
		# we'll use gst-inspect to further validate
		isdvdemux=$( $gstinspect dvdemux > /dev/null ; echo $? ) # good
		isdvdec=$( $gstinspect dvdec > /dev/null ; echo $? ) # good
		isffmpegcolorspace=$( $gstinspect ffmpegcolorspace > /dev/null ; echo $? ) # base
		isoggmux=$( $gstinspect oggmux > /dev/null ; echo $? ) # base
		istheoraenc=$( $gstinspect theoraenc > /dev/null ; echo $? ) # base
		isvorbisenc=$( $gstinspect vorbisenc > /dev/null ; echo $? ) # base
		[ $isdvdemux -eq 0 ] && [ $isdvdec -eq 0 ] && [ $isffmpegcolorspace -eq 0 ] &&
			[ $isoggmux -eq 0 ] && [ $istheoraenc -eq 0 ] && [ $isvorbisenc -eq 0 ] &&
			echo Status: Active || echo Status: Inactive
	else
		# do not require gst-inspect, rather hope the user has the base and good plugin sets if Active
		[ "$gstlaunch" != "" ] && echo Status: Active || echo Status: Inactive
	fi

	# Type
	echo Flags: single-pass file-producer
	
	# Profiles
	echo "Profile: Best Quality (native size)"
	echo "Profile: High Quality (full size)"
	echo "Profile: Medium Quality (medium size)"
	echo "Profile: Broadband Quality (medium size, 564 Kbps)"
	echo "Profile: Low Quality (small size, 128Kbps)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	project="$5"
	aspect="$7"

	# generate filename if missing
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Create metadata options
	title=`awk '/title="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /title=/) z = y + 1; print x[z]; exit}' "$project"`
	artist=`awk '/author="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /author=/) z = y + 1; print x[z]; exit}' "$project"`
	location=`awk '/abstract="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /abstract=/) z = y + 1; print x[z]; exit}' "$project"`
	copyright=`awk '/copyright="/ {split($0, x, "\""); z = 0; for (y in x) if (x[y] ~ /copyright=/) z = y + 1; print x[z]; exit}' "$project"`

	# some versions seem to not overwrite existing files correctly
	rm "$file".ogg > /dev/null 2>&1

	# compute resolutions with square pixels
	if [ "$aspect" = "16:9" ]; then
		if [ "$normalisation" = "pal" ]; then
			full_res_x="1024"
			full_res_y="576"
			med_res_x="512"
			med_res_y="288"
			low_res_x="256"
			low_res_y="144"
		else
			full_res_x="856"
			full_res_y="480"
			med_res_x="424"
			med_res_y="240"
			low_res_x="216"
			low_res_y="120"
		fi
	else
		if [ "$normalisation" = "pal" ]; then
			full_res_x="768"
			full_res_y="576"
			med_res_x="384"
			med_res_y="288"
			low_res_x="192"
			low_res_y="144"
		else
			full_res_x="640"
			full_res_y="480"
			med_res_x="320"
			med_res_y="240"
			low_res_x="160"
			low_res_y="120"
		fi
	fi

	# compute other framerates
	halffps=$( [ "$normalisation" = "pal" ] && echo "25/2" || echo "30000/2002" )

	# locate a deinterlacer, if any, through gst-inspect, if it exists
	if [ "$gstinspect" != "" ]; then
		isdeinterlace=$( $gstinspect deinterlace > /dev/null ; echo $? )
		isffdeinterlace=$( $gstinspect ffdeinterlace > /dev/null ; echo $? )
		deinterlace=$( ( [ $isffdeinterlace -eq 0 ] && echo "ffdeinterlace !" ) || ( [ $isdeinterlace -eq 0 ] && echo "deinterlace !" ) )

		# prefer the ffmpeg dv decoder (better but in the ffmpeg set), but failover to libdv decoder (good set)
		isffdecdvvideo=$( $gstinspect ffdec_dvvideo > /dev/null ; echo $? )
		dvdec=$( [ $isffdecdvvideo -eq 0 ] && echo "ffdec_dvvideo" || echo "dvdec" )
	fi

	# Run the command
	case "$profile" in 
		"0" ) 	$gstlaunch filesrc use-mmap=false location=/dev/stdin ! dvdemux name=demux ! queue ! \
				video/x-dv,systemstream=\(boolean\)false ! $dvdec ! \
				ffmpegcolorspace ! $deinterlace \
				theoraenc quality=63 ! oggmux name=mux ! filesink location="$file".ogg demux. ! \
				audio/x-raw-int ! queue ! audioconvert ! vorbisenc quality=1.0 ! mux. ;;

		"1" ) 	$gstlaunch filesrc use-mmap=false location=/dev/stdin ! dvdemux name=demux ! queue ! \
				video/x-dv,systemstream=\(boolean\)false ! $dvdec ! \
				ffmpegcolorspace ! videocrop left=8 right=8 ! $deinterlace \
				videoscale method=1 ! video/x-raw-yuv,width=$full_res_x,height=$full_res_y,pixel-aspect-ratio=\(fraction\)1/1 ! \
				theoraenc quality=44 ! oggmux name=mux ! filesink location="$file".ogg demux. ! \
				audio/x-raw-int ! queue ! audioconvert ! vorbisenc quality=0.3 ! mux. ;;

		"2" ) 	$gstlaunch filesrc use-mmap=false location=/dev/stdin ! dvdemux name=demux ! queue ! \
				video/x-dv,systemstream=\(boolean\)false ! $dvdec ! videorate ! \
				video/x-raw-yuv ! ffmpegcolorspace ! videocrop left=8 right=8 ! \
				videoscale method=0 ! video/x-raw-yuv,width=$med_res_x,height=$med_res_y,pixel-aspect-ratio=\(fraction\)1/1 ! \
				theoraenc quality=44 ! oggmux name=mux ! filesink location="$file".ogg demux. ! \
				audio/x-raw-int ! queue ! audioconvert ! vorbisenc quality=0.3 ! mux. ;;

		"3" ) 	$gstlaunch filesrc use-mmap=false location=/dev/stdin ! dvdemux name=demux ! queue ! \
				video/x-dv,systemstream=\(boolean\)false ! $dvdec ! videorate ! \
				video/x-raw-yuv,framerate=$halffps ! ffmpegcolorspace ! videocrop left=8 right=8 ! \
				videoscale method=0 ! video/x-raw-yuv,width=$med_res_x,height=$med_res_y,pixel-aspect-ratio=\(fraction\)1/1 ! \
				theoraenc bitrate=500 keyframe-freq=200 ! oggmux name=mux ! filesink location="$file".ogg demux. ! \
				audio/x-raw-int ! queue ! audioresample ! audio/x-raw-int,rate=32000 ! audioconvert ! vorbisenc max-bitrate=64000 ! mux. ;;

		"4" ) 	$gstlaunch filesrc use-mmap=false location=/dev/stdin ! dvdemux name=demux ! queue ! \
				video/x-dv,systemstream=\(boolean\)false ! $dvdec ! videorate ! \
				video/x-raw-yuv,framerate=$halffps ! ffmpegcolorspace ! videocrop left=8 right=8 ! \
				videoscale method=0 ! video/x-raw-yuv,width=$low_res_x,height=$low_res_y,pixel-aspect-ratio=\(fraction\)1/1 ! \
				theoraenc bitrate=84 keyframe-freq=150 ! oggmux name=mux ! filesink location="$file".ogg demux. ! \
				audio/x-raw-int ! queue ! audioresample ! audio/x-raw-int,rate=22050 ! audioconvert ! vorbisenc max-bitrate=44000 ! mux. ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
