/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef _OSDMANAGER_H
#define _OSDMANAGER_H

#include <qstring.h>
#include <qobject.h>
#include <qcolor.h>

class KdetvOSDPlugin;
class PluginFactory;

/**
 * Provides access to the current on-screen-display plugin.
 */
class OSDManager : public QObject
{
	Q_OBJECT

protected:
	friend class Kdetv;
	OSDManager(PluginFactory*, QWidget*);
	virtual ~OSDManager();

	void setScreen(QWidget*);

public slots:
	void displayMisc(const QString& text);
	void displayChannel(int channel, const QString& name);
	void displayMuted(bool muted);
	void displayVolume(int vol);
	void displayVolume(int left, int right);
	/* This is for closed captioning only. Do NOT use it for anything else.  */
	void displayCC(const QString& text);
	void scanPlugins();

	QColor colourKey() const;
	void setColourKey(QColor key);

signals:
	void colourKeyChanged(QColor);

private:
	KdetvOSDPlugin *_osd;
	QWidget *_widget;
	QColor _colourKey;
	PluginFactory *_pf;
};



#endif

