/* yaku.c for kan netmaj */
#include "xnet.h"
#include "strdef.h"
#include "bitmap/textbitmap.h"

static char *kaze_data[] = {
    ton_bits, nan_bits, sya_bits, pei_bits, ie_bits,
};

static int kaze_w = ton_width, kaze_h = ton_height;

Pixel
point_color(point)
     int point;
{
    if (point > 0) return cols.plus;
    else if (point == 0) return cols.nametx;
    else return cols.minus;
}

int ykind, ywho;
global_t *ygp;

draw_result()
{
    int i, j, k, xpoint, x, y, pai;
    int iy[4], mypos;
    int w = win_width(msg3), h = win_height(msg3);
    int idx = 0, col = 0, row = 0;
    char buffer[20];
    global_t *gp;
    struct object obj;

    gp = ygp;
    mypos = 3 - pplayer[vself];

    if (ywho == -1) return;

    win_cleararea(msg3, 0, 0, w, h);
    ThreeDframe2(msg3, 0, 0, w, h, 2);

    if (!ykind) {
	get_obj_from_win(msg3, 0, &obj);
	draw_text(msg3, obj.x, obj.y+obj.hgt/2, cols.title, BGFNT, miscchar[4]);
    
	draw_text(msg3, obj.x, obj.y+obj.hgt+obj.hgt/2, 
		  cols.num, BGFNT, result_str[result[ywho].flag]);
    
	result_cvt_to_int (result + ywho, iy);
    
	get_obj_from_win(msg3, 1, &obj);
	for (i = 0; i < Y_MAX; i++)
	  if (Y_GET (iy, i)) {
	      draw_text(msg3, obj.x+col*obj.wth, obj.y+row*obj.hgt, 
			cols.mess, BGFNT, yaku_str[i]);
	      idx++;
	      row = idx % 6;
	      col = idx / 6;
	  }
	if (result[ywho].dora) {
	    draw_digit(msg3, obj.x+(1+col)*obj.wth-10, obj.y+row*obj.hgt, 
		       obj.wth-10, cols.num, result[ywho].dora);
	    draw_text(msg3, obj.x+col*obj.wth, obj.y+row*obj.hgt, 
		      cols.mess, BGFNT, yaku_str[57]);
	    idx++;
	    row = idx % 6;
	    col = idx / 6;
	}
	if (result[ywho].uradora) {
	    draw_digit(msg3, obj.x+(1+col)*obj.wth-10, obj.y+row*obj.hgt, 
		       obj.wth-10, cols.num, result[ywho].uradora);
	    draw_text(msg3, obj.x+col*obj.wth, obj.y+row*obj.hgt, 
		      cols.mess, BGFNT, yaku_str[58]);
	    idx++;
	    row = idx % 6;
	    col = idx / 6;
	}
	if (result[ywho].akadora) {
	    draw_digit(msg3, obj.x+(1+col)*obj.wth-10, obj.y+row*obj.hgt, 
		       obj.wth-10, cols.num, result[ywho].akadora);
	    draw_text(msg3, obj.x+col*obj.wth, obj.y+row*obj.hgt, 
		      cols.mess, BGFNT, yaku_str[59]);
	    idx++;
	    row = idx % 6;
	    col = idx / 6;
	}
    
	if (result[ywho].flag != RESULT_RYUKYOKU && (result[ywho].who != -1)) {
	    draw_digit(msg3, obj.x+obj.wth-15, obj.y+obj.hgt*6+10, textwidth("222", NFNT), cols.num, result[ywho].fu);
	    draw_text(msg3, obj.x+obj.wth-10, obj.y+obj.hgt*6+10, cols.mess, BGFNT, miscchar[0]);
	    draw_digit(msg3, obj.x+obj.wth+50, obj.y+obj.hgt*6+10, textwidth("222", NFNT), cols.num, result[ywho].fan);
	    draw_text(msg3, obj.x+obj.wth+55, obj.y+obj.hgt*6+10, cols.mess, BGFNT, miscchar[1]);
	}
  
	/* right side */
    
	if (result[ywho].flag != RESULT_RYUKYOKU && (result[ywho].who != -1)) {
	    get_obj_from_win(msg3, 2, &obj);
	    draw_rtext(msg3, obj.x-10, 
		       obj.y-fthsize+textheight(miscchar[3], BGFNT)/2, 
		       cols.mess, BGFNT, miscchar[3]);
	    for (i = 0; i < 5; i++) {
		pai = mt_uradora (gp, i);
		if (pai) draw_pai (msg3, pai, 0, 1, obj.x+i*ftwsize, obj.y);
	    }
	}
  
	for (i = 0; i < 4; i++) {
	    get_obj_from_win(msg3, 3, &obj);
	    j = ((pplayer[i]+mypos)%4)*obj.hgt;
	    get_obj_from_win(msg3, 3, &obj);
	    draw_bitmap(msg3, kaze_data[i], obj.x, obj.y+j-kaze_h/2, 
			kaze_w, kaze_h, cols.kazetx);
	    draw_bitmap(msg3, ie_bits, obj.x+kaze_w, obj.y+j-kaze_h/2, 
			kaze_w, kaze_h, cols.kazetx);

	    get_obj_from_win(msg3, 4, &obj);
	    strncpy(buffer, player[pplayer[i]].name, 8);
	    buffer[8] = '\0';
	    draw_text(msg3, obj.x, obj.y+j, point_color(result[ywho].points[i]), 
		      BGFNT, buffer);
	    draw_digitobject(msg3, 5, cols.num, result[ywho].points[i], 
			     (pplayer[i]+mypos)%4);
	}

	/* hide and ok button */
	set_buttonlabel(result_but, 0, but5_label[0]);
	set_buttonlabel(result_but, 1, but5_label[1]);
	draw_button(result_but);
    }
    else {

	get_obj_from_win(msg3, 4, &obj);
	draw_text(msg3, (w-textwidth(miscchar[5], BGFNT))/2, obj.y/2, 
		  cols.title, BGFNT, miscchar[5]);

	w = obj.wth;
	get_obj_from_win(msg3, 5, &obj);
	w += obj.wth*3+60;
	w = (win_width(msg3)-w)/2;

	for (i = 0; i < 4; i++) {
	    k = pplayer[i];
	    get_obj_from_win(msg3, 4, &obj);
	    j = obj.y+((k+mypos)%4)*obj.hgt;
	    xpoint = player[k].rpoint * 100 + player[k].tpoint * 500;
	    strncpy(buffer, player[k].name, 8);
	    buffer[8] = '\0';
	    x = w;
	    draw_text(msg3, x, j, point_color(xpoint), BGFNT, buffer);
	    x +=obj.wth;
	    get_obj_from_win(msg3, 5, &obj);
	    x +=obj.wth+20;
	    draw_digit(msg3, x, j, obj.wth, point_color(xpoint), player[k].rpoint);
	    x +=obj.wth+20;
	    draw_digit(msg3, x, j, obj.wth, point_color(xpoint), player[k].tpoint);
	    x +=obj.wth+20;
	    draw_digit(msg3, x, j, obj.wth, point_color(xpoint), xpoint);
	}

	/* replay and ok go title button */
	set_buttonlabel(result_but, 0, but5_label[2]);
	set_buttonlabel(result_but, 1, but5_label[3]);
	draw_button(result_but);
    }

    win_flush();
}

extern int selected;

void
result_call(num, sel)
     int num, sel;
{
    selected = sel;
}

ui_result (gp)
     global_t *gp;
{
    int i, j, k, p, x, y, max;
    extern int auto_play;

    ywho = -1;
    set_reg_responsive(pai_sel, 0);
    ykind = 0;
    x = y = 0;
    ygp = gp;
    win_map(msg3);

    for (p = 0; p < 4; p++)
      if (result[p].flag != 0) {
	  if (x) {
	      win_cleararea(main_win, x, y, ftwsize, fthsize);
	      mapping(main_win, x, y, ftwsize, fthsize);
	  }

	  for (i = 0; i < 4; i++) {
	      if (result[p].points[i] > 0) j = i;
	      if (result[p].points[i] < 0) k = i;
	  }

	  if (result[p].flag == 6) { /* ron agari */
	      get_drawing_pos(pplayer[j], 1, &x, &y);
	      x += hand[j].closed_num*ftwsize+ftwsize/4;
	      y = y-8-fthsize;

	      for (max = 0; max < RIVER_MAX; max++)
		if (!rv[k][max].in && !rv[k][max].out)
		  break;

	      draw_pai(main_win, rv[k][max-1].out, 0, 1, x, y+fthsize);
	      mapping(main_win, x, y, ftwsize, fthsize);
	  }

	  ywho = p;
	  draw_result();
	  if (!(auto_play%2))
	    while(1) {
		selected = SEL_NONE;
		while(selected == SEL_NONE)
		    ui_event_wait (gp, 0);
		if (selected == 1 || selected == SEL_CANCEL)
		  break;
		else if (selected == 0) {
		    win_unmap(msg3);
		    while(!win_handle_event());
		    win_map(msg3);
		}
	    }
	  else
	    sleep(2);
      }
    set_reg_responsive(result_but, 0);
    win_unmap(msg3);
    mapping(main_win, 0, 0, win_width(main_win), win_height(main_win));
    win_flush();
}


ui_message_gend (gp)
     global_t *gp;
{
    int i;
    extern int gkind;

    ykind = 1;
    set_reg_responsive(pai_sel, 0);

    ygp = gp;
    win_map(msg3);
  
    draw_result();

    while(1) {
	selected = SEL_NONE;
	while(selected == SEL_NONE)
	    ui_event_wait (gp, 0);
	if (selected == 1) {
	    do_disconnect(gp);
	    term ();
	}
	else if (selected == 0)
	  break;
    }

    if (gkind == PROG_NETMAJ)
      do_disconnect(gp);
    set_reg_responsive(result_but, 0);
    win_unmap(msg3);
    win_flush();
}


draw_msg3()
{
    /*  extern int playing;
	
	if (playing)*/
    draw_result();
    /*  else
	draw_input();*/
}

void
yaku_init()
{
    int i, j, w = 0, h, pos;
    char *sp[2];
    struct object obj[20];

    msg3 = make_window(main_win, "", MASK, 0);

    /* buttons in result */
    for (i = 0; i < 2; i++)
      sp[i] = but5_label[i+2];
    result_but = make_button(msg3, HORIZ, 2, sp, SLFNT, (void *)result_call);

    for (i = 0; i < 60; i++)
      if (w < textwidth(yaku_str[i], BGFNT))
	w = textwidth(yaku_str[i], BGFNT);
    h = textheight(yaku_str[0], BGFNT)+5;
    pos = 20;
    set_object(obj, 0, pos, 20, textwidth(result_str[4], BGFNT), h);
    set_object(obj, 1, pos, 40+nmax(fthsize+5, h*2)+h/2, w+20, h);
    pos += obj[1].wth*2+20;
    set_object(obj, 2, pos, 20+fthsize, ftwsize*4, fthsize);

    i = obj[1].hgt*7+80+nmax(fthsize, obj[0].hgt*2);
    h = nmax(h, kaze_h)+5;
    j = (i - 20 - fthsize - region_height(result_but) - h*4)/2;
    set_object(obj, 3, pos, 20+fthsize+j+h/2, kaze_w*2, h);
    pos += obj[3].wth+10;
    w = textwidth("--------", BGFNT);
#ifndef ASCII_MESSAGE
    w = nmax(w, textwidth("", BGFNT));
#endif
    set_object(obj, 4, pos, obj[3].y, w, h);
    w = textwidth("-22222", NFNT);
    pos += obj[4].wth+10+w;
    set_object2(obj, 5, pos, obj[3].y, w, h, h);

    set_obj_to_win(msg3, 6, obj);

    w = pos + 20;

    resize_win(msg3, w, i);
    set_expose_func(msg3, (void *)draw_msg3);
    move_win(msg3, (win_width(main_win)-w)/2, (win_height(main_win)-i)/2);

    set_reg_position(result_but, w-4-region_width(result_but), 
		     i-4-region_height(result_but));
}
