/* xui.c for kan netmaj */
#include "xnet.h"
#include "bitmap/misc.h"
#include "strdef.h"

int doranum,       /* Ƥɥο */
    rivmax[4],     /* rvκ */
    river_x[4],    /* μΤפxɸ */
    prev_num[4],   /* μפο */
    prev_hand[14], /* μ */
    reachnow[4],   /* Τפ򲣤˸뤫ɤ */
    opkind[4][4];  /* Ĥμ : 5ϲ */

#define hopen(a, b, c) hand[ (a) ].opened[ (b) ][ (c) ]
#define hokind(a, b) hand[ (a) ].opened_kind[ (b) ]

void
draw_digitobject(win, num, col, digit, add)
     int win, num, digit;
     Pixel col;
{
  struct object obj;

  get_obj_from_win(win, num, &obj);
  draw_digit(win, obj.x, obj.y+add*obj.dt, obj.wth, col, digit);
}


/* Ƽ */
void
init_val()
{
  int i, j;
  struct object obj, obj1;

  get_obj_from_win(main_win, 11, &obj);
  get_obj_from_win(main_win, 10, &obj1);
  for (i = 0; i < 4; i++) {
    prev_num[i] = 0;
    rivmax[i] = 0;
    river_x[i] = obj1.x+4;
    reachnow[i] = 0;
    for (j = 0; j < 4; j++)
      opkind[i][j] = 0;
  }
  prev_hand[0] = 0;
  doranum = 0;
}

int gkind;

/* 󥿥ե */
void
ui_init (gp, kind, board)
     global_t *gp;
     int kind;
     char *board;
{
  gkind = kind;
  make_board ();
  message_init ();
  yaku_init ();
  help_init ();

  win_map_normal(main_win);

  make_title();
  sleep(1);
  open_win1(main_win, 100);
  sleep(2);
}


/* ξ֤ɽ */
int
draw_status (gp)
     global_t *gp;
{
  struct object obj;

  if (!ch_dora) return 0;

  ch_dora = 0;

  /* ꡼ο */
  draw_digitobject(main_win, 4, cols.mess, (rest_point/1000), 0);

  /* Ĥ */
  draw_digitobject(main_win, 6, cols.num, mt_rest(gp), 0);

  /* ɥ */
  if (mt_dora(gp, doranum) > 3) {
    get_obj_from_win(main_win, 7, &obj);
    draw_pai (main_win, mt_dora(gp, doranum), 0, 1, 
	      obj.x+(2+doranum)*ftwsize, obj.y+fthsize);
    if (doranum) {
      win_cleararea(main_win, obj.x+(doranum>2)*ftwsize, 2, ftwsize, obj.hgt);
      if (doranum%2)
	draw_pai(main_win, 0, 0, 1, obj.x+(doranum>2)*ftwsize, obj.y+obj.hgt);
    }
    doranum++;
  }
  return 1;
}


/* ץ쥤䡼ξ֤ɽ */
int
draw_player (gp, who)
     global_t *gp;
     int who;
{
  int pp, tpos;

  if (!ch_play && !ch_point) return 0;

  pp = pplayer[who];
  tpos = (pp-pplayer[vself]+3) % 4;

  /* ɽ */
  draw_digitobject(main_win, 14, cols.nametx, 
		   player[pp].gpoint-1000*hand[who].reach, tpos);
  return 1;
}

/* Τפɽ */
int
draw_river (gp, who)
     global_t *gp;
     int who;
{
  int i, max, tpos, attr, x, y, rget, pmrg = ftwsize/4;
  struct object obj1, obj2;
  extern int rv_fixed;

  if (!ch_river[who]) return 0;

  ch_river[who] = 0;

  tpos = (pplayer[who]-pplayer[vself]+3) % 4;
  get_drawing_pos(pplayer[who], 0, &x, &y);

  for (max = 0; max < RIVER_MAX; max++)
    if (!rv[who][max].in && !rv[who][max].out)
      break;

  if ((rivmax[who] == max) && (!rv_fixed)) return 0;

  rivmax[who] = max--;

  attr = rv[who][max].attr;

  if ((T_GET(attr) >> T_SHFT) > 1)
    return 0;
    
  rget = R_GET(attr);
  
  if ((rget >> R_SHFT) == 4) { /*  */
    change_pai_color(main_win, river_x[who], y+fthsize, fywsize+pmrg, fthsize);
    rv_fixed = 0;
    return 1;
  }

  if ((rget >> R_SHFT) != 0) { /* ïĤ줿 */
    win_cleararea(main_win, river_x[who], y, fywsize+pmrg, fthsize);
    rv_fixed = 0;
    return 1;
  }

  get_obj_from_win(main_win, 10, &obj2);
  if (rv_fixed) { /* ֤Τפ򤺤餹 */
    win_copyarea(main_win, main_win, river_x[who]+pmrg, y, 
		 fywsize+pmrg, fthsize, river_x[who], y);
    if ((who+1)%4 != vself && mt_rest (gp))
      draw_pai (main_win, 0, 0, 0, prev_num[(who+1)%4]*ftwsize+x+pmrg, 
		obj2.y+((tpos+1)%4+1)*obj2.hgt-4);

    river_x[who] += (reachnow[who])?fywsize:ftwsize;
    if (reachnow[who]) reachnow[who] = 0;
    return 1;
  }

  /* ʬΥĥפä */
  win_cleararea(main_win, x+prev_num[who]*ftwsize+pmrg, 
		obj2.y+(tpos+1)*obj2.hgt-4-fthsize, ftwsize, fthsize);

  /* ꡼ */
  if (T_GET(attr) == T_RV_RCH) {
    reachnow[who] = 1;
    get_obj_from_win(main_win, 12, &obj1);
    misc2pixmap(main_win, reachbou_xpm, obj1.x, obj1.y+obj2.hgt*tpos);
  }
      
  /* Τɽ */
  draw_pai(main_win, rv[who][max].out, reachnow[who], 1, 
	   river_x[who]+pmrg, y+fthsize);

  return 1;
}


/* פä */
void remove_pais(x, y, num, flag)
     int x, y, num, flag;
{
  win_cleararea(main_win, x, y-fthsize, num*ftwsize+flag*ftwsize/4, fthsize);
}


/* פ򤺤餹 */
void
shift_pais(xx, num, x1, flag)
     int xx, num, x1, flag;
{
  struct object obj, obj2;
  int x, y;

  get_obj_from_win(main_win, 9, &obj);
  get_obj_from_win(main_win, 10, &obj2);
  x = obj.wth+4;
  y = obj.y+4*obj2.hgt-4-fthsize;
  
  win_copyarea(main_win, main_win, x+xx*ftwsize+flag*ftwsize/4, y,
	       ftwsize*num, fthsize, x+x1*ftwsize, y);
  if (flag)
    remove_pais(x+xx*ftwsize+ftwsize/4, y+fthsize, 1, 0);
  else if (x1 < xx)
    remove_pais(x+(x1+num)*ftwsize, y+fthsize, xx-x1, 0);
}


/* פɽ */
int
draw_hand (gp, who)
     global_t *gp;
     int who;
{
  int i, j, k, n, pmrg = ftwsize/4;
  int tpos, pai;
  int opened = 0;
  int x, y;
  struct object obj;
  
  n = hand[who].closed_num;

  if (!ch_hand[who] && !ch_play) return 0;

  ch_hand[who] = 0;

  tpos = (pplayer[who]-pplayer[vself]+3)%4;

  get_drawing_pos(pplayer[who], 1, &x, &y);

  y -= 8;

  opened = !(mt_uradora(gp,0) < 4);

  if (who == vself) {

    if ((prev_num[who] == n) && (!opened)) return 0;

    if ((n%3 != 2) && (prev_num[who]%3 == 1) && (!opened))
      return 0;

    if (opened || hand[who].closed[0] < 4) {
      for (i = 0; i < n-1; i++)
	draw_pai (main_win, hand[who].closed[i], 0, opened, i*ftwsize+x, y);
      draw_pai(main_win, hand[who].closed[i], 0, opened, 
	       i*ftwsize+x+pmrg*(n%3 == 2), y);
      return 1;
    }

    if (n%3 != 2) {
      if (prev_num[who] == 0) {
	for (i = 0; i < n; i++)
	  draw_pai (main_win, hand[who].closed[i], 0, 0, i*ftwsize+x, y);
      }
      else {
	for (i = 0; i < n; i++)
	  if (hand[who].closed[i] != prev_hand[i]) {
	    /* ĥڤǤϤʤ */
	    for (j = n - 1; j >= 0; j--)
	      if (hand[who].closed[j] != prev_hand[j])
		break;

	    if (i == j)
	      /* ڤäפΤȤ˥ĥפ */
	      shift_pais(prev_num[who]-1, 1, i, 1);
	    else if (hand[who].closed[i] == prev_hand[i+1]) {
	      /* פΰˤ */
	      shift_pais(i+1, j-i, i, 0);
	      shift_pais(prev_num[who]-1, 1, j, 1);
	    }
	    else {
	      /* פΰˤ */
	      shift_pais(i, j-i, i+1, 0);
	      shift_pais(prev_num[who]-1, 1, i, 1);
	    }
	    break;
	  }
	remove_pais(n*ftwsize+x, y, prev_num[who]-n, 1);
      }
    }
    else {
      j = 0;
      for (i = 0; i < n - 1; i++)
	if (hand[who].closed[i] != prev_hand[j]) {
	  for (k = j; k < prev_num[who]; k++)
	    if (hand[who].closed[i] == prev_hand[k]) break;

	  if (k == prev_num[who])
	    if (hand[who].closed[i+1] == prev_hand[i]) {
	      for (k = i; k < n - 1; k++)
		if (hand[who].closed[k+1] != prev_hand[k]) break;
	      shift_pais(i, k-i, i+1, 0);
	      draw_pai (main_win, hand[who].closed[i], 0, 0, i*ftwsize+x, y);
	    }
	    else
	      draw_pai (main_win, hand[who].closed[i], 0, 0, i*ftwsize+x, y);
	  else {
	    shift_pais(k, 1, i, 0);
	    j = k;
	  }
	}
	else
	  j++;

      if (n < prev_num[who])
	remove_pais(i*ftwsize+x, y, prev_num[who]-n+3, 1);

      draw_pai (main_win, hand[who].closed[i], 0, opened, i*ftwsize+x+pmrg, y);
    }
    for (i =0; i < n; i++)
      prev_hand[i] = hand[who].closed[i];
  }
  else {
    if ((prev_num[who] == 0) && (n > 0)) {
      remove_pais(x, y, n+4, 0);
      for (i = 0; i < n; i++)
	draw_pai (main_win, hand[who].closed[i], 0, 0, i*ftwsize+x, y);
      prev_num[who] = n;
      return 1;
    }
      
    if (hand[who].closed[0] > 3) {
      for (i = 0; i < n-1; i++)
	draw_pai (main_win, hand[who].closed[i], 0, 1, i*ftwsize+x, y);
      draw_pai (main_win, hand[who].closed[i], 0, 1, 
		i*ftwsize+x+(n%3==2)*pmrg, y);
    } 
    else if (n < prev_num[who]) {
      remove_pais(n*ftwsize+x, y, prev_num[who]-n, 1);
      if (prev_num[who] - n == 3) /* for ankan */
	remove_pais(prev_num[who]*ftwsize+x+pmrg, y, 1, 0);
    }
  }

  prev_num[who] = n;

  /* Ĥפɽ */
  j = 0;
  while(hokind(who, j)) {
    if (!opkind[who][j]) {
      /* ïĤΤĴ٤ */
      switch (hokind(who, j)) 
	{
	case H_TIE :
	  n = 0;
	  break;
	case H_PON :
	  n = (who-hand[who].opened_from[j]+3)%4;
	  break;
	case H_KAN_OPENED :
	  n = (who-hand[who].opened_from[j]+3)%4;
	  if (n == 2) n++;
	  break;
	case H_KAN_CLOSED :
	  n = -1;
	}

      /* Ĥפɽ֤ */
      get_obj_from_win(main_win, 11, &obj);
      x = obj.x - 5;
      for (i = 0; i < j; i++) {
	x = x - ftwsize*2 - fywsize - pmrg/2;
	if (opkind[who][i] == H_KAN_OPENED)
	  x = x - ftwsize;
	else if (opkind[who][i] == H_KAN_CLOSED)
	  x = x + fywsize - ftwsize*2;
      }

      /* פɽ */
      for (k = 3; k >= 0; k--) {
	if (k == 3 && (hokind(who, j) == H_TIE || hokind(who, j) == H_PON))
	  continue;

	pai = hopen(who, j, k);
	if ((hokind(who, j) != H_TIE) && (hokind(who, j) != H_KAN_CLOSED) 
	    && (k >= n)) {
	  switch (n == k) 
	    {
	    case 0 :
	      pai = hopen(who, j, k-1);
	      break;
	    case 1 :
	      if (hokind(who, j) == H_PON)
		pai = hopen(who, j, 2);
	      else
		pai = hopen(who, j, 3);
	    }
	}

	if (hokind(who, j) == H_KAN_CLOSED && k%3)
	  pai = P_INV;

	x -= (n==k)?fywsize:ftwsize;
	draw_pai (main_win, pai, (n==k), 1, x, y);
      }
      opkind[who][j] = hokind(who, j);
      break;
    }
    else if (opkind[who][j] != 5 && opkind[who][j] != hokind(who, j)) {
      /* ʤν */

      /* ïĤΤĴ٤ */
      n = (who-hand[who].opened_from[j]+3)%4;

      /* ɽ֤ */
      get_obj_from_win(main_win, 11, &obj);
      x = obj.x - 5 - ftwsize*2 - fywsize;
      for (i = 0; i < j; i++) {
	x = x - ftwsize*2 - fywsize - pmrg/2;
	if (opkind[who][i] == H_KAN_OPENED)
	  x = x - ftwsize;
	else if (opkind[who][i] == H_KAN_CLOSED)
	  x = x + fywsize - ftwsize*2;
      }
      x = x+n*ftwsize;

      /* פɽ */
      draw_pai (main_win, hopen(who, j, 3), 1, 1, x, y-ftwsize);
      draw_pai (main_win, hopen(who, j, n), 1, 1, x, y);
      opkind[who][j] = 5;
      break;
    }
    j++;
  }
  return 1;
}


ui_key ()
{
  return 0;
}

/* ̽񤭴 */
void
ui_draw (gp, redraw)
     global_t *gp;
     int redraw;
{
  int i, flag = 0;

  while (win_have_event())
    win_handle_event ();

  if (redraw) ch_play = 1;

  if (ch_play)
    board_reset (gp);


  flag += draw_status (gp);
  for (i = 0; i < 4; i++) {
    flag += draw_player (gp, i);
    flag += draw_river (gp, i);
    flag += draw_hand (gp, i);
  }

  if (ch_play)
    board_redraw();
  else if (flag) {
    mapping(main_win, 0, 0, win_width(main_win), win_height(main_win));
    win_flush();
  }

  ch_play = 0;
  ch_point = 0;
}


/* ٥ȤԤ */
int
ui_event_wait (gp, time_out)
     global_t *gp;
     int time_out;
{
  fd_set fds;
  struct timeval to, *top;
  int fd, fd2, xfd, maxfd, flag = 0;
  extern int readable_socket;

  top = 0;

  fd = callback_fd(gp);
  fd2 = callback_fd2(gp);
  if (fd < 0 || readable_socket) {
      while (win_have_event ()) {
	  win_handle_event ();
      }
      return;
  }

  xfd = get_connection_number();
  FD_ZERO (&fds);
  FD_SET (0, &fds);
  FD_SET (fd, &fds);
  FD_SET (xfd, &fds);
  if (fd2 >= 0) FD_SET(fd2, &fds);
  if (time_out >= 0) {
    to.tv_sec = time_out / 10;
    to.tv_usec = (time_out % 10) * 100000;
    top = &to;
  }

  maxfd = nmax(fd, xfd);
  if (fd2 >= 0) maxfd = nmax(fd2, maxfd);

  if (-1 == select(maxfd+1, &fds, (fd_set *) 0, (fd_set *) 0, top)) {
      while (win_have_event ()) {
	  win_handle_event ();
      }
      return;
  }

  if ((fd>0 && FD_ISSET (fd, &fds)) || (fd2>0 && FD_ISSET(fd2,&fds)))
    readable_socket = 1;

  if (FD_ISSET (xfd, &fds)) {
      while (win_have_event ()) {
	  win_handle_event ();
      }
  }
}


void
ui_term() {};

popup() {
    return 0;
}

ui_menu() {
    return 0;
}
