/* pixmap.c for kan netmaj */
#include "xnet.h"
#include "bitmap/pai.h"

static char **pai_data[] = {
  NULL, 
  man1_xpm, man2_xpm, man3_xpm, man4_xpm, man5_xpm, 
  man6_xpm, man7_xpm, man8_xpm, man9_xpm, 
  pin1_xpm, pin2_xpm, pin3_xpm, pin4_xpm, pin5_xpm, 
  pin6_xpm, pin7_xpm, pin8_xpm, pin9_xpm, 
  sou1_xpm, sou2_xpm, sou3_xpm, sou4_xpm, sou5_xpm, 
  sou6_xpm, sou7_xpm, sou8_xpm, sou9_xpm, 
  ton_xpm, nan_xpm, sya_xpm, pei_xpm, haku_xpm, hatu_xpm, cyun_xpm,
};

static char **redpai_data[] = {
  man5r_xpm, pin5r_xpm, sou5r_xpm,
};


XImage *paiimage[35], *dpaiimage[35];
XImage *redpaiimage[3], *dredpaiimage[3];
XImage *waku[3], *rev[2];
int flw1, flw2;

void
draw_pai(win, n, reach, opened, x, y)
     int n, reach, opened, x, y, win;
/* (x, y) :  */
{
  int i, j, k;
  XImage *image, *pai;

  j = n/4;
  if (n<0 || n>=(37*4)) abort();

  if (n == 20 || n == 56 || n == 92) /*  */
    if (opened)
      pai = redpaiimage[j/9];
    else
      pai = dredpaiimage[j/9];
  else
    if (opened)
      pai = paiimage[j];
    else
      pai = dpaiimage[j];
      
  if (reach) {
    image = XSubImage(waku[2], 0, 0, fywsize, fyhsize);
    for (i = 0; i < phsize; i++)
      for (j = 0; j < pwsize; j++)
	XPutPixel(image, i+flw1, pwsize-1+flw1-j, XGetPixel(pai, j, i));
    put_image(win, image, x, y-fyhsize, fywsize, fyhsize);
    XDestroyImage(image);
  } 
  else
    if (j != 0) {
      put_image(win, waku[opened], x, y-fthsize, ftwsize, fthsize);
      put_image(win, pai, x+flw1, y+flw1+flw2*(!opened)-fthsize, 
		pwsize, phsize);
    }
    else
      put_image(win, rev[opened], x, y-fthsize, ftwsize, fthsize);
}

extern struct colors_set cols;

void
change_pai_color(win, x, y, w, h)
     int x, y, w, h, win;
/* (x, y) :  */
{
  XImage *image;
  int i, j;
  Pixel pix;

  get_image(win, &image, x, y-h, w, h);
  for (i = 0; i < h; i++)
    for (j = 0; j < w; j++) {
      pix = XGetPixel(image, j, i);
      if (pix == cols.pai || pix == cols.darkpai1)
	XPutPixel(image, j, i, cols.darkpai3);
    }
  put_image(win, image, x, y-h, w, h);
  XDestroyImage(image);
}


void
create_darkpai(image, dimage)
     XImage *image, **dimage;
{
  int i, j;

  *dimage = XSubImage(image, 0, 0, pwsize, phsize);
  for (i = 0; i < phsize; i++)
    for (j = 0; j < pwsize; j++)
      if (XGetPixel(*dimage, j, i) == cols.pai)
	XPutPixel(*dimage, j, i, cols.darkpai1);
}



extern Display *display;
extern GC gc;
extern int screen;

void
create_frame()
{
  Pixmap frame, create_pixmap();
  int f1, f2;
  Pixmap white = WhitePixel(display, screen);

  f1 = (4*flw2)/9;
  f2 = flw2-f1;

  frame = create_pixmap(fywsize, fthsize);

  /* tate close frame */
  XSetForeground (display, gc, cols.darkpai2);
  XFillRectangle(display, frame, gc, 0, 0, ftwsize, fthsize);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 1, f1, ftwsize-2, fthsize-1-f1);
  XSetForeground (display, gc, cols.rev1);
  XFillRectangle (display, frame, gc, 0, 0, ftwsize, f1);
  XSetForeground (display, gc, white);
  XFillRectangle (display, frame, gc, 1, f1, ftwsize-3, fthsize-2-f1);
  XSetForeground (display, gc, cols.pai);
  XFillRectangle (display, frame, gc, 2, f1, ftwsize-4, f2);
  XSetForeground (display, gc, cols.board);
  XFillRectangle (display, frame, gc, 0, 0, 3, 1);
  XFillRectangle (display, frame, gc, ftwsize-3, 0, 3, 1);
  XDrawPoint(display, frame, gc, 0, 1);
  XDrawPoint(display, frame, gc, 0, fthsize-1);
  XDrawPoint(display, frame, gc, ftwsize-1, 1);
  XDrawPoint(display, frame, gc, ftwsize-1, fthsize-1);

  waku[0] = XGetImage(display, frame, 0, 0, ftwsize, fthsize, 
			   AllPlanes, ZPixmap);

  /* tate open frame */
  XSetForeground (display, gc, cols.darkpai2);
  XFillRectangle(display, frame, gc, 0, 0, ftwsize, fthsize);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 1, 1, ftwsize-2, fthsize-1-f1);
  XSetForeground (display, gc, cols.rev5);
  XFillRectangle (display, frame, gc, 0, fthsize-f1, ftwsize, f1);
  XSetForeground (display, gc, white);
  XFillRectangle (display, frame, gc, 1, 1, ftwsize-3, fthsize-1-f1);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 2, fthsize-flw2, ftwsize-4, f2);
  XSetForeground (display, gc, cols.board);
  XFillRectangle (display, frame, gc, 0, fthsize-1, 3, 1);
  XFillRectangle (display, frame, gc, ftwsize-3, fthsize-1, 3, 1);
  XDrawPoint(display, frame, gc, 0, 0);
  XDrawPoint(display, frame, gc, 0, fthsize-2);
  XDrawPoint(display, frame, gc, ftwsize-1, 0);
  XDrawPoint(display, frame, gc, ftwsize-1, fthsize-2);

  waku[1] = XGetImage(display, frame, 0, 0, ftwsize, fthsize, 
			   AllPlanes, ZPixmap);

  /* yoko open frame */
  XSetForeground (display, gc, cols.darkpai2);
  XFillRectangle(display, frame, gc, 0, 0, fywsize, fyhsize);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 1, 1, fywsize-2, fyhsize-1-f1);
  XSetForeground (display, gc, cols.rev5);
  XFillRectangle (display, frame, gc, 0, fyhsize-f1, fywsize, f1);
  XSetForeground (display, gc, white);
  XFillRectangle (display, frame, gc, 1, 1, fywsize-3, fyhsize-1-f1);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 2, fyhsize-flw2, fywsize-4, f2);
  XSetForeground (display, gc, cols.board);
  XFillRectangle (display, frame, gc, 0, fyhsize-1, 3, 1);
  XFillRectangle (display, frame, gc, fywsize-3, fyhsize-1, 3, 1);
  XDrawPoint(display, frame, gc, 0, 0);
  XDrawPoint(display, frame, gc, 0, fyhsize-2);
  XDrawPoint(display, frame, gc, fywsize-1, 0);
  XDrawPoint(display, frame, gc, fywsize-1, fyhsize-2);

  waku[2] = XGetImage(display, frame, 0, 0, fywsize, fyhsize, 
			   AllPlanes, ZPixmap);

  XFreePixmap(display, frame);
}


void
create_revpai()
{
  Pixmap frame, create_pixmap();
  int f1, f2;

  f1 = (4*flw2)/9;
  f2 = flw2-f1;

  frame = create_pixmap(ftwsize, fthsize);

  /* rev1 */
  XSetForeground (display, gc, cols.board);
  XFillRectangle(display, frame, gc, 0, 0, ftwsize, fthsize);
  XSetForeground (display, gc, cols.pai);
  XFillRectangle (display, frame, gc, 1, 0, ftwsize-2, f2);
  XSetForeground (display, gc, cols.darkpai2);
  XFillRectangle (display, frame, gc, 0, 1, 1, f2-1);
  XFillRectangle (display, frame, gc, ftwsize-1, 1, 1, f2-1);
  XSetForeground (display, gc, cols.rev1);
  XFillRectangle (display, frame, gc, 0, f2, ftwsize, f1);
  XSetForeground (display, gc, cols.rev1);
  XFillRectangle (display, frame, gc, 0, flw2-2, 1, fthsize-flw2);
  XSetForeground (display, gc, cols.rev2);
  XFillRectangle (display, frame, gc, 1, flw2-1, 2, fthsize-flw2);
  XSetForeground (display, gc, cols.rev3);
  XFillRectangle (display, frame, gc, 3, flw2, ftwsize-6, fthsize-flw2);
  XSetForeground (display, gc, cols.rev4);
  XFillRectangle (display, frame, gc, ftwsize-3, flw2-1, 2, fthsize-flw2);
  XSetForeground (display, gc, cols.rev5);
  XFillRectangle (display, frame, gc, ftwsize-1, flw2-2, 1, fthsize-flw2);

  rev[0] = XGetImage(display, frame, 0, 0, ftwsize, fthsize, 
			   AllPlanes, ZPixmap);

  /* rev2 */
  XSetForeground (display, gc, cols.board);
  XFillRectangle(display, frame, gc, 0, 0, ftwsize, fthsize);
  XSetForeground (display, gc, cols.darkpai1);
  XFillRectangle (display, frame, gc, 1, fthsize-f2, ftwsize-2, f2);
  XSetForeground (display, gc, cols.darkpai2);
  XFillRectangle (display, frame, gc, 0, fthsize-f2, 1, f2-1);
  XFillRectangle (display, frame, gc, ftwsize-1, fthsize-f2, 1, f2-1);
  XSetForeground (display, gc, cols.rev5);
  XFillRectangle (display, frame, gc, 0, fthsize-flw2, ftwsize, f1);
  XSetForeground (display, gc, cols.rev1);
  XFillRectangle (display, frame, gc, 0, 2, 1, fthsize-flw2);
  XSetForeground (display, gc, cols.rev2);
  XFillRectangle (display, frame, gc, 1, 1, 2, fthsize-flw2);
  XSetForeground (display, gc, cols.rev3);
  XFillRectangle (display, frame, gc, 3, 0, ftwsize-6, fthsize-flw2);
  XSetForeground (display, gc, cols.rev4);
  XFillRectangle (display, frame, gc, ftwsize-3, 1, 2, fthsize-flw2);
  XSetForeground (display, gc, cols.rev5);
  XFillRectangle (display, frame, gc, ftwsize-1, 2, 1, fthsize-flw2);

  rev[1] = XGetImage(display, frame, 0, 0, ftwsize, fthsize, 
			   AllPlanes, ZPixmap);

  XFreePixmap(display, frame);
}


int
make_image()
{
  int i, j;

  for (i = 1; i < 35; i++) {
    if (create_imagefromdata (pai_data[i], &(paiimage[i])) < 0) {
      for (j = 1; j < i; j++) {
	XDestroyImage(paiimage[j]);
	XDestroyImage(dpaiimage[j]);
      }
      return 1;
    }
    create_darkpai(paiimage[i], &(dpaiimage[i]));
  }

  for (i = 0; i < 3; i++) {
    if (create_imagefromdata (redpai_data[i], &(redpaiimage[i])) < 0) {
      for (j = 1; j < 35; j++) {
	XDestroyImage(paiimage[j]);
	XDestroyImage(dpaiimage[j]);
      }
      for (j = 0; j < i; j++) {
	XDestroyImage(redpaiimage[j]);
	XDestroyImage(dredpaiimage[j]);
      }
      return 1;
    }
    create_darkpai(redpaiimage[i], &(dredpaiimage[i]));
  }

  create_frame();
  create_revpai();

  return 0;
}

void
pai_init ()
{
  if (make_image()) {
    make_colormap();
    init_color();
    make_image();
  }
}

int
xpm_width(data)
     char **data;
{
  int w;

  sscanf(data[0], "%d ", &w);
  return w;
}

int
xpm_height(data)
     char **data;
{
  int dummy, h;

  sscanf(data[0], "%d %d ", &dummy, &h);
  return h;
}

void 
misc2pixmap(win, data, x, y)
     char **data;
     int x, y, win;
{
  XImage *image;
  int w = xpm_width(data), h = xpm_height(data);

  create_imagefromdata (data, &image);
  put_image(win, image, x, y, w, h);
  XDestroyImage(image);
}

void
set_pai_size()
{
  pwsize = xpm_width(pai_data[1]);
  phsize = xpm_height(pai_data[1]);

  flw1 = 2;
  flw2 = phsize/7+1;
  ftwsize = pwsize+2*flw1;
  fthsize = phsize+2*flw1+flw2;
  fywsize = phsize+2*flw1;
  fyhsize = pwsize+2*flw1+flw2;
}
