/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "pubdic.h"
#include "canna.h"
#include "cannadic.h"
#include "worditem.h"

#include <qfile.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

Pubdic::Pubdic( QString name )
{
	m_dicname = name;

	if( m_dicname.isEmpty() ){
		KMessageBox::sorry( (QWidget*)0, i18n("filename is empty.") );
		return;
	}
	QFile file( m_dicname );
	if ( !file.open( IO_ReadOnly ) ){
		KMessageBox::sorry( (QWidget*)0, i18n("KannaDic can not open the file.") );
		return;
	}
	QTextStream ts( &file );
	QString from, to, type;
	while( !ts.atEnd() ){
		QString str( ts.readLine() );
		str = Canna::escape( str );
		if( str.isEmpty() ){
			continue;
		}else if( str.at(0) == '#' ){
			continue;
		}
		QTextStream line( str, IO_ReadOnly );
		Word word;
		line >> from;
		word.from = Canna::unescape( word.from );
		while( !line.atEnd() ){
			QString temp;
			line >> temp;
			if( temp[0] == '#' ){
				type = temp;
			}else{
				to = Canna::unescape( temp );
				Word word;
				word.type = CannaDic::instance().code2type( type );
				word.from = from;
				word.to = to;
				word.freq = 1;
				push_back( word );
			}
		}
	}
	file.close();
}


Pubdic::~Pubdic()
{
}

bool Pubdic::expand( KListView* lvw )
{
	WordItem* word;
	m_count = size();
	m_counter = 0;
	m_progress = 0;
	for( iterator it = begin(); it != end(); ++it ){
		word = new WordItem( lvw, (*it) );
		lvw->insertItem( word );
		countup();
	}
	emit progress( 100 );
	return true;
}

bool Pubdic::save( KListView* lvw )
{
	QValueList<Word> view;
	QListViewItemIterator it( lvw );
	while( it.current() ){
		WordItem* word = (WordItem*)it.current();
		view.push_back( word->word() );
		++it;
	}
	qHeapSort( view );
	QFile file( m_dicname );
	if ( !file.open( IO_WriteOnly ) ){
		KMessageBox::sorry( (QWidget*)0, i18n("Can not open file") );
		return false;
	}
	QTextStream ts( &file );
	QString from = QString::null;
	QString type = QString::null;
	QString buf = "";
	for( iterator it = view.begin(); it != view.end() ; ++it ){
		if( (*it).from != from ){
			if( from != QString::null  ){
				ts << endl;
			}
			from = (*it).from;
			type = QString::null;
			ts << from;
		}
		if( (*it).type.code != type ){
			type = (*it).type.code;
			ts << " " << type;
		}
		ts << " " << (*it).to;
	}
	return true;
}

bool Pubdic::mkdic( QString name )
{
	QFile file( name );
	if ( !file.open( IO_WriteOnly ) ){
		return false;
	}
	file.close();
	return true;
}

void Pubdic::rmdic()
{
	emit deleted( false );
}

void Pubdic::countup()
{
	int percent = ++m_counter*100/m_count;
	if( percent > m_progress + 1 ){
		m_progress = percent;
		emit progress( percent );
	}
}

