/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "multieditcommand.h"
#include "dlgedit.h"
#include <qapplication.h>
#include <qcursor.h>
#include <qheader.h>

MultiEditCommand::MultiEditCommand( KListView* parent )
{
	m_parent = parent;
	m_succeed = false;
	dlgEdit dlgedit( parent );
	dlgedit.setEditMode( dlgEdit::MULTIEDIT, parent->header()->count() == 4 );

	QPtrList< QListViewItem > selectedItems = parent->selectedItems();
	QListViewItem* item = selectedItems.first();
	parent->ensureItemVisible( item );
	dlgedit.setWordItem( (WordItem*)item );
	for( ; item; item = selectedItems.next() ){
		dlgedit.addType( ((WordItem*)item)->word().type );
	}
	dlgedit.exec();
	if( dlgedit.result() ){
		for( item = selectedItems.first(); item; item = selectedItems.next() ){
			Word before = ((WordItem*)item)->word();
			Word after(before);
			if( dlgedit.isTypeEnabled() ){
				after.type = dlgedit.word().type;
			}
			if( dlgedit.isFreqEnabled() ){
				after.freq = dlgedit.word().freq;
			}
			m_item.append( (WordItem*)item );
			m_before.push_back( before );
			m_after.push_back( after );
			m_succeed = true;
		}
	}else{
		m_succeed = false;
	}
}

bool MultiEditCommand::succeed()
{
	return m_succeed;
}

QString MultiEditCommand::name() const
{
	return i18n( "edited %1 word(s)" ).arg( m_item.count() );
}

void MultiEditCommand::execute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( unsigned int i = 0; i != m_item.count(); i++ ){
		m_item.at(i)->setWord( m_after[i] );
		m_parent->setSelected( m_item.at(i), true );
	}
	m_parent->ensureItemVisible( m_item.at(m_item.count()-1) );
	QApplication::restoreOverrideCursor();
}

void MultiEditCommand::unexecute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( unsigned int i = 0; i != m_item.count(); i++ ){
		m_item.at(i)->setWord( m_before[i] );
		m_parent->setSelected( m_item.at(i), true );
	}
	m_parent->ensureItemVisible( m_item.at(m_item.count()-1) );
	QApplication::restoreOverrideCursor();
}
