/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dixchange.h"
#include "canna.h"
#include "cannadic.h"
#include "worditem.h"

#include <qfile.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>
#include <qdom.h>
#include <qheader.h>
#include <qtextstream.h>

Dixchange::Dixchange( QString name )
{
	m_dicname = name;

	if( m_dicname.isEmpty() ){
		KMessageBox::sorry( (QWidget*)0, i18n("filename is empty.") );
		return;
	}
	QFile file( m_dicname );
	if ( !file.open( IO_ReadOnly ) ){
		KMessageBox::sorry( (QWidget*)0, i18n("KannaDic can not open the file.") );
		return;
	}

	QDomDocument* doc = new QDomDocument();
	if( !doc->setContent( &file ) ){
		KMessageBox::sorry( (QWidget*)0, i18n("KannaDic can not parse this file.") );
		return;
	}

	QDomElement editor = doc->documentElement();
	QDomNode child = editor.firstChild();
	Word word;
	while( !child.isNull() ){
		QDomElement elem = child.toElement();
		word.from = elem.attribute("phonetic");
		word.to = elem.attribute("literal");
		word.type = CannaDic::instance().code2type( elem.attribute("cclass") );
		word.freq = elem.attribute("score").toUInt();
		push_back( word );
		child = child.nextSibling();
	}
	file.close();
}


Dixchange::~Dixchange()
{
}

bool Dixchange::expand( KListView* lvw )
{
	WordItem* word;
	m_count = size();
	m_counter = 0;
	m_progress = 0;
	for( iterator it = begin(); it != end(); ++it ){
		word = new WordItem( lvw, (*it) );
		lvw->insertItem( word );
		countup();
	}
	emit progress( 100 );
	return true;
}

bool Dixchange::save( KListView* lvw )
{
	QFile file( m_dicname );
	if ( !file.open( IO_WriteOnly ) ){
		KMessageBox::sorry( (QWidget*)0, i18n("Can not open file") );
		return false;
	}

	QDomDocument doc;
	doc.appendChild( doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\"" ) );
	QDomElement editor = doc.createElement( "dixchange" );
	editor.setAttribute( "version", "0.1" );
	QListViewItemIterator it( lvw );
	while ( it.current() ) {
		QDomElement e = doc.createElement( "word" );
		e.setAttribute( "phonetic", ((WordItem*)it.current())->word().from );
		e.setAttribute( "literal", ((WordItem*)it.current())->word().to );
		e.setAttribute( "pos", ((WordItem*)it.current())->word().type.category );
		e.setAttribute( "cclass", ((WordItem*)it.current())->word().type.code );
		if( lvw->header()->count() == 4 ){
			e.setAttribute( "score", ((WordItem*)it.current())->word().freq );
		}
		editor.appendChild( e );
		++it;
	}
	doc.appendChild( editor );
	QTextStream str( &file );
	str << doc;
	file.close();
	return true;
}

void Dixchange::rmdic()
{
	emit deleted( false );
}

bool Dixchange::mkdic( QString name )
{
	QFile file( name );
	if ( !file.open( IO_WriteOnly ) ){
		return false;
	}

	QDomDocument doc;
	doc.appendChild( doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\"" ) );
	QDomElement editor = doc.createElement( "dixchange" );
	editor.setAttribute( "version", "0.1" );
	doc.appendChild( editor );
	QTextStream str( &file );
	str << doc;
	file.close();
	return true;
}

void Dixchange::countup()
{
	int percent = ++m_counter*100/m_count;
	if( percent > m_progress + 1 ){
		m_progress = percent;
		emit progress( percent );
	}
}
