// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/textbuffer.h>
#include <gtkmm/private/textbuffer_p.h>

// -*- c++ -*-
/* $Id: textbuffer.ccg,v 1.8 2006/11/20 09:19:49 murrayc Exp $ */

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktextbuffer.h>
#include <gtk/gtktextbufferrichtext.h>
#include <glib/gslist.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>


/*
static guint8* SignalProxy_Serialize(GtkTextBuffer* , GtkTextBuffer* content_buffer,
                                                   const GtkTextIter* start, const GtkTextIter* end,
                                                   gsize* length,
                                                   gpointer user_data)
{
  Gtk::TextBuffer::SlotSerialize* the_slot = static_cast<Gtk::TextBuffer::SlotSerialize*>(user_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    return (*the_slot)(Glib::wrap(content_buffer), Glib::wrap(start), Glib::wrap(end), *length);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

static void SignalProxy_Serialize_gtk_callback_destroy(void* user_data)
{
  delete static_cast<Gtk::TextBuffer::SlotSerialize*>(user_data);
}

static gboolean SignalProxy_Deserialize(GtkTextBuffer* , GtkTextBuffer* content_buffer,
                                                   GtkTextIter* iter, const guint8* data,
                                                   gsize length, gboolean create_tags,
                                                   gpointer user_data,
                                                   GError** )
{
  Gtk::TextBuffer::SlotDeserialize* the_slot = static_cast<Gtk::TextBuffer::SlotDeserialize*>(user_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    (*the_slot)(Glib::wrap(content_buffer, true), Glib::wrap(iter), data, length, create_tags);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    //TODO: Fill the error parameter.
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

static void SignalProxy_Deserialize_gtk_callback_destroy(void* user_data)
{
  delete static_cast<Gtk::TextBuffer::SlotDeserialize*>(user_data);
}
*/

namespace Gtk
{

typedef TextChildAnchor ChildAnchor; //Help the code-generator so that it does not have to fully qualify this type in the .cc file.

TextBuffer::TextBuffer(const Glib::RefPtr<TagTable>& tag_table)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(textbuffer_class_.init(), "tag_table",Glib::unwrap(tag_table), static_cast<char*>(0)))
{}

Glib::RefPtr<TextBuffer::Tag> TextBuffer::create_tag(const Glib::ustring& tag_name)
{
  //gtk_text_buffer_create_tag takes a varargs list of property names and values.
  //gtkmm coders should use the Tag.set_* method instead.
  return Glib::wrap(gtk_text_buffer_create_tag(gobj(), tag_name.c_str(), (char*)0), true); //true = take_copy.
  //We have to take a copy because gtk_text_buffer_create_tag() doesn't ref for us, for no real reason.
}

Glib::RefPtr<TextBuffer::Tag> TextBuffer::create_tag()
{
  //gtk_text_buffer_create_tag takes a varargs list of property names and values.
  //gtkmm coders should use the Tag.set_* method instead.
  return Glib::wrap(gtk_text_buffer_create_tag(gobj(), (const char*)0, (char*)0), true); //true = take_copy.
  //We have to take a copy because gtk_text_buffer_create_tag() doesn't ref for us, for no real reason.
}

Glib::RefPtr<TextBuffer::Mark>
TextBuffer::create_mark(const TextBuffer::iterator& where, bool left_gravity)
{
  return Glib::wrap(gtk_text_buffer_create_mark(
      gobj(), 0, const_cast<GtkTextIter*>(where.gobj()), left_gravity),
      true); // acquire reference
}

TextBuffer::iterator TextBuffer::get_iter_at_line_offset(int line_number, int char_offset)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line_offset(gobj(), iter.gobj(), line_number, char_offset);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_line_index(int line_number, int byte_index)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line_index(gobj(), iter.gobj(), line_number, byte_index);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_offset(int char_offset)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_offset(gobj(), iter.gobj(), char_offset);
  return iter;
}

TextBuffer::iterator TextBuffer::get_iter_at_line(int line_number)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_line(gobj(), iter.gobj(), line_number);
  return iter;
}

TextBuffer::iterator TextBuffer::begin()
{
  iterator iter;
  gtk_text_buffer_get_start_iter(gobj(), iter.gobj());
  return iter;
}

TextBuffer::iterator TextBuffer::end()
{
  iterator iter;
  gtk_text_buffer_get_end_iter(gobj(), iter.gobj());
  return iter;
}

void TextBuffer::get_bounds(iterator& range_begin, iterator& range_end)
{
  gtk_text_buffer_get_bounds(gobj(), range_begin.gobj(), range_end.gobj());
}

TextBuffer::iterator TextBuffer::get_iter_at_mark(const Glib::RefPtr<Mark>& mark)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_mark(gobj(), iter.gobj(), mark->gobj());
  return iter;
}

void TextBuffer::set_text(const Glib::ustring& text)
{
  gtk_text_buffer_set_text(gobj(), text.data(), text.bytes());
}

void TextBuffer::set_text(const char* text_begin, const char* text_end)
{
  gtk_text_buffer_set_text(gobj(), text_begin, text_end - text_begin);
}

#ifndef GTKMM_DISABLE_DEPRECATED

void TextBuffer::assign(const Glib::ustring& text)
{
  gtk_text_buffer_set_text(gobj(), text.data(), text.bytes());
}

void TextBuffer::assign(const char* text_begin, const char* text_end)
{
  gtk_text_buffer_set_text(gobj(), text_begin, text_end - text_begin);
}
#endif // GTKMM_DISABLE_DEPRECATED


TextBuffer::iterator TextBuffer::insert(const iterator& pos, const Glib::ustring& text)
{
  // gtk_text_buffer_insert() modifies the iterator, but that's not the
  // STL way so we give it something that we don't mind it modifying.
  iterator iterCopy (pos);
  gtk_text_buffer_insert(gobj(), iterCopy.gobj(), text.data(), text.bytes());

  // According to the gtk_text_buffer_insert() docs, the "default signal handler
  // revalidates it to point to the end of the inserted text".
  return iterCopy;
}

TextBuffer::iterator TextBuffer::insert(const iterator& pos, const char* text_begin, const char* text_end)
{
  // gtk_text_buffer_insert() modifies the iterator, but that's not the
  // STL way so we give it something that we don't mind it modifying.
  iterator iterCopy (pos);
  gtk_text_buffer_insert(gobj(), iterCopy.gobj(), text_begin, text_end - text_begin);

  // According to the gtk_text_buffer_insert() docs, the "default signal handler
  // revalidates it to point to the end of the inserted text".
  return iterCopy;
}

TextBuffer::iterator TextBuffer::insert_pixbuf(const iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  iterator iterCopy (pos);
  gtk_text_buffer_insert_pixbuf(gobj(), iterCopy.gobj(), pixbuf->gobj());
  return iterCopy;
}

TextBuffer::iterator TextBuffer::insert_child_anchor(const iterator& pos,
                                                     const Glib::RefPtr<ChildAnchor>& anchor)
{
  // Copy the iterator. It might be changed because it is used as a signal parameter internally.
  iterator iterCopy (pos);
  gtk_text_buffer_insert_child_anchor(gobj(), iterCopy.gobj(), Glib::unwrap(anchor));
  return iterCopy;
}

Glib::RefPtr<ChildAnchor> TextBuffer::create_child_anchor(const iterator& pos)
{
  // Copy the iterator. It might be changed because it is used as a signal parameter internally.
  iterator iterCopy (pos);
  return Glib::wrap(gtk_text_buffer_create_child_anchor(gobj(), iterCopy.gobj()),
                    true); // The function does not do a ref for us.
}

void TextBuffer::insert_at_cursor(const Glib::ustring& text)
{
  gtk_text_buffer_insert_at_cursor(gobj(), text.data(), text.bytes());
}

void TextBuffer::insert_at_cursor(const char* text_begin, const char* text_end)
{
  gtk_text_buffer_insert_at_cursor(gobj(), text_begin, text_end - text_begin);
}

std::pair<TextBuffer::iterator,bool>
TextBuffer::insert_interactive(const iterator& pos, const Glib::ustring& text, bool default_editable)
{
  // Since we have to copy the iterator anyway we can as well create the
  // std::pair now.  That saves another copy later (mind you, TextIter is
  // a heavy struct), and allows modern compilers to apply the return value
  // optimization.
  std::pair<iterator,bool> pair_iter_success (pos, false);

  pair_iter_success.second = gtk_text_buffer_insert_interactive(
      gobj(), pair_iter_success.first.gobj(), text.data(), text.bytes(), default_editable);

  return pair_iter_success;
}

std::pair<TextBuffer::iterator,bool>
TextBuffer::insert_interactive(const iterator& pos, const char* text_begin, const char* text_end,
                               bool default_editable)
{
  // Since we have to copy the iterator anyway we can as well create the
  // std::pair now.  That saves another copy later (mind you, TextIter is
  // a heavy struct), and allows modern compilers to apply the return value
  // optimization.
  std::pair<iterator,bool> pair_iter_success (pos, false);

  pair_iter_success.second =  gtk_text_buffer_insert_interactive(
      gobj(), pair_iter_success.first.gobj(), text_begin, text_end - text_begin, default_editable);

  return pair_iter_success;
}

bool TextBuffer::insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable)
{
  return gtk_text_buffer_insert_interactive_at_cursor(
      gobj(), text.data(), text.bytes(), default_editable);
}

bool TextBuffer::insert_interactive_at_cursor(const char* text_begin, const char* text_end,
                                              bool default_editable)
{
  return gtk_text_buffer_insert_interactive_at_cursor(
      gobj(), text_begin, text_end - text_begin, default_editable);
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& pos, const Glib::ustring& text,
                                                 const Glib::RefPtr<Tag>& tag)
{
  // gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.
  const int offset = pos.get_offset();

  iterator iterCopy (pos);
  gtk_text_buffer_insert_with_tags(
      gobj(), iterCopy.gobj(), text.data(), text.bytes(), tag->gobj(), (GtkTextTag*)0);

  return get_iter_at_offset(offset + text.size());
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& pos,
                                                 const char* text_begin, const char* text_end,
                                                 const Glib::RefPtr<Tag>& tag)
{
  // gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.
  const int offset = pos.get_offset();

  iterator iterCopy (pos);
  gtk_text_buffer_insert_with_tags(
      gobj(), iterCopy.gobj(), text_begin, text_end - text_begin, tag->gobj(), (GtkTextTag*)0);

  return get_iter_at_offset(offset + (text_end - text_begin));
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& pos, const Glib::ustring& text,
                                                 const Glib::ustring& tag_name)
{
  // gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.
  const int offset = pos.get_offset();

  iterator iterCopy (pos);
  gtk_text_buffer_insert_with_tags_by_name(
      gobj(), iterCopy.gobj(), text.data(), text.bytes(), tag_name.c_str(), (char*)0);

  return get_iter_at_offset(offset + text.size());
}

TextBuffer::iterator TextBuffer::insert_with_tag(const iterator& pos,
                                                 const char* text_begin, const char* text_end,
                                                 const Glib::ustring& tag_name)
{
  // gtk_text_buffer_insert_with_tags() invalidates the iterator, but this lets us recreate it later.
  const int offset = pos.get_offset();

  iterator iterCopy (pos);
  gtk_text_buffer_insert_with_tags_by_name(
      gobj(), iterCopy.gobj(), text_begin, text_end - text_begin, tag_name.c_str(), (char*)0);

  return get_iter_at_offset(offset + (text_end - text_begin));
}

TextBuffer::iterator TextBuffer::insert_with_tags(const iterator& pos, const Glib::ustring& text,
                                                  const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags)
{
  const char *const text_begin = text.data();
  return insert_with_tags(pos, text_begin, text_begin + text.bytes(), tags);
}

TextBuffer::iterator TextBuffer::insert_with_tags(const iterator& pos,
                                                  const char* text_begin, const char* text_end,
                                                  const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags)
{
  const int start_offset = pos.get_offset();
  iterator range_end (insert(pos, text_begin, text_end));

  GtkTextIter range_begin;
  gtk_text_buffer_get_iter_at_offset(gobj(), &range_begin, start_offset);

  //This was GtkTextTag* const * const, but the SUN Forte compiler said that it couldn't convert to that. murrayc
  const GtkTextTag* const* tags_begin = tags.data();
  const GtkTextTag* const* tags_end   = tags_begin + tags.size();

  //TODO: Investigate if this const_cast<> is really necessary.
  //I added it for the SUN Forte compiler. murrayc.
  for(GtkTextTag *const * ptag = const_cast<GtkTextTag* const *>(tags_begin); ptag != const_cast<GtkTextTag* const *>(tags_end); 
++ptag)
  {
    gtk_text_buffer_apply_tag(gobj(), *ptag, &range_begin, range_end.gobj());
  }

  return range_end;
}

TextBuffer::iterator TextBuffer::insert_with_tags_by_name(const iterator& pos, const Glib::ustring& text,
                                                          const Glib::ArrayHandle<Glib::ustring>& tag_names)
{
  const char *const text_begin = text.data();
  return insert_with_tags_by_name(pos, text_begin, text_begin + text.bytes(), tag_names);
}

TextBuffer::iterator TextBuffer::insert_with_tags_by_name(const iterator& pos,
                                                          const char* text_begin, const char* text_end,
                                                          const Glib::ArrayHandle<Glib::ustring>& tag_names)
{
  // gtk_buffer_insert_with_tags_by_name() is a convenience wrapper, so it's kind of OK to reimplement it:

  const int start_offset = pos.get_offset();
  iterator range_end (insert(pos, text_begin, text_end));

  GtkTextIter range_begin;
  gtk_text_buffer_get_iter_at_offset(gobj(), &range_begin, start_offset);

  GtkTextTagTable *const tag_table = gtk_text_buffer_get_tag_table(gobj());

  const char *const *const names_begin = tag_names.data();
  const char *const *const names_end   = names_begin + tag_names.size();

  for(const char *const * pname = names_begin; pname != names_end; ++pname)
  {
    if(GtkTextTag *const tag = gtk_text_tag_table_lookup(tag_table, *pname))
    {
      gtk_text_buffer_apply_tag(gobj(), tag, &range_begin, range_end.gobj());
    }
    else
    {
      g_warning("Gtk::TextBuffer::insert_with_tags_by_name(): no tag with name '%s'!", *pname);
    }
  }

  return range_end;
}

TextBuffer::iterator TextBuffer::insert(const iterator& pos,
                                        const iterator& range_begin, const iterator& range_end)
{
  iterator iterCopy (pos);
  gtk_text_buffer_insert_range(gobj(), iterCopy.gobj(), range_begin.gobj(), range_end.gobj());
  return iterCopy;
}

std::pair<TextBuffer::iterator,bool>
TextBuffer::insert_interactive(const iterator& pos, const iterator& range_begin,
                               const iterator& range_end, bool default_editable)
{
  // Since we have to copy the iterator anyway we can as well create the
  // std::pair now.  That saves another copy later (mind you, TextIter is
  // a heavy struct), and allows modern compilers to apply the return value
  // optimization.
  std::pair<iterator,bool> pair_iter_success (pos, false);

  pair_iter_success.second = gtk_text_buffer_insert_range_interactive(
      gobj(), pair_iter_success.first.gobj(), range_begin.gobj(), range_end.gobj(), default_editable);

  return pair_iter_success;
}

TextBuffer::iterator TextBuffer::erase(const iterator& range_begin, const iterator& range_end)
{
  // GTK+ sets the iterators to where the deletion occured. We do it the STL way and therefore need copies.
  iterator beginCopy (range_begin);
  iterator endCopy   (range_end);
  gtk_text_buffer_delete(gobj(), beginCopy.gobj(), endCopy.gobj());
  return beginCopy;
}

TextBuffer::iterator TextBuffer::backspace(const iterator& iter, bool interactive, bool default_editable)
{
  // GTK+ sets the iterators to where the deletion occured. We do it the STL way and therefore need copies.
  iterator copy(iter);
  gtk_text_buffer_backspace(gobj(), copy.gobj(), interactive, default_editable);
  return copy;
}


std::pair<TextBuffer::iterator,bool>
TextBuffer::erase_interactive(const iterator& range_begin, const iterator& range_end,
                              bool default_editable)
{
  // Since we have to copy the iterator anyway we can as well create the
  // std::pair now.  That saves another copy later (mind you, TextIter is
  // a heavy struct), and allows modern compilers to apply the return value
  // optimization.
  std::pair<iterator,bool> pair_iter_success (range_begin, false);

  // GTK+ sets the iterators to where the deletion occured.
  // We do it the STL way and therefore need copies.
  iterator endCopy (range_end);

  pair_iter_success.second = gtk_text_buffer_delete_interactive(
      gobj(), pair_iter_success.first.gobj(), endCopy.gobj(), default_editable);

  return pair_iter_success;
}

void TextBuffer::paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, const iterator& override_location,
                                 bool default_editable)
{
  gtk_text_buffer_paste_clipboard(gobj(), clipboard->gobj(),
      const_cast<GtkTextIter*>(override_location.gobj()), default_editable);
}

void TextBuffer::paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable)
{
  gtk_text_buffer_paste_clipboard(gobj(), clipboard->gobj(), 0, default_editable);
}

TextBuffer::iterator TextBuffer::get_iter_at_child_anchor(const Glib::RefPtr<ChildAnchor>& anchor)
{
  iterator iter;
  gtk_text_buffer_get_iter_at_child_anchor(gobj(), iter.gobj(), anchor->gobj());
  return iter;
}

int TextBuffer::size() const
{
  return get_char_count();
}

//This is not public API:
//(and it is copy/pasted from clipboard.ccg)
typedef std::list<Glib::ustring> listStrings;
static listStrings util_convert_atoms_to_strings(GdkAtom* targets, int n_targets)
{
  listStrings listTargets;

  //Add the targets to the C++ container:
  for(int i = 0; i < n_targets; i++)
  {
    //Convert the atom to a string:
    char* atom_name = gdk_atom_name(targets[i]);
    if(atom_name)
    {
      listTargets.push_back( Glib::ustring(atom_name) );
      g_free(atom_name);
    }
  }

  return listTargets;
}

Glib::ustring TextBuffer::get_text(bool include_hidden_chars)
{
  return get_text(begin(), end(), include_hidden_chars);
}

Glib::StringArrayHandle TextBuffer::get_serialize_formats() const
{
  int n_atoms = 0;
  GdkAtom* atoms = gtk_text_buffer_get_serialize_formats(const_cast<GtkTextBuffer*>(gobj()), &n_atoms);
  return util_convert_atoms_to_strings(atoms, n_atoms);
}

Glib::StringArrayHandle TextBuffer::get_deserialize_formats() const
{
  int n_atoms = 0;
  GdkAtom* atoms = gtk_text_buffer_get_deserialize_formats(const_cast<GtkTextBuffer*>(gobj()), &n_atoms);
  return util_convert_atoms_to_strings(atoms, n_atoms);
}

/*
Glib::ustring TextBuffer::register_serialize_format(const Glib::ustring& mime_type, const SlotSerialize& slot)
{
  SlotSerialize* slot_copy = new SlotSerialize(slot);
  GdkAtom atom = gtk_text_buffer_register_serialize_format(gobj(), mime_type.c_str(), 
                &SignalProxy_Serialize, slot_copy, &SignalProxy_Serialize_gtk_callback_destroy);

  //Convert the atom to a string:
  Glib::ustring atom_as_string;
  char* atom_name = gdk_atom_name(atom);
  if(atom_name)
  {
    atom_as_string = atom_name;
    g_free(atom_name);
  }

  return atom_as_string;
}

Glib::ustring TextBuffer::register_deserialize_format(const Glib::ustring& mime_type, const SlotDeserialize& slot)
{
  SlotDeserialize* slot_copy = new SlotDeserialize(slot);
  GdkAtom atom = gtk_text_buffer_register_deserialize_format(gobj(), mime_type.c_str(), 
                &SignalProxy_Deserialize, slot_copy, &SignalProxy_Deserialize_gtk_callback_destroy);

  //Convert the atom to a string:
  Glib::ustring atom_as_string;
  char* atom_name = gdk_atom_name(atom);
  if(atom_name)
  {
    atom_as_string = atom_name;
    g_free(atom_name);
  }

  return atom_as_string;
}
*/

#ifdef GTKMM_MAEMO_EXTENSIONS_ENABLED
void TextBuffer::set_rich_text_format_all()
{
  gtk_text_buffer_set_rich_text_format(gobj(), NULL);
}
#endif //GTKMM_MAEMO_EXTENSIONS_ENABLED

} // namespace Gtk


namespace
{


static void TextBuffer_signal_insert_callback(GtkTextBuffer* self, GtkTextIter* p0,const gchar* p1,gint p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TextBuffer::iterator&,const Glib::ustring&,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::ustring(p1, p1 + p2)
, p2
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_insert_info =
{
  "insert_text",
  (GCallback) &TextBuffer_signal_insert_callback,
  (GCallback) &TextBuffer_signal_insert_callback
};


static void TextBuffer_signal_insert_pixbuf_callback(GtkTextBuffer* self, GtkTextIter* p0,GdkPixbuf* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_insert_pixbuf_info =
{
  "insert_pixbuf",
  (GCallback) &TextBuffer_signal_insert_pixbuf_callback,
  (GCallback) &TextBuffer_signal_insert_pixbuf_callback
};


static void TextBuffer_signal_insert_child_anchor_callback(GtkTextBuffer* self, GtkTextIter* p0,GtkTextChildAnchor* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TextBuffer::iterator&,const Glib::RefPtr<ChildAnchor>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_insert_child_anchor_info =
{
  "insert_child_anchor",
  (GCallback) &TextBuffer_signal_insert_child_anchor_callback,
  (GCallback) &TextBuffer_signal_insert_child_anchor_callback
};


static void TextBuffer_signal_erase_callback(GtkTextBuffer* self, GtkTextIter* p0,GtkTextIter* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TextBuffer::iterator&,const TextBuffer::iterator& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_erase_info =
{
  "delete_range",
  (GCallback) &TextBuffer_signal_erase_callback,
  (GCallback) &TextBuffer_signal_erase_callback
};


static const Glib::SignalProxyInfo TextBuffer_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo TextBuffer_signal_modified_changed_info =
{
  "modified_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void TextBuffer_signal_mark_set_callback(GtkTextBuffer* self, const GtkTextIter* p0,GtkTextMark* p1,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_mark_set_info =
{
  "mark_set",
  (GCallback) &TextBuffer_signal_mark_set_callback,
  (GCallback) &TextBuffer_signal_mark_set_callback
};


static void TextBuffer_signal_mark_deleted_callback(GtkTextBuffer* self, GtkTextMark* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<TextBuffer::Mark>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_mark_deleted_info =
{
  "mark_deleted",
  (GCallback) &TextBuffer_signal_mark_deleted_callback,
  (GCallback) &TextBuffer_signal_mark_deleted_callback
};


static void TextBuffer_signal_apply_tag_callback(GtkTextBuffer* self, GtkTextTag* p0,const GtkTextIter* p1,const GtkTextIter* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_apply_tag_info =
{
  "apply_tag",
  (GCallback) &TextBuffer_signal_apply_tag_callback,
  (GCallback) &TextBuffer_signal_apply_tag_callback
};


static void TextBuffer_signal_remove_tag_callback(GtkTextBuffer* self, GtkTextTag* p0,const GtkTextIter* p1,const GtkTextIter* p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo TextBuffer_signal_remove_tag_info =
{
  "remove_tag",
  (GCallback) &TextBuffer_signal_remove_tag_callback,
  (GCallback) &TextBuffer_signal_remove_tag_callback
};


static const Glib::SignalProxyInfo TextBuffer_signal_begin_user_action_info =
{
  "begin_user_action",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo TextBuffer_signal_end_user_action_info =
{
  "end_user_action",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::TextBuffer>( dynamic_cast<Gtk::TextBuffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& TextBuffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &TextBuffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_text_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void TextBuffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->insert_text = &insert_text_callback;
  klass->insert_pixbuf = &insert_pixbuf_callback;
  klass->insert_child_anchor = &insert_child_anchor_callback;
  klass->delete_range = &delete_range_callback;
  klass->changed = &changed_callback;
  klass->modified_changed = &modified_changed_callback;
  klass->mark_set = &mark_set_callback;
  klass->mark_deleted = &mark_deleted_callback;
  klass->apply_tag = &apply_tag_callback;
  klass->remove_tag = &remove_tag_callback;
  klass->begin_user_action = &begin_user_action_callback;
  klass->end_user_action = &end_user_action_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void TextBuffer_Class::insert_text_callback(GtkTextBuffer* self, GtkTextIter* p0, const gchar* p1, gint p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_insert(Glib::wrap(p0)
, Glib::ustring(p1, p1 + p2)
, p2
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->insert_text)
    (*base->insert_text)(self, p0, p1, p2);
}
void TextBuffer_Class::insert_pixbuf_callback(GtkTextBuffer* self, GtkTextIter* p0, GdkPixbuf* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_insert_pixbuf(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->insert_pixbuf)
    (*base->insert_pixbuf)(self, p0, p1);
}
void TextBuffer_Class::insert_child_anchor_callback(GtkTextBuffer* self, GtkTextIter* p0, GtkTextChildAnchor* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_insert_child_anchor(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->insert_child_anchor)
    (*base->insert_child_anchor)(self, p0, p1);
}
void TextBuffer_Class::delete_range_callback(GtkTextBuffer* self, GtkTextIter* p0, GtkTextIter* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_erase(Glib::wrap(p0)
, Glib::wrap(p1)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->delete_range)
    (*base->delete_range)(self, p0, p1);
}
void TextBuffer_Class::changed_callback(GtkTextBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->changed)
    (*base->changed)(self);
}
void TextBuffer_Class::modified_changed_callback(GtkTextBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_modified_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->modified_changed)
    (*base->modified_changed)(self);
}
void TextBuffer_Class::mark_set_callback(GtkTextBuffer* self, const GtkTextIter* p0, GtkTextMark* p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_mark_set(Glib::wrap(p0)
, Glib::wrap(p1, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->mark_set)
    (*base->mark_set)(self, p0, p1);
}
void TextBuffer_Class::mark_deleted_callback(GtkTextBuffer* self, GtkTextMark* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_mark_deleted(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->mark_deleted)
    (*base->mark_deleted)(self, p0);
}
void TextBuffer_Class::apply_tag_callback(GtkTextBuffer* self, GtkTextTag* p0, const GtkTextIter* p1, const GtkTextIter* p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_apply_tag(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->apply_tag)
    (*base->apply_tag)(self, p0, p1, p2);
}
void TextBuffer_Class::remove_tag_callback(GtkTextBuffer* self, GtkTextTag* p0, const GtkTextIter* p1, const GtkTextIter* p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_remove_tag(Glib::wrap(p0, true)
, Glib::wrap(p1)
, Glib::wrap(p2)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->remove_tag)
    (*base->remove_tag)(self, p0, p1, p2);
}
void TextBuffer_Class::begin_user_action_callback(GtkTextBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_begin_user_action();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->begin_user_action)
    (*base->begin_user_action)(self);
}
void TextBuffer_Class::end_user_action_callback(GtkTextBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_end_user_action();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->end_user_action)
    (*base->end_user_action)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* TextBuffer_Class::wrap_new(GObject* object)
{
  return new TextBuffer((GtkTextBuffer*)object);
}


/* The implementation: */

GtkTextBuffer* TextBuffer::gobj_copy()
{
  reference();
  return gobj();
}

TextBuffer::TextBuffer(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

TextBuffer::TextBuffer(GtkTextBuffer* castitem)
:
  Glib::Object((GObject*)(castitem))
{}

TextBuffer::~TextBuffer()
{}


TextBuffer::CppClassType TextBuffer::textbuffer_class_; // initialize static member

GType TextBuffer::get_type()
{
  return textbuffer_class_.init().get_type();
}

GType TextBuffer::get_base_type()
{
  return gtk_text_buffer_get_type();
}


TextBuffer::TextBuffer()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(textbuffer_class_.init()))
{
  

}

Glib::RefPtr<TextBuffer> TextBuffer::create()
{
  return Glib::RefPtr<TextBuffer>( new TextBuffer() );
}
Glib::RefPtr<TextBuffer> TextBuffer::create(const Glib::RefPtr<TagTable>& tag_table)
{
  return Glib::RefPtr<TextBuffer>( new TextBuffer(tag_table) );
}
int TextBuffer::get_line_count() const
{
  return gtk_text_buffer_get_line_count(const_cast<GtkTextBuffer*>(gobj()));
}

int TextBuffer::get_char_count() const
{
  return gtk_text_buffer_get_char_count(const_cast<GtkTextBuffer*>(gobj()));
}

Glib::RefPtr<TextBuffer::TagTable> TextBuffer::get_tag_table()
{

  Glib::RefPtr<TextBuffer::TagTable> retvalue = Glib::wrap(gtk_text_buffer_get_tag_table(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const TextBuffer::TagTable> TextBuffer::get_tag_table() const
{
  return const_cast<TextBuffer*>(this)->get_tag_table();
}

Glib::ustring TextBuffer::get_text(const iterator& start, const iterator& end, bool include_hidden_chars)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_text(gobj(), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

Glib::ustring TextBuffer::get_text(const iterator& start, const iterator& end, bool include_hidden_chars) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_text(const_cast<GtkTextBuffer*>(gobj()), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

Glib::ustring TextBuffer::get_slice(const iterator& start, const iterator& end, bool include_hidden_chars)
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_slice(gobj(), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

Glib::ustring TextBuffer::get_slice(const iterator& start, const iterator& end, bool include_hidden_chars) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_buffer_get_slice(const_cast<GtkTextBuffer*>(gobj()), (start).gobj(), (end).gobj(), static_cast<int>(include_hidden_chars)));
}

void TextBuffer::add_mark(const Glib::RefPtr<TextBuffer::Mark>& mark, const iterator& where)
{
gtk_text_buffer_add_mark(gobj(), Glib::unwrap(mark), (where).gobj()); 
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::create_mark(const Glib::ustring& mark_name, const iterator& where, bool left_gravity)
{

  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_create_mark(gobj(), mark_name.c_str(), (where).gobj(), static_cast<int>(left_gravity)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

void TextBuffer::move_mark(const Glib::RefPtr<Mark>& mark, const iterator& where)
{
gtk_text_buffer_move_mark(gobj(), Glib::unwrap(mark), (where).gobj()); 
}

void TextBuffer::delete_mark(const Glib::RefPtr<Mark>& mark)
{
gtk_text_buffer_delete_mark(gobj(), Glib::unwrap(mark)); 
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_mark(const Glib::ustring& name)
{

  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_mark(gobj(), name.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const TextBuffer::Mark> TextBuffer::get_mark(const Glib::ustring& name) const
{
  return const_cast<TextBuffer*>(this)->get_mark(name);
}

void TextBuffer::move_mark_by_name(const Glib::ustring& name, const iterator& where)
{
gtk_text_buffer_move_mark_by_name(gobj(), name.c_str(), (where).gobj()); 
}

void TextBuffer::delete_mark_by_name(const Glib::ustring& name)
{
gtk_text_buffer_delete_mark_by_name(gobj(), name.c_str()); 
}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_insert()
{

  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_insert(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<TextBuffer::Mark> TextBuffer::get_selection_bound()
{

  Glib::RefPtr<TextBuffer::Mark> retvalue = Glib::wrap(gtk_text_buffer_get_selection_bound(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

void TextBuffer::place_cursor(const iterator& where)
{
gtk_text_buffer_place_cursor(gobj(), (where).gobj()); 
}

void TextBuffer::apply_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end)
{
gtk_text_buffer_apply_tag(gobj(), Glib::unwrap(tag), (start).gobj(), (end).gobj()); 
}

void TextBuffer::remove_tag(const Glib::RefPtr<Tag>& tag, const iterator& start, const iterator& end)
{
gtk_text_buffer_remove_tag(gobj(), Glib::unwrap(tag), (start).gobj(), (end).gobj()); 
}

void TextBuffer::apply_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end)
{
gtk_text_buffer_apply_tag_by_name(gobj(), name.c_str(), (start).gobj(), (end).gobj()); 
}

void TextBuffer::remove_tag_by_name(const Glib::ustring& name, const iterator& start, const iterator& end)
{
gtk_text_buffer_remove_tag_by_name(gobj(), name.c_str(), (start).gobj(), (end).gobj()); 
}

void TextBuffer::remove_all_tags(const iterator& start, const iterator& end)
{
gtk_text_buffer_remove_all_tags(gobj(), (start).gobj(), (end).gobj()); 
}

bool TextBuffer::get_modified() const
{
  return gtk_text_buffer_get_modified(const_cast<GtkTextBuffer*>(gobj()));
}

void TextBuffer::set_modified(bool setting)
{
gtk_text_buffer_set_modified(gobj(), static_cast<int>(setting)); 
}

bool TextBuffer::get_has_selection() const
{
  return gtk_text_buffer_get_has_selection(const_cast<GtkTextBuffer*>(gobj()));
}

void TextBuffer::add_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard)
{
gtk_text_buffer_add_selection_clipboard(gobj(), Glib::unwrap(clipboard)); 
}

void TextBuffer::remove_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard)
{
gtk_text_buffer_remove_selection_clipboard(gobj(), Glib::unwrap(clipboard)); 
}

void TextBuffer::cut_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable)
{
gtk_text_buffer_cut_clipboard(gobj(), Glib::unwrap(clipboard), static_cast<int>(default_editable)); 
}

void TextBuffer::copy_clipboard(const Glib::RefPtr<Clipboard>& clipboard)
{
gtk_text_buffer_copy_clipboard(gobj(), Glib::unwrap(clipboard)); 
}

bool TextBuffer::get_selection_bounds(iterator& start, iterator& end) const
{
  return gtk_text_buffer_get_selection_bounds(const_cast<GtkTextBuffer*>(gobj()), (start).gobj(), (end).gobj());
}

bool TextBuffer::erase_selection(bool interactive, bool default_editable)
{
  return gtk_text_buffer_delete_selection(gobj(), static_cast<int>(interactive), static_cast<int>(default_editable));
}

void TextBuffer::select_range(const iterator& ins, const iterator& bound)
{
gtk_text_buffer_select_range(gobj(), (ins).gobj(), (bound).gobj()); 
}

void TextBuffer::begin_user_action()
{
gtk_text_buffer_begin_user_action(gobj()); 
}

void TextBuffer::end_user_action()
{
gtk_text_buffer_end_user_action(gobj()); 
}

Glib::ustring TextBuffer::register_serialize_tagset(const Glib::ustring& tagset_name)
{
  return Gdk::AtomString::to_cpp_type(gtk_text_buffer_register_serialize_tagset(gobj(), tagset_name.c_str()));
}

Glib::ustring TextBuffer::register_deserialize_tagset(const Glib::ustring& tagset_name)
{
  return Gdk::AtomString::to_cpp_type(gtk_text_buffer_register_deserialize_tagset(gobj(), tagset_name.c_str()));
}

void TextBuffer::unregister_serialize_format(const Glib::ustring& format)
{
gtk_text_buffer_unregister_serialize_format(gobj(), Gdk::AtomString::to_c_type(format)); 
}

void TextBuffer::unregister_deserialize_format(const Glib::ustring& format)
{
gtk_text_buffer_unregister_deserialize_format(gobj(), Gdk::AtomString::to_c_type(format)); 
}

void TextBuffer::set_can_create_tags(const Glib::ustring& format, bool can_create_tags)
{
gtk_text_buffer_deserialize_set_can_create_tags(gobj(), Gdk::AtomString::to_c_type(format), static_cast<int>(can_create_tags)); 
}

bool TextBuffer::get_can_create_tags(const Glib::ustring& format) const
{
  return gtk_text_buffer_deserialize_get_can_create_tags(const_cast<GtkTextBuffer*>(gobj()), Gdk::AtomString::to_c_type(format));
}


Glib::SignalProxy3< void,const TextBuffer::iterator&,const Glib::ustring&,int > TextBuffer::signal_insert()
{
  return Glib::SignalProxy3< void,const TextBuffer::iterator&,const Glib::ustring&,int >(this, &TextBuffer_signal_insert_info);
}


Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>& > TextBuffer::signal_insert_pixbuf()
{
  return Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>& >(this, &TextBuffer_signal_insert_pixbuf_info);
}


Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<ChildAnchor>& > TextBuffer::signal_insert_child_anchor()
{
  return Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<ChildAnchor>& >(this, &TextBuffer_signal_insert_child_anchor_info);
}


Glib::SignalProxy2< void,const TextBuffer::iterator&,const TextBuffer::iterator& > TextBuffer::signal_erase()
{
  return Glib::SignalProxy2< void,const TextBuffer::iterator&,const TextBuffer::iterator& >(this, &TextBuffer_signal_erase_info);
}


Glib::SignalProxy0< void > TextBuffer::signal_changed()
{
  return Glib::SignalProxy0< void >(this, &TextBuffer_signal_changed_info);
}


Glib::SignalProxy0< void > TextBuffer::signal_modified_changed()
{
  return Glib::SignalProxy0< void >(this, &TextBuffer_signal_modified_changed_info);
}


Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>& > TextBuffer::signal_mark_set()
{
  return Glib::SignalProxy2< void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>& >(this, &TextBuffer_signal_mark_set_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<TextBuffer::Mark>& > TextBuffer::signal_mark_deleted()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<TextBuffer::Mark>& >(this, &TextBuffer_signal_mark_deleted_info);
}


Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > TextBuffer::signal_apply_tag()
{
  return Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& >(this, &TextBuffer_signal_apply_tag_info);
}


Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& > TextBuffer::signal_remove_tag()
{
  return Glib::SignalProxy3< void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator& >(this, &TextBuffer_signal_remove_tag_info);
}


Glib::SignalProxy0< void > TextBuffer::signal_begin_user_action()
{
  return Glib::SignalProxy0< void >(this, &TextBuffer_signal_begin_user_action_info);
}


Glib::SignalProxy0< void > TextBuffer::signal_end_user_action()
{
  return Glib::SignalProxy0< void >(this, &TextBuffer_signal_end_user_action_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> TextBuffer::property_text() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> TextBuffer::property_text() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "text");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> TextBuffer::property_has_selection() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "has-selection");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> TextBuffer::property_cursor_position() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "cursor-position");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gtk::TextBuffer::on_insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_text)
    (*base->insert_text)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),text.c_str(),bytes);
}
void Gtk::TextBuffer::on_insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_pixbuf)
    (*base->insert_pixbuf)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),Glib::unwrap(pixbuf));
}
void Gtk::TextBuffer::on_insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<ChildAnchor>& anchor)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert_child_anchor)
    (*base->insert_child_anchor)(gobj(),const_cast<GtkTextIter*>((pos).gobj()),Glib::unwrap(anchor));
}
void Gtk::TextBuffer::on_erase(const TextBuffer::iterator& start, const TextBuffer::iterator& end)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delete_range)
    (*base->delete_range)(gobj(),const_cast<GtkTextIter*>((start).gobj()),const_cast<GtkTextIter*>((end).gobj()));
}
void Gtk::TextBuffer::on_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->changed)
    (*base->changed)(gobj());
}
void Gtk::TextBuffer::on_modified_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->modified_changed)
    (*base->modified_changed)(gobj());
}
void Gtk::TextBuffer::on_mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mark_set)
    (*base->mark_set)(gobj(),(location).gobj(),Glib::unwrap(mark));
}
void Gtk::TextBuffer::on_mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mark_deleted)
    (*base->mark_deleted)(gobj(),Glib::unwrap(mark));
}
void Gtk::TextBuffer::on_apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->apply_tag)
    (*base->apply_tag)(gobj(),Glib::unwrap(tag),(range_begin).gobj(),(range_end).gobj());
}
void Gtk::TextBuffer::on_remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->remove_tag)
    (*base->remove_tag)(gobj(),Glib::unwrap(tag),(range_begin).gobj(),(range_end).gobj());
}
void Gtk::TextBuffer::on_begin_user_action()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->begin_user_action)
    (*base->begin_user_action)(gobj());
}
void Gtk::TextBuffer::on_end_user_action()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->end_user_action)
    (*base->end_user_action)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gtk


