/*
*
*  THIS FUNCTION WRITES A MAPINFO IMPORT HEADER RECORD.
*
*  WRITTEN BY:
*  R.L. GLENN, USDA, NRCS, 9/19/95
*/

#include <stdio.h>
#include <stdlib.h>
#define UTM 1
#define STP 2
#define LATLONG 3

write_mpinfo_header (mpinfo,feature,proj,nad,zone)
FILE *mpinfo;   /* POINTER TO MAPINFO IMPORT FILE */
int feature;               /* TYPE: 1- SITE, 2-LINE, 3-AREA */
int proj;                  /* PROJECTION TYPE */
int nad;                   /* NAD TYPE */
int zone;                  /* ZONE */

{
    int ret;
    char buff[256];

    ret = fprintf (mpinfo,"Version 2\015\n");
    ret = fprintf (mpinfo,"Delimiter \",\"\015\n");
    ret = fprintf (mpinfo,"Index 1\015\n");
    ret = get_proj_info(buff,proj,nad,zone);
    if (!ret) {
       fprintf(stderr, "projection<%d>, zone<%d>, and nad<%d> \n",proj,zone,nad);
       fprintf(stderr, "This combination of projection, zone, and nad is not\n");
       fprintf(stderr, "available\n");
       return(-1);
    }
    ret = fprintf (mpinfo,"CoordSys Earth Projection %s\015\n",buff);
    if (feature == 3) {
        ret = fprintf (mpinfo,"Columns 2\015\n");
        ret = fprintf (mpinfo,"  Category integer\015\n");
        ret = fprintf (mpinfo,"  Label Char(20)\015\n");
        }
    else {
        ret = fprintf (mpinfo,"Columns 1\015\n");
        ret = fprintf (mpinfo,"  Label Char(20)\015\n");
        }
    ret = fprintf (mpinfo,"Data\015\n\015\n");

    return (ret);
}

#define NUMPROJ 302

static char codes[][180] = {
"1|27|1|8, 63, |m|, -177, 0, 0.9996, 500000, 0",
"1|27|2|8, 63, |m|, -171, 0, 0.9996, 500000, 0",
"1|27|3|8, 63, |m|, -165, 0, 0.9996, 500000, 0",
"1|27|4|8, 63, |m|, -159, 0, 0.9996, 500000, 0",
"1|27|5|8, 63, |m|, -153, 0, 0.9996, 500000, 0",
"1|27|6|8, 63, |m|, -147, 0, 0.9996, 500000, 0",
"1|27|7|8, 63, |m|, -141, 0, 0.9996, 500000, 0",
"1|27|8|8, 63, |m|, -135, 0, 0.9996, 500000, 0",
"1|27|9|8, 63, |m|, -129, 0, 0.9996, 500000, 0",
"1|27|10|8, 62, |m|, -123, 0, 0.9996, 500000, 0",
"1|27|11|8, 62, |m|, -117, 0, 0.9996, 500000, 0",
"1|27|12|8, 62, |m|, -111, 0, 0.9996, 500000, 0",
"1|27|13|8, 62, |m|, -105, 0, 0.9996, 500000, 0",
"1|27|14|8, 62, |m|, -99, 0, 0.9996, 500000, 0",
"1|27|15|8, 62, |m|, -93, 0, 0.9996, 500000, 0",
"1|27|16|8, 62, |m|, -87, 0, 0.9996, 500000, 0",
"1|27|17|8, 62, |m|, -81, 0, 0.9996, 500000, 0",
"1|27|18|8, 62, |m|, -75, 0, 0.9996, 500000, 0",
"1|27|19|8, 62, |m|, -69, 0, 0.9996, 500000, 0",
"1|83|1|8, 74, |m|, -177, 0, 0.9996, 500000, 0",
"1|83|2|8, 74, |m|, -171, 0, 0.9996, 500000, 0",
"1|83|3|8, 74, |m|, -165, 0, 0.9996, 500000, 0",
"1|83|4|8, 74, |m|, -159, 0, 0.9996, 500000, 0",
"1|83|5|8, 74, |m|, -153, 0, 0.9996, 500000, 0",
"1|83|6|8, 74, |m|, -147, 0, 0.9996, 500000, 0",
"1|83|7|8, 74, |m|, -141, 0, 0.9996, 500000, 0",
"1|83|8|8, 74, |m|, -135, 0, 0.9996, 500000, 0",
"1|83|9|8, 74, |m|, -129, 0, 0.9996, 500000, 0",
"1|83|10|8, 74, |m|, -123, 0, 0.9996, 500000, 0",
"1|83|11|8, 74, |m|, -117, 0, 0.9996, 500000, 0",
"1|83|12|8, 74, |m|, -111, 0, 0.9996, 500000, 0",
"1|83|13|8, 74, |m|, -105, 0, 0.9996, 500000, 0",
"1|83|14|8, 74, |m|, -99, 0, 0.9996, 500000, 0",
"1|83|15|8, 74, |m|, -93, 0, 0.9996, 500000, 0",
"1|83|16|8, 74, |m|, -87, 0, 0.9996, 500000, 0",
"1|83|17|8, 74, |m|, -81, 0, 0.9996, 500000, 0",
"1|83|18|8, 74, |m|, -75, 0, 0.9996, 500000, 0",
"1|83|19|8, 74, |m|, -69, 0, 0.9996, 500000, 0",
"1|83|20|8, 74, |m|, -63, 0, 0.9996, 500000, 0",
"1|83|21|8, 74, |m|, -57, 0, 0.9996, 500000, 0",
"1|83|22|8, 74, |m|, -51, 0, 0.9996, 500000, 0",
"1|83|23|8, 74, |m|, -45, 0, 0.9996, 500000, 0",
"1|83|24|8, 74, |m|, -39, 0, 0.9996, 500000, 0",
"1|83|25|8, 74, |m|, -33, 0, 0.9996, 500000, 0",
"1|83|26|8, 74, |m|, -27, 0, 0.9996, 500000, 0",
"1|83|27|8, 74, |m|, -21, 0, 0.9996, 500000, 0",
"1|83|28|8, 74, |m|, -15, 0, 0.9996, 500000, 0",
"1|83|29|8, 74, |m|, -9, 0, 0.9996, 500000, 0",
"2|27|101|8, 62, |survey ft|, -85.8333333333, 30.5, 0.99996, 500000, 0",
"2|27|102|8, 62, |survey ft|, -87.5, 30, 0.9999333333, 500000, 0",
"2|27|5001|7, 63, |survey ft|, -133.6666666667, 57, -36.8698976458, 0.9999, 16404166.6667, -16404166.6667",
"2|27|5002|8, 63, |survey ft|, -142, 54, 0.9999, 500000, 0",
"2|27|5003|8, 63, |survey ft|, -146, 54, 0.9999, 500000, 0",
"2|27|5004|8, 63, |survey ft|, -150, 54, 0.9999, 500000, 0",
"2|27|5005|8, 63, |survey ft|, -154, 54, 0.9999, 500000, 0",
"2|27|5006|8, 63, |survey ft|, -158, 54, 0.9999, 500000, 0",
"2|27|5007|8, 63, |survey ft|, -162, 54, 0.9999, 700000, 0",
"2|27|5008|8, 63, |survey ft|, -166, 54, 0.9999, 500000, 0",
"2|27|5009|8, 63, |survey ft|, -170, 54, 0.9999, 600000, 0",
"2|27|5010|3, 63, |survey ft|, -176, 51, 51.8333333333, 53.8333333333, 3000000, 0",
"2|27|201|8, 62, |survey ft|, -110.1666666667, 31, 0.9999, 500000, 0",
"2|27|202|8, 62, |survey ft|, -111.9166666667, 31, 0.9999, 500000, 0",
"2|27|203|8, 62, |survey ft|, -113.75, 31, 0.9999333333, 500000, 0",
"2|27|301|3, 62, |survey ft|, -92, 34.3333333333, 34.9333333333, 36.2333333333, 2000000, 0",
"2|27|302|3, 62, |survey ft|, -92, 32.6666666667, 33.3, 34.7666666667, 2000000, 0",
"2|27|401|3, 62, |survey ft|, -122, 39.3333333333, 40, 41.6666666667, 2000000, 0",
"2|27|402|3, 62, |survey ft|, -122, 37.6666666667, 38.3333333333, 39.8333333333, 2000000, 0",
"2|27|403|3, 62, |survey ft|, -120.5, 36.5, 37.0666666667, 38.4333333333, 2000000, 0",
"2|27|404|3, 62, |survey ft|, -119, 35.3333333333, 36, 37.25, 2000000, 0",
"2|27|405|3, 62, |survey ft|, -118, 33.5, 34.0333333333, 35.4666666667, 2000000, 0",
"2|27|406|3, 62, |survey ft|, -116.25, 32.1666666667, 32.7833333333, 33.8833333333, 2000000, 0",
"2|27|407|3, 62, |survey ft|, -118.3333333333, 34.1333333333, 33.8666666667, 34.4166666667, 4186692.58, 4160926.74",
"2|27|501|3, 62, |survey ft|, -105.5, 39.3333333333, 39.7166666667, 40.7833333333, 2000000, 0",
"2|27|502|3, 62, |survey ft|, -105.5, 37.8333333333, 38.45, 39.75, 2000000, 0",
"2|27|503|3, 62, |survey ft|, -105.5, 36.6666666667, 37.2333333333, 38.4333333333, 2000000, 0",
"2|27|600|3, 62, |survey ft|, -72.75, 40.8333333333, 41.2, 41.8666666667, 600000, 0",
"2|27|700|8, 62, |survey ft|, -75.4166666667, 38, 0.999995, 500000, 0",
"2|27|901|3, 62, |survey ft|, -84.5, 29, 29.5833333333, 30.75, 2000000, 0",
"2|27|902|8, 62, |survey ft|, -81, 24.3333333333, 0.9999411765, 500000, 0",
"2|27|903|8, 62, |survey ft|, -82, 24.3333333333, 0.9999411765, 500000, 0",
"2|27|1001|8, 62, |survey ft|, -82.1666666667, 30, 0.9999, 500000, 0",
"2|27|1002|8, 62, |survey ft|, -84.1666666667, 30, 0.9999, 500000, 0",
"2|27|5101|8, 62, |survey ft|, -155.5, 18.8333333333, 0.9999666667, 500000, 0",
"2|27|5102|8, 62, |survey ft|, -156.6666666667, 20.3333333333, 0.9999666667, 500000, 0",
"2|27|5103|8, 62, |survey ft|, -158, 21.1666666667, 0.99999, 500000, 0",
"2|27|5104|8, 62, |survey ft|, -159.5, 21.8333333333, 0.99999, 500000, 0",
"2|27|5105|8, 62, |survey ft|, -160.1666666667, 21.6666666667, 1, 500000, 0",
"2|27|1101|8, 62, |survey ft|, -112.1666666667, 41.6666666667, 0.9999473684, 500000, 0",
"2|27|1102|8, 62, |survey ft|, -114, 41.6666666667, 0.9999473684, 500000, 0",
"2|27|1103|8, 62, |survey ft|, -115.75, 41.6666666667, 0.9999333333, 500000, 0",
"2|27|1201|8, 62, |survey ft|, -88.3333333333, 36.6666666667, 0.999975, 500000, 0",
"2|27|1202|8, 62, |survey ft|, -90.1666666667, 36.6666666667, 0.9999411765, 500000, 0",
"2|27|1301|8, 62, |survey ft|, -85.6666666667, 37.5, 0.9999666667, 500000, 0",
"2|27|1302|8, 62, |survey ft|, -87.0833333333, 37.5, 0.9999666667, 500000, 0",
"2|27|1401|3, 62, |survey ft|, -93.5, 41.5, 42.0666666667, 43.2666666667, 2000000, 0",
"2|27|1402|3, 62, |survey ft|, -93.5, 40, 40.6166666667, 41.7833333333, 2000000, 0",
"2|27|1501|3, 62, |survey ft|, -98, 38.3333333333, 38.7166666667, 39.7833333333, 2000000, 0",
"2|27|1502|3, 62, |survey ft|, -98.5, 36.6666666667, 38.5666666667, 37.2666666667, 2000000, 0",
"2|27|1601|3, 62, |survey ft|, -84.25, 37.5, 37.9666666667, 38.9666666667, 2000000, 0",
"2|27|1602|3, 62, |survey ft|, -85.75, 36.3333333333, 36.7333333333, 37.9333333333, 2000000, 0",
"2|27|1701|3, 62, |survey ft|, -92.5, 30.6666666667, 31.1666666667, 32.6666666667, 2000000, 0",
"2|27|1702|3, 62, |survey ft|, -91.3333333333, 28.6666666667, 29.3, 30.67, 2000000, 0",
"2|27|1703|3, 62, |survey ft|, -91.3333333333, 25.6666666667, 26.1666666667, 27.8333333333, 2000000, 0",
"2|27|1801|8, 62, |survey ft|, -68.5, 43.8333333333, 0.9999, 500000, 0",
"2|27|1802|8, 62, |survey ft|, -70.1666666667, 42.8333333333, 0.9999666667, 500000, 0",
"2|27|1900|3, 62, |survey ft|, -77, 37.8333333333, 38.3, 39.45, 800000, 0",
"2|27|2001|3, 62, |survey ft|, -71.5, 41, 41.7166666667, 42.6833333333, 600000, 0",
"2|27|2002|3, 62, |survey ft|, -70.5, 41, 41.2833333333, 41.4833333333, 800000, 0",
"2|27|2111|3, 73, |survey ft|, -87, 44.7833333333, 45.4833333333, 47.0833333333, 2000000, 0",
"2|27|2112|3, 73, |survey ft|, -84.3333333333, 43.3166666667, 44.1833333333, 45.7, 2000000, 0",
"2|27|2113|3, 73, |survey ft|, -84.3333333333, 41.5, 42.1, 43.6666666667, 2000000, 0",
"2|27|2201|3, 62, |survey ft|, -93.1, 46.5, 47.0333333333, 48.6333333333, 2000000, 0",
"2|27|2202|3, 62, |survey ft|, -94.25, 45, 45.6166666667, 47.05, 2000000, 0",
"2|27|2203|3, 62, |survey ft|, -94, 43, 43.7833333333, 45.2166666667, 2000000, 0",
"2|27|2301|8, 62, |survey ft|, -88.8333333333, 29.6666666667, 0.999996, 500000, 0",
"2|27|2302|8, 62, |survey ft|, -90.3333333333, 30.5, 0.9999411765, 500000, 0",
"2|27|2401|8, 62, |survey ft|, -90.5, 35.8333333333, 0.9999333333, 500000, 0",
"2|27|2402|8, 62, |survey ft|, -92.5, 35.8333333333, 0.9999333333, 500000, 0",
"2|27|2403|8, 62, |survey ft|, -94.5, 36.1666666667, 0.9999411765, 500000, 0",
"2|27|2501|3, 62, |survey ft|, -109.5, 47, 47.85, 48.7166666667, 2000000, 0",
"2|27|2502|3, 62, |survey ft|, -109.5, 45.8333333333, 46.45, 47.8833333333, 2000000, 0",
"2|27|2503|3, 62, |survey ft|, -109.5, 44, 44.8666666667, 46.4, 2000000, 0",
"2|27|2601|3, 62, |survey ft|, -100, 41.3333333333, 41.85, 42.8166666667, 2000000, 0",
"2|27|2602|3, 62, |survey ft|, -99.5, 39.6666666667, 40.2833333333, 41.7166666667, 2000000, 0",
"2|27|2701|8, 62, |survey ft|, -115.5833333333, 34.75, 0.9999, 500000, 0",
"2|27|2702|8, 62, |survey ft|, -116.6666666667, 34.75, 0.9999, 500000, 0",
"2|27|2703|8, 62, |survey ft|, -118.5833333333, 34.75, 0.9999, 500000, 0",
"2|27|2800|8, 62, |survey ft|, -71.6666666667, 42.5, 0.9999666667, 500000, 0",
"2|27|2900|8, 62, |survey ft|, -74.6666666667, 38.8333333333, 0.999975, 2000000, 0",
"2|27|3001|8, 62, |survey ft|, -104.3333333333, 31, 0.9999090909, 500000, 0",
"2|27|3002|8, 62, |survey ft|, -106.25, 31, 0.9999, 500000, 0",
"2|27|3003|8, 62, |survey ft|, -107.8333333333, 31, 0.9999166667, 500000, 0",
"2|27|3101|8, 62, |survey ft|, -74.3333333333, 40, 0.9999666667, 500000, 0",
"2|27|3102|8, 62, |survey ft|, -76.5833333333, 40, 0.9999375, 500000, 0",
"2|27|3103|8, 62, |survey ft|, -78.5833333333, 40, 0.9999375, 500000, 0",
"2|27|3104|3, 62, |survey ft|, -74, 40.5, 40.6666666667, 41.0333333333, 2000000, 100000",
"2|27|3200|3, 62, |survey ft|, -79, 33.75, 34.3333333333, 36.1666666667, 2000000, 0",
"2|27|3301|3, 62, |survey ft|, -100.5, 47, 47.4333333333, 48.7333333333, 2000000, 0",
"2|27|3302|3, 62, |survey ft|, -100.5, 45.6666666667, 46.1833333333, 47.4833333333, 2000000, 0",
"2|27|3401|3, 62, |survey ft|, -82.5, 39.6666666667, 40.4333333333, 41.7, 2000000, 0",
"2|27|3402|3, 62, |survey ft|, -82.5, 38, 38.7333333333, 40.0333333333, 2000000, 0",
"2|27|3501|3, 62, |survey ft|, -98, 35, 35.5666666667, 36.7666666667, 2000000, 0",
"2|27|3502|3, 62, |survey ft|, -98, 33.3333333333, 33.9333333333, 35.2333333333, 2000000, 0",
"2|27|3601|3, 62, |survey ft|, -120.5, 43.6666666667, 44.3333333333, 46, 2000000, 0",
"2|27|3602|3, 62, |survey ft|, -120.5, 41.6666666667, 42.3333333333, 44, 2000000, 0",
"2|27|3701|3, 62, |survey ft|, -77.75, 40.1666666667, 40.8833333333, 41.95, 2000000, 0",
"2|27|3702|3, 62, |survey ft|, -77.75, 39.3333333333, 39.9333333333, 40.9666666667, 2000000, 0",
"2|27|5301|3, 62, |survey ft|, -66.4333333333, 18.4333333333, 18.0333333333, 18.4333333333, 500000, 0",
"2|27|5202|3, 62, |survey ft|, -66.4333333333, 18.4333333333, 18.0333333333, 18.4333333333, 500000, 100000",
"2|27|3800|8, 62, |survey ft|, -71.5, 41.0833333333, 0.99999375, 500000, 0",
"2|27|3901|3, 62, |survey ft|, -81, 33, 33.7666666667, 34.9666666667, 2000000, 0",
"2|27|3902|3, 62, |survey ft|, -81, 31.8333333333, 32.3333333333, 33.6666666667, 2000000, 0",
"2|27|4001|3, 62, |survey ft|, -100, 43.8333333333, 44.4166666667, 45.6833333333, 2000000, 0",
"2|27|4002|3, 62, |survey ft|, -100.3333333333, 42.3333333333, 42.8333333333, 44.4, 2000000, 0",
"2|27|4100|3, 62, |survey ft|, -86, 34.6666666667, 35.25, 36.4166666667, 2000000, 100000",
"2|27|4201|3, 62, |survey ft|, -101.5, 34, 34.65, 36.1833333333, 2000000, 0",
"2|27|4202|3, 62, |survey ft|, -97.5, 31.6666666667, 32.1333333333, 33.9666666667, 2000000, 0",
"2|27|4203|3, 62, |survey ft|, -100.3333333333, 29.6666666667, 30.1166666667, 31.8833333333, 2000000, 0",
"2|27|4204|3, 62, |survey ft|, -99, 27.8333333333, 28.3833333333, 30.2833333333, 2000000, 0",
"2|27|4205|3, 62, |survey ft|, -98.5, 25.6666666667, 26.1666666667, 27.8333333333, 2000000, 0",
"2|27|4301|3, 62, |survey ft|, -111.5, 40.3333333333, 40.7166666667, 41.7833333333, 2000000, 0",
"2|27|4302|3, 62, |survey ft|, -111.5, 38.3333333333, 39.0166666667, 40.65, 2000000, 0",
"2|27|4303|3, 62, |survey ft|, -111.5, 36.6666666667, 37.2166666667, 38.35, 2000000, 0",
"2|27|4400|8, 62, |survey ft|, -72.5, 42.5, 0.9999642857, 500000, 0",
"2|27|4501|3, 62, |survey ft|, -78.5, 37.6666666667, 38.0333333333, 39.2, 2000000, 0",
"2|27|4502|3, 62, |survey ft|, -78.5, 36.3333333333, 36.7666666667, 37.9666666667, 2000000, 0",
"2|27|4601|3, 62, |survey ft|, -120.8333333333, 47, 47.5, 48.7333333333, 2000000, 0",
"2|27|4602|3, 62, |survey ft|, -120.5, 45.3333333333, 45.8333333333, 47.3333333333, 2000000, 0",
"2|27|4701|3, 62, |survey ft|, -79.5, 38.5, 39, 40.25, 2000000, 0",
"2|27|4702|3, 62, |survey ft|, -81, 37, 37.4833333333, 38.8833333333, 2000000, 0",
"2|27|4801|3, 62, |survey ft|, -90, 45.1666666667, 45.5666666667, 46.7666666667, 2000000, 0",
"2|27|4802|3, 62, |survey ft|, -90, 43.8333333333, 44.25, 45.5, 2000000, 0",
"2|27|4803|3, 62, |survey ft|, -90, 42, 42.7333333333, 44.0666666667, 2000000, 0",
"2|27|4901|8, 62, |survey ft|, -105.1666666667, 40.6666666667, 0.9999411765, 500000, 0",
"2|27|4902|8, 62, |survey ft|, -107.3333333333, 40.6666666667, 0.9999411765, 500000, 0",
"2|27|4903|8, 62, |survey ft|, -108.75, 40.6666666667, 0.9999411765, 500000, 0",
"2|27|4904|8, 62, |survey ft|, -110.0833333333, 40.6666666667, 0.9999411765, 500000, 0",
"2|83|101|8, 74,|m|, -85.8333333333, 30.5, 0.99996, 200000, 0",
"2|83|102|8, 74,|m|, -87.5, 30.0, 0.9999333333, 600000, 0",
"2|83|5001|7, 74,|m|, -133.6666666667, 57, -36.8698976458, 0.9999, 5000000, -5000000",
"2|83|5002|8, 74,|m|, -142, 54, 0.9999, 500000, 0",
"2|83|5003|8, 74,|m|, -146, 54, 0.9999, 500000, 0",
"2|83|5004|8, 74,|m|, -150, 54, 0.9999, 500000, 0",
"2|83|5005|8, 74,|m|, -154, 54, 0.9999, 500000, 0",
"2|83|5006|8, 74,|m|, -158, 54, 0.9999, 500000, 0",
"2|83|5007|8, 74,|m|, -162, 54, 0.9999, 500000, 0",
"2|83|5008|8, 74,|m|, -166, 54, 0.9999, 500000, 0",
"2|83|5009|8, 74,|m|, -170, 54, 0.9999, 500000, 0",
"2|83|5010|3, 74,|m|, -176,51, 51.8333333333, 53.8333333333, 1000000, 0",
"2|83|201|8, 74,|m|, -110.1666666667, 31, 0.9999, 213360, 0",
"2|83|202|8, 74,|m|, -111.9166666667, 31, 0.9999, 213360, 0",
"2|83|203|8, 74,|m|, -113.75, 31, 0.9999333333, 213360, 0",
"2|83|301|3, 74,|m|, -92, 34.3333333333, 34.9333333333, 36.2333333333, 400000, 0",
"2|83|302|3, 74,|m|, -92, 32.6666666667, 33.3, 34.7666666667, 400000, 400000",
"2|83|401|3, 74,|m|, -122, 39.3333333333, 40, 41.6666666667, 2000000, 500000",
"2|83|402|3, 74,|m|, -122, 37.6666666667, 38.3333333333, 39.8333333333, 2000000, 500000",
"2|83|403|3, 74,|m|, -120.5, 36.5, 37.0666666667, 38.4333333333, 2000000, 500000",
"2|83|404|3, 74,|m|, -119, 35.3333333333, 36, 37.25, 2000000, 500000",
"2|83|405|3, 74,|m|, -118, 33.5, 34.0333333333, 35.4666666667, 2000000, 500000",
"2|83|407|3, 74,|m|, -116.25, 32.1666666667, 32.7833333333, 33.8833333333, 2000000, 500000",
"2|83|501|3, 74,|m|, -105.5, 39.3333333333, 39.7166666667, 40.7833333333, 914401.8289, 304800.6096",
"2|83|502|3, 74,|m|, -105.5, 37.8333333333, 38.45, 39.75, 914401.8289, 304800.6096",
"2|83|503|3, 74,|m|, -105.5, 36.6666666667, 37.2333333333, 38.4333333333, 914401.8289, 304800.6096",
"2|83|600|3, 74,|m|, -72.75, 40.8333333333, 41.2, 41.8666666667, 304800.6096, 152400.3048",
"2|83|700|8, 74,|m|, -75.4166666667, 38, 0.999995, 200000, 0",
"2|83|901|3, 74,|m|, -84.5, 29, 29.5833333333, 30.75, 600000, 0",
"2|83|902|8, 74,|m|, -81, 24.3333333333, 0.9999411765, 200000, 0",
"2|83|903|8, 74,|m|, -82, 24.3333333333, 0.9999411765, 200000, 0",
"2|83|1001|8, 74,|m|, -82.1666666667, 30, 0.9999, 200000, 0",
"2|83|1002|8, 74,|m|, -84.1666666667, 30, 0.9999, 700000, 0",
"2|83|5101|8, 74,|m|, -155.5, 18.8333333333, 0.9999666667, 500000, 0",
"2|83|5102|8, 74,|m|, -156.6666666667, 20.3333333333, 0.9999666667, 500000, 0",
"2|83|5103|8, 74,|m|, -158, 21.1666666667, 0.99999, 500000, 0",
"2|83|5104|8, 74,|m|, -159.5, 21.8333333333, 0.99999, 500000, 0",
"2|83|5105|8, 74,|m|, -160.1666666667, 21.6666666667, 1, 500000, 0",
"2|83|1101|8, 74,|m|, -112.1666666667, 41.6666666667, 0.9999473684, 200000, 0",
"2|83|1102|8, 74,|m|, -114, 41.6666666667, 0.9999473684, 500000, 0",
"2|83|1103|8, 74,|m|, -115.75, 41.6666666667, 0.9999333333, 800000, 0",
"2|83|1201|8, 74,|m|, -88.3333333333, 36.6666666667, 0.999975, 300000, 0",
"2|83|1202|8, 74,|m|, -90.1666666667, 36.6666666667, 0.9999411765, 700000, 0",
"2|83|1301|8, 74,|m|, -85.6666666667, 37.5, 0.9999666667, 100000, 250000",
"2|83|1301|8, 74,|m|, -87.0833333333, 37.5, 0.9999666667, 900000, 250000",
"2|83|1401|3, 74,|m|, -93.5, 41.5, 42.0666666667, 43.2666666667, 1500000, 1000000",
"2|83|1402|3, 74,|m|, -93.5, 40, 40.6166666667, 41.7833333333, 500000, 0",
"2|83|1501|3, 74,|m|, -98, 38.3333333333, 38.7166666667, 39.7833333333, 400000, 0",
"2|83|1502|3, 74,|m|, -98.5, 36.6666666667, 38.5666666667, 37.2666666667, 400000, 400000",
"2|83|1601|3, 74,|m|, -84.25, 37.5, 37.9666666667, 38.9666666667, 500000, 0",
"2|83|1602|3, 74,|m|, -85.75, 36.3333333333, 36.7333333333, 37.9333333333, 500000, 500000",
"2|83|1701|3, 74,|m|, -92.5, 30.5, 31.1666666667, 32.6666666667, 1000000, 0",
"2|83|1702|3, 74,|m|, -91.3333333333, 28.5, 29.3, 30.7, 1000000, 0",
"2|83|1703|3, 74,|m|, -91.3333333333, 25.5, 26.1666666667, 27.8333333333, 1000000, 0",
"2|83|1801|8, 74,|m|, -68.5, 43.6666666667, 0.9999, 300000, 0",
"2|83|1802|8, 74,|m|, -70.1666666667, 42.8333333333, 0.9999666667, 900000, 0",
"2|83|1900|3, 74,|m|, -77, 37.6666666667, 38.3, 39.45, 400000, 0",
"2|83|2001|3, 74,|m|, -71.5, 41, 41.7166666667, 42.6833333333, 200000, 750000",
"2|83|2002|3, 74,|m|, -70.5, 41, 41.2833333333, 41.4833333333, 500000, 0",
"2|83|2111|3, 74,|m|, -87, 44.7833333333, 45.4833333333, 47.0833333333, 8000000, 0",
"2|83|2112|3, 74,|m|, -84.3666666667, 43.3166666667, 44.1833333333, 45.7, 6000000, 0",
"2|83|2113|3, 74,|m|, -84.3666666667, 41.5, 42.1, 43.6666666667, 4000000, 0",
"2|83|2201|3, 74,|m|, -93.1, 46.5, 47.0333333333, 48.6333333333, 800000, 100000",
"2|83|2202|3, 74,|m|, -94.25, 45, 45.6166666667, 47.05, 800000, 100000",
"2|83|2203|3, 74,|m|, -94, 43, 43.7833333333, 45.2166666667, 800000, 100000",
"2|83|2301|8, 74,|m|, -88.8333333333, 29.5, 0.99995, 300000, 0",
"2|83|2302|8, 74,|m|, -90.3333333333, 29.5, 0.99995, 700000, 0",
"2|83|2401|8, 74,|m|, -90.5, 35.8333333333, 0.9999333333, 250000, 0",
"2|83|2402|8, 74,|m|, -92.5, 35.8333333333, 0.9999333333, 500000, 0",
"2|83|2403|8, 74,|m|, -94.5, 36.1666666667, 0.9999411765, 850000, 0",
"2|83|2500|3, 74,|m|, -109.5, 44.25, 45, 49, 600000, 0",
"2|83|2600|3, 74,|m|, -100, 39.8333333333, 40, 43, 500000, 0",
"2|83|2701|8, 74,|m|, -115.5833333333, 34.75, 0.9999, 200000, 8000000",
"2|83|2702|8, 74,|m|, -116.6666666667, 34.75, 0.9999, 500000, 6000000",
"2|83|2703|8, 74,|m|, -118.5833333333, 34.75, 0.9999, 800000, 4000000",
"2|83|2800|8, 74,|m|, -71.6666666667, 42.5, 0.9999666667, 300000, 0",
"2|83|2900|8, 74,|m|, -74.5, 38.8333333334, 0.9999, 150000, 0",
"2|83|3001|8, 74,|m|, -104.3333333333, 31, 0.9999090909, 165000, 0",
"2|83|3002|8, 74,|m|, -106.25, 31, 0.9999, 500000, 0",
"2|83|3003|8, 74,|m|, -107.8333333333, 31, 0.9999166667, 830000, 0",
"2|83|3101|8, 74,|m|, -74.5, 38.8333333333, 0.9999, 150000, 0",
"2|83|3102|8, 74,|m|, -76.5833333333, 40, 0.9999375, 250000, 0",
"2|83|3103|8, 74,|m|, -78.5833333333, 40, 0.9999375, 350000, 0",
"2|83|3104|3, 74,|m|, -74, 40.1666666667, 40.6666666667, 41.0333333333, 300000, 0",
"2|83|3200|3, 74,|m|, -79, 33.75, 34.3333333333, 36.1666666667, 609601.22, 0",
"2|83|3301|3, 74,|m|, -100.5, 47, 47.4333333333, 48.7333333333, 600000, 0",
"2|83|3302|3, 74,|m|, -100.5, 45.6666666667, 46.1833333333, 47.4833333333, 600000, 0",
"2|83|3401|3, 74,|m|, -82.5, 39.6666666667, 40.4333333333, 41.7, 600000, 0",
"2|83|3402|3, 74,|m|, -82.5, 38, 38.7333333333, 40.0333333333, 600000, 0",
"2|83|3501|3, 74,|m|, -98, 35, 35.5666666667, 36.7666666667, 600000, 0",
"2|83|3502|3, 74,|m|, -98, 33.3333333333, 33.9333333333, 35.2333333333, 600000, 0",
"2|83|3601|3, 74,|m|, -120.5, 43.6666666667, 44.3333333333, 46, 2500000, 0",
"2|83|3602|3, 74,|m|, -120.5, 41.6666666667, 42.3333333333, 44, 1500000, 0",
"2|83|3701|3, 74,|m|, -77.75, 40.1666666667, 40.8833333333, 41.95, 600000, 0",
"2|83|3702|3, 74,|m|, -77.75, 39.3333333333, 39.9333333333, 40.9666666667, 600000, 0",
"2|83|5301|3, 74,|m|, -66.4333333333, 17.8333333333, 18.0333333333, 18.4333333333, 200000, 200000",
"2|83|3800|8, 74,|m|, -71.5, 41.0833333333, 0.99999375, 100000, 0",
"2|83|3900|3, 74,|m|, -81, 31.8333333333, 32.5, 34.8333333333, 609600, 0",
"2|83|4001|3, 74,|m|, -100, 43.8333333333, 44.4166666667, 45.6833333333, 600000, 0",
"2|83|4002|3, 74,|m|, -100.3333333333, 42.3333333333, 42.8333333333, 44.4, 600000, 0",
"2|83|4100|3, 74,|m|, -86, 34.3333333333, 35.25, 36.4166666667, 600000, 0",
"2|83|4201|3, 74,|m|, -101.5, 34, 34.65, 36.1833333333, 200000, 1000000",
"2|83|4202|3, 74,|m|, -98.5, 31.6666666667, 32.1333333333, 33.9666666667, 600000, 2000000",
"2|83|4203|3, 74,|m|, -100.3333333333, 29.6666666667, 30.1166666667, 31.8833333333, 700000, 3000000",
"2|83|4204|3, 74,|m|, -99, 27.8333333333, 28.3833333333, 30.2833333333, 600000, 4000000",
"2|83|4205|3, 74,|m|, -98.5, 25.6666666667, 26.1666666667, 27.8333333333, 300000, 5000000",
"2|83|4301|3, 74,|m|, -111.5, 40.3333333333, 40.7166666667, 41.7833333333, 500000, 1000000",
"2|83|4302|3, 74,|m|, -111.5, 38.3333333333, 39.0166666667, 40.65, 500000, 2000000",
"2|83|4303|3, 74,|m|, -111.5, 36.6666666667, 37.2166666667, 38.35, 500000, 3000000",
"2|83|4400|8, 74,|m|, -72.5, 42.5, 0.9999642857, 500000, 0",
"2|83|4501|3, 74,|m|, -78.5, 37.6666666667, 38.0333333333, 39.2, 3500000, 2000000",
"2|83|4502|3, 74,|m|, -78.5, 36.3333333333, 36.7666666667, 37.9666666667, 3500000, 1000000",
"2|83|4601|3, 74,|m|, -120.8333333333, 47, 47.5, 48.7333333333, 500000, 0",
"2|83|4602|3, 74,|m|, -120.5, 45.3333333333, 45.8333333333, 47.3333333333, 500000, 0",
"2|83|4701|3, 74,|m|, -79.5, 38.5, 39, 40.25, 600000, 0",
"2|83|4702|3, 74,|m|, -81, 37, 37.4833333333, 38.8833333333, 600000, 0",
"2|83|4801|3, 74,|m|, -90, 45.1666666667, 45.5666666667, 46.7666666667, 600000, 0",
"2|83|4802|3, 74,|m|, -90, 43.8333333333, 44.25, 45.5, 600000, 0",
"2|83|4803|3, 74,|m|, -90, 42, 42.7333333333, 44.0666666667, 600000, 0",
"2|83|4901|8, 74,|m|, -105.1666666667, 40.5, 0.9999375, 200000, 0",
"2|83|4902|8, 74,|m|, -107.3333333333, 40.5, 0.9999375, 400000, 100000",
"2|83|4903|8, 74,|m|, -108.75, 40.5, 0.9999375, 600000, 0",
"2|83|4904|8, 74,|m|, -110.0833333333, 40.5, 0.9999375, 800000, 100000",
"3|27|0|1, 62",
"3|83|0|1, 74"
} ;

get_proj_info(buff,proj,nad,zone)
char buff[];
int proj;                  /* PROJECTION TYPE */
int nad;                   /* NAD TYPE */
int zone;                  /* ZONE */
{
    int i, j, k;
    char bufr[512], *ptr1, *ptr2;
char ans[5];

/*fprintf(stderr, "get_proj_info\n");*/
    
    *buff = 0;
    for(i=0;i<NUMPROJ;i++) {
      sprintf(bufr,codes[i]);
      ptr1 = bufr;
      ptr2 = ptr1;
      while(*ptr1 != '\174') ptr1++;
      *ptr1 = 0;
/*fprintf(stderr, "1. code <%d>\n",i);*/
/*fprintf(stderr, "  proj= %d,  ptr2= %s\ncontinue ?",proj,ptr2); gets(ans);*/
      if (proj == atoi(ptr2)) {
	 for(j=i;j<NUMPROJ;j++) {
           sprintf(bufr,codes[j]);
	   ptr1 = bufr; ptr1+=2;
	   ptr2 = ptr1;
	   while(*ptr1 != '\174') ptr1++;
	   *ptr1 = 0;
/*fprintf(stderr, "2. code <%d>\n",j);*/
/*fprintf(stderr, "  nad= %d,  ptr2= %s\ncontinue ?",nad,ptr2); gets(ans);*/
	   if (nad == atoi(ptr2)) {
	      for(k=j;k<NUMPROJ;k++) {
                sprintf(bufr,codes[k]);
	        ptr1 = bufr; ptr1+=5;
	        ptr2 = ptr1;
	        while(*ptr1 != '\174') ptr1++;
	        *ptr1 = 0;
/*fprintf(stderr, "3. code <%d>\n",k);*/
/*fprintf(stderr, "  zone= %d,  ptr2= %s\ncontinue ?",zone,ptr2); gets(ans);*/
	        if (zone == atoi(ptr2)) {
	           ptr1++;
/*fprintf(stderr, "4. ptr1 <%s>\ncontinue ?",ptr1); gets(ans);*/
                   sprintf(bufr,"%s",ptr1);
		   ptr1 = bufr; ptr1++;
		   for(i=0;i<3;i++) {
		       /* look for remaining |'s, change to " */
		      while(*ptr1 != '\174') *ptr1++;
                      *ptr1 = '\042';
		   }
                   strcat(buff,bufr);
                   return(1);
                }
              }
            }
         }
       }
    } /* end of NOT LATLONG */

    return(0);
}
