#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "main.h"
#include "graphics.h"
#include "game.h"


void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  game_titles_key_press(); 
}


void
on_pause_game1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  game_pause_event();
}


void
on_restart_game1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  game_restart_event();
}


void
on_end_game1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  game_end_event();
}

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_quit();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  about2 = create_about2();
  gtk_widget_show( about2 );
  
}


void
on_app1_destroy                        (GtkObject       *object,
                                        gpointer         user_data)
{
  main_quit();
}


gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
      
  return FALSE;
}


gboolean
on_drawingarea1_configure_event        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  return graphics_canvas_configure( widget, event, user_data );
}


gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  return graphics_canvas_expose( widget, event, user_data );
}


gboolean
on_app1_key_press_event                (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  
  return game_key_press();
  
}


void
on_reset_high_scores1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  hiscore_reset_scores();
  
}



gboolean
on_drawingarea1_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return game_key_press();
  
}

void
on_levels1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

