
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of ff_handler a FreeForm API handler for the OPeNDAP
// DAP2 data server.

// Copyright (c) 2005 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 2.1 of the License, or (at your
// option) any later version.
// 
// This software is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
// License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

// Prototypes for the FreeForm server utility functions.
//
// jhrg 4/2/96

// $Id: util_ff.h 17863 2008-02-02 21:29:27Z pwest $

#ifndef _util_ff_h
#define _util_ff_h

#include "FreeForm.h"

#include "BaseType.h"
#include "Error.h"
#include "InternalErr.h"
#include "dods-datatypes.h"

using namespace libdap ;

#define MaxStr 100
const int Msgt_size = 255;

const string ff_types(Type dods_type);
int ff_prec(Type dods_type);

const string make_output_format(const string &name, Type type, 
				const int width);

const string makeND_output_format(const string &name, Type type, 
				  const int width, int ndim, 
				  const long *start, const long *edge, const
				  long * stride, string *dname);

const string &format_extension(const string &new_extension = "");
const string &format_delimiter(const string &new_delimiter = "");

const string find_ancillary_file(const string &dataset, 
				 const string &delimiter = format_delimiter(),
				 const string &extension = format_extension());

int SetDodsDB(FF_STD_ARGS_PTR std_args, DATA_BIN_HANDLE dbin_h, char * Msgt);

bool file_exist(const char * filename);

extern "C" long read_ff(const char *dataset, const char *if_file, const char *o_format, 
                        char *o_buffer, unsigned long size);

bool is_integer_type(BaseType *btp);
bool is_float_type(BaseType *btp);
dods_uint32 get_integer_value(BaseType *var) throw(InternalErr);
dods_float64 get_float_value(BaseType *var) throw(InternalErr);

#endif // _util_ff_h_






