/***************************************************************************
 *   Copyright (C) 2008 by Kitsune   *
 *   sutoka@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "webview.h"
#include <QTimer>
#include <KMenu>
#include <QWebHitTestResult>
#include <QWebPage>

#include <iostream>

webView::webView(QWidget* parent) : QWebView(parent), m_progress(0), m_urlWanted("")
{
        m_page = new webPage(this);
        setObjectName("webView:" + QString::number(uint(this)));
        std::cout << "CREATE:webView," << uint(this) << ";parent:" << uint(parent) << std::endl;
        setPage(m_page);
        connect(this, SIGNAL(urlChanged(QUrl)),
                this, SLOT(urlCatcher(QUrl)));
        connect(this, SIGNAL(titleChanged(QString)),
                this, SLOT(titleCatcher(QString)));
        connect(this, SIGNAL(statusBarMessage(QString)),
                this, SLOT(statusBarCatcher(QString)));
        connect(page(), SIGNAL(linkHovered(const QString&, const QString&, const QString&)),
                this, SLOT(linkHoverCatcher(const QString&, const QString&, const QString&)));
        connect(this, SIGNAL(iconChanged()),
                this, SLOT(iconChangeCatcher()));
        connect(this, SIGNAL(loadProgress(int)),
                this, SLOT(loadProgressCatcher(int)));
        connect(this, SIGNAL(urlChanged(QUrl)),
                this, SLOT(setAddressEditString(QUrl)));
}

webView::~webView()
{
        std::cout << "DESTROY:webView," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        m_page->disconnect();
}

void webView::urlCatcher(const QUrl& url)
{
        emit urlChanged(url, (void*)this);
}

void webView::titleCatcher(const QString& title)
{
        if(!title.isEmpty())
                emit titleChanged(title, (void*)this);
        else
                emit titleChanged(url().toString(), (void*)this);
}

void webView::statusBarCatcher(const QString& text)
{
        m_statusText = text;
        emit statusBarMessage(text, (void*)this);
}

void webView::linkHoverCatcher(const QString& link, const QString& title, const QString& textContent)
{
        Q_UNUSED(title);
        Q_UNUSED(textContent);
        emit linkHovered(link, (void*)this);
}

void webView::iconChangeCatcher()
{
        emit iconChanged(icon(), (void*)this);
}



QString* webView::getAddressEditString()
{
        return &m_addressEditString;
}


void webView::setAddressEditString(QString addressStrn)
{
        m_addressEditString.clear();
        m_addressEditString.append(addressStrn);
}

void webView::loadProgressCatcher(int progress)
{
        m_progress = progress;
        emit loadProgress(progress, (void*)this);
}

void webView::setAddressEditString(QUrl url)
{
        m_addressEditString = url.toString();
}

int webView::getProgress()
{
        return m_progress;
}

QString webView::getStatusText()
{
        return m_statusText;
}

void webView::mousePressEvent(QMouseEvent *event)
{
        m_page->setKeys(event->buttons(), event->modifiers());
        QWebView::mousePressEvent(event);
}

void webView::contextMenuEvent(QContextMenuEvent * event)
{
        //TODO Simplify this, reduce the duplicate code.
        QWebHitTestResult test = m_page->mainFrame()->hitTestContent(event->pos());
        KMenu menu(this);
        if(!test.imageUrl().isEmpty())
        {
                m_urlWanted = test.imageUrl();
                if(!test.linkUrl().isEmpty())
                {
                    m_urlWanted = test.linkUrl();
                    menu.addAction("Open in New Window", this, SLOT(newWinRequestCatcher()));
                    menu.addAction("Open in New Tab", this, SLOT(newTabRequestCatcher()));
                    menu.addSeparator();
                    menu.addAction(pageAction(QWebPage::CopyLinkToClipboard));
                    menu.addSeparator();
                }
                menu.addAction(pageAction(QWebPage::OpenImageInNewWindow));
                menu.addAction(pageAction(QWebPage::CopyImageToClipboard));
                menu.addAction(pageAction(QWebPage::DownloadImageToDisk));
                menu.addSeparator();
                menu.addAction(pageAction(QWebPage::Back));
                menu.addAction(pageAction(QWebPage::Forward));
                menu.addAction(pageAction(QWebPage::Reload));
                menu.exec(mapToGlobal(event->pos()));
        }
        else if(!test.linkUrl().isEmpty())
        {
                m_urlWanted = test.linkUrl();
                menu.addAction("Open in New Window", this, SLOT(newWinRequestCatcher()));
                menu.addAction("Open in New Tab", this, SLOT(newTabRequestCatcher()));
                menu.addSeparator();
                menu.addAction(pageAction(QWebPage::CopyLinkToClipboard));
                menu.addSeparator();
                menu.addAction(pageAction(QWebPage::Back));
                menu.addAction(pageAction(QWebPage::Forward));
                menu.addAction(pageAction(QWebPage::Reload));
                menu.exec(mapToGlobal(event->pos()));
        }
        else // Not a link or image
        {
                m_urlWanted = "about:youShouldntSeeThisPage";
                menu.addAction(pageAction(QWebPage::Back));
                menu.addAction(pageAction(QWebPage::Forward));
                menu.addAction(pageAction(QWebPage::Reload));
                menu.exec(mapToGlobal(event->pos()));
        }

}

void webView::newWinRequestCatcher()
{
        emit newViewRequest(true, QNetworkRequest(m_urlWanted));
}

void webView::newTabRequestCatcher()
{
        emit newViewRequest(false, QNetworkRequest(m_urlWanted));
}
