/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef FOXKIT_H
#define FOXKIT_H

#include <KXmlGuiWindow>
#include <QCloseEvent>
#include <QWebView>
#include <QList>

#include "webview.h"
#include "webtab.h"
#include "netmanager.h"
#include "tools.h"

#include <KAction>
#include <KToolBar>
class QLineEdit;
class QLabel;
class QString;
class QStatusBar;
#include <KMenu>
#include <QProgressBar>
#include <QLineEdit>
#include <QComboBox>

// Constant expressions... not for changing :P
static const signed int CLOSECURRENT = -5;
static const int TruncateLengthShort = 30;
static const int TruncateLengthLong = 65;


class foxkit : public KXmlGuiWindow
{
        Q_OBJECT

public:
        foxkit(NetManager *net);
        ~foxkit();

        static void setHome(QUrl home)  { s_home = home; }
        static const QUrl getHome()     { return s_home; }

public slots:
        void newView(bool newWin = false, QNetworkRequest request = QNetworkRequest(QUrl("about:blank")));

protected:
        void closeEvent(QCloseEvent *event);

signals:
        void newWindow(QNetworkRequest);
        void windowClosing();
        void newWindow();

private slots:
        void addressEntered();
        void setUrl(QString urlString);
        void setCurrentUrl(QUrl url, void*);
        void setCurrentTitle(QString title, void*);
        void setIcon(QIcon icon, void*);
        void setStatusBarText(QString text, void*);
        void closeTab(signed int index = CLOSECURRENT);
        void loadProgress(int progress, void*);

        void pageBack()     { m_activeView->back(); }
        void pageForward()  { m_activeView->forward(); }
        void pageStop()     { m_activeView->stop(); }
        void pageReload()   { m_activeView->reload(); }

        void tabPageChanged(int index);

        void clearAddressBar();

private:
        int addressToIndex(void* address);

        webTab tabs;
        NetManager *netman;
        cookieViewer *cookies;
        QPointer<webView> m_activeView;

        void createActions();
        QProgressBar m_progress;

        QComboBox m_addressBar;

        KAction *addressWidgetAction;
        KAction *m_newWindow;
        KAction *m_saveContents;
        KAction *m_clearAddress;
        KAction *m_newTab;
        KAction *m_closeTab;
        KAction *m_stop;
        KAction *m_reload;
        KAction *m_cookieViwer;

        static QUrl s_home;
        static bool s_allowNoTabs;
};

#endif
