#!/bin/sh

###
## constants
###
KDE_PREFIX=$(kde-config --prefix)
ICONS_DIR="share/icons/default.kde"
LINK_DIR="share/applnk/Multimedia"
SMNU_DIR="share/apps/konqueror/servicemenus"
ICONS_SIZE=("16x16" "22x22" "32x32" "48x48" "64x64" "128x128")
TRANSLATIONS=("pl" "it" "es" "nl" "zh_CN" "cs" "ru" "uk")
###

###
## uninstall
###
echo -e "\E[0;32m>> \E[0;36muninstalling binaries...\E[0;38m"
#make clean >> /dev/null
rm -f "$KDE_PREFIX/bin/falf"

for i in ${TRANSLATIONS[@]}
do
	rm -f "$KDE_PREFIX/share/locale/$i/LC_MESSAGES/falf.mo"
done

echo -e "\E[0;32m>> \E[0;36muninstalling icons...\E[0;38m"

for i in ${ICONS_SIZE[@]}
do
	rm -f "$KDE_PREFIX/$ICONS_DIR/$i/apps/falf.png"
done

echo -e "\E[0;32m>> \E[0;36muninstalling links...\E[0;38m"
rm -f "$KDE_PREFIX/$LINK_DIR/falf.desktop"
rm -f "$KDE_PREFIX/$SMNU_DIR/falf_mnu.desktop"

echo -ne "\E[0;0m"
