/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "version.h"

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "frmmain.h"

static KCmdLineOptions options[] =
{
	{"+[url]", I18N_NOOP("Files that will be added to playlist"), 0},
	KCmdLineLastOption
};

int main(int argc, char ** argv)
{
	KAboutData aboutData(argv[0], FALF_NAM, FALF_VER, I18N_NOOP("Music player for KDE"), KAboutData::License_GPL_V2,
	                     "(c) 2006-2008, amdfanatyk", NULL, "http://falf.sourceforge.net", "amdfanatyk@o2.pl");
	aboutData.addAuthor("amdfanatyk", I18N_NOOP("lead programmer"), "amdfanatyk@o2.pl", "http://amdfanatyk.w.interia.pl");
	aboutData.addCredit("gohanz", I18N_NOOP("main tester"), "gohanz@infinito.it", NULL);
	aboutData.setTranslator(I18N_NOOP("Your name"), I18N_NOOP("Your email"));

	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	KApplication a;

	frmMain w;
	
	a.setTopWidget(&w);
	a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));

	return a.exec();
}
