#!/bin/sh -e

DB="/etc/entrance_config.cfg"


# Auto detect the correct vt to use.
echo "Searching for the first unused virtual terminal (vt) or a running X."
largest=1
sudo lsof -Fn /dev/tty* | grep dev | cut -b 10- | sort -n | uniq |
(
  while read tty; do
    # The first one might be /dev/tty
    if [ "$tty" = "" ]; then
      continue;
    fi

    # Look for the first free vt.
    if [ -z "$found" ]; then
      if [ ! "$tty" = "$largest" ]; then
        # Yes we found a free one, but keep looking for any running X.
        found="$largest"
        echo "Found a free vt at vt$found."
      fi
    fi
    largest=`expr $largest + 1`

    # The first one that already has X running on it.
    command=`sudo lsof -Fc /dev/tty$tty | grep ^c | cut -b 2-`
    if [ "$command" = "X" ]; then
      found="$tty"
      echo "Found a running X at vt$found."
      break;
    fi

  done

  if [ -z "$found" ]; then
    echo "No suitable virtual terminal (vt) found.

This script is looking at the vts you are currently using to determine which
one should be used for X.  X need not be running, but you should at least be
running in multi user mode so that the vts normally used for text terminals
and such are in use.  If you got this message and you are running in multi
user mode, then there is probably a bug, please let me know the details.

onefang@gmail.com

You could pick a vt manually and run this command (assuming you picked vt7) -

sudo ecore_config -c $DB -k /entranced/xserver -s \"/usr/X11R6/bin/X -quiet -nolisten tcp vt7\"
"
  else
    echo "Setting the X virtual terminal to vt$found."
    sudo ecore_config -c $DB -k /entranced/xserver -s "/usr/X11R6/bin/X -quiet -nolisten tcp vt$found"
  fi
)
echo ""


# Auto detect the correct pam configuration to use.
echo "Finding a pam configuration to copy."
if test -f /etc/pam.d/gdm; then
  echo "Copying the /etc/pam.d/gdm configuration."
  sudo cp -f /etc/pam.d/gdm /etc/pam.d/entrance
elif test -f /etc/pam.d/kdm; then
  echo "Copying the /etc/pam.d/kdm configuration."
  sudo cp -f /etc/pam.d/kdm /etc/pam.d/entrance
elif test -f /etc/pam.d/wdm; then
  echo "Copying the /etc/pam.d/wdm configuration."
  sudo cp -f /etc/pam.d/wdm /etc/pam.d/entrance
elif test -f /etc/pam.d/xdm; then
  echo "Copying the /etc/pam.d/xdm configuration."
  sudo cp -f /etc/pam.d/xdm /etc/pam.d/entrance
fi
