# Conditional build stuff; from rpm 4.4 /usr/lib/rpm/macros.
# bcond_without defaults to WITH, and vice versa.  Yes, it's
# ass-backward.  Blame PLD.
# from KainX's changes to evas... 
%if %{!?with:1}0
%define with() %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%endif
%if %{!?without:1}0
%define without() %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%endif
%if %{!?bcond_with:1}0
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%endif
%if %{!?bcond_without:1}0
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
%endif

## disabled features
%bcond_with lib_ecore_directfb
%bcond_with lib_ecore_sdl

## enabled features
##%bcond_without module_engine_software_x11
%bcond_without lib_ecore_fb

# This just keeps a missing doxygen from killing the build.
%define _missing_doc_files_terminate_build 0

%define breq_lib_ecore_directfb     %{?with_lib_ecore_directfb:DirectFB}
%define breq_lib_ecore_sdl          %{?with_lib_ecore_sdl:SDL-devel}

%define ac_with_lib_ecore_fb        --%{?with_lib_ecore_fb:en}%{!?with_lib_ecore_fb:dis}able-ecore-fb
%define ac_with_lib_ecore_directfb  --%{?with_lib_ecore_directfb:en}%{!?with_lib_ecore_directfb:dis}able-ecore-directfb
%define ac_with_lib_ecore_sdl       --%{?with_lib_ecore_sdl:en}%{!?with_lib_ecore_sdl:dis}able-ecore-sdl

Summary: Enlightened Core X interface library
Name: ecore
Version: 0.9.9.043
Release: 0.%(date '+%Y%m%d')
License: BSD
Group: User Interface/X
Source: %{name}-%{version}.tar.gz
URL: http://www.enlightenment.org
Packager: %{?_packager:%{_packager}}%{!?_packager:Michael Jennings <mej@eterm.org>}
Vendor: %{?_vendorinfo:%{_vendorinfo}}%{!?_vendorinfo:The Enlightenment Project (http://www.enlightenment.org/)}
Distribution: %{?_distribution:%{_distribution}}%{!?_distribution:%{_vendor}}
#BuildSuggests: xorg-x11-devel, XFree86-devel
BuildRequires: libjpeg-devel, openssl-devel %{?breq_lib_ecore_directfb}
BuildRequires: curl-devel, evas-devel, eet-devel %{?breq_lib_ecore_sdl}
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Ecore is the event/X abstraction layer that makes doing selections,
Xdnd, general X stuff, event loops, timeouts and idle handlers fast,
optimized, and convenient. It's a separate library so anyone can make
use of the work put into Ecore to make this job easy for applications.

%package devel
Summary: Ecore headers and development libraries.
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: curl-devel, openssl-devel, evas-devel, eet-devel
Requires: ecore-bin, ecore-con, ecore-config, ecore-evas, ecore-file, ecore-ipc, ecore-job, ecore-txt
Requires: ecore-x %{?with_lib_ecore_fb:ecore-fb} %{?with_lib_ecore_directfb:ecore-directfb}

%description devel
Ecore development files

%package bin
Summary: Tools that support Ecore
Group: Development/Libraries
Requires: %{name} = %{version}

%description bin
Tools that support Ecore

%package con
Summary: Ecore Connection Library
Group: Development/Libraries
Requires: %{name} = %{version}

%description con
Ecore Connection Library

%package config
Summary: Ecore Enlightened Property Library
Group: Development/Libraries
Requires: %{name} = %{version}

%description config
Ecore Enlightened Property Library

%if %{with lib_ecore_directfb}
%package directfb
Summary: Ecore DirectFB system functions
Group: Development/Libraries
Requires: %{name} = %{version}
%description directfb
Ecore DirectFB system functions
%endif

%package evas
Summary: Ecore Evas Wrapper Library
Group: Development/Libraries
Requires: %{name} = %{version}

%description evas
Ecore Evas Wrapper Library

%if %{with lib_ecore_fb}
%package fb
Summary: Ecore frame buffer system functions
Group: Development/Libraries
Requires: %{name} = %{version}
%description fb
Ecore frame buffer system functions
%endif

%package file
Summary: Ecore File Library
Group: Development/Libraries
Requires: %{name} = %{version}

%description file
Ecore File Library

%package ipc
Summary: Ecore inter-process communication functions
Group: Development/Libraries
Requires: %{name} = %{version}

%description ipc
Ecore inter-process communication functions

%package job
Summary: Ecore job dealing functions
Group: Development/Libraries
Requires: %{name} = %{version}

%description job
Ecore job dealing functions

%package txt
Summary: Ecore text encoding conversion functions
Group: Development/Libraries
Requires: %{name} = %{version}

%description txt
Ecore text encoding conversion functions

%package x
Summary: Ecore functions for dealing with the X Windows System
Group: Development/Libraries
Requires: %{name} = %{version}

%description x
Ecore functions for dealing with the X Windows System

%prep
%setup -q -n %{name}-%{version}

%build
CFLAGS="-I/usr/kerberos/include -I/usr/X11R6/include/X11/extensions"
LDFLAGS="-L/usr/kerberos/lib -L/usr/X11R6/%{_lib}"
export CFLAGS LDFLAGS
%{configure} --prefix=%{_prefix} \
    %{?ac_with_lib_ecore_fb} \
    %{?ac_with_lib_ecore_directfb} \
    %{?ac_with_lib_ecore_sdl}

%{__make} %{?_smp_mflags} %{?mflags}

%install
%{__make} %{?mflags_install} DESTDIR=$RPM_BUILD_ROOT install

%post
/sbin/ldconfig || :

%postun
/sbin/ldconfig || :

%clean
test "x$RPM_BUILD_ROOT" != "x/" && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING* README*
%{_libdir}/libecore.so.*

%files devel
%defattr(-, root, root)
%doc doc/html
%{_libdir}/*.so
%{_libdir}/*.la
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
#%{_datadir}/aclocal/*
%{_includedir}/*.h

%files bin
%defattr(-, root, root)
%{_bindir}/ecore_config

%files con
%defattr(-, root, root)
%{_libdir}/libecore_con.so.*

%files config
%defattr(-, root, root)
%{_libdir}/libecore_config.so.*

%if %{with lib_ecore_directfb}
%files directfb
%defattr(-, root, root)
%{_libdir}/libecore_directfb.so.*
%endif

%files evas
%defattr(-, root, root)
%{_libdir}/libecore_evas.so.*

%if %{with lib_ecore_fb}
%files fb
%defattr(-, root, root)
%{_libdir}/libecore_fb.so.*
%endif

%files file
%defattr(-, root, root)
%{_libdir}/libecore_file.so.*

%files ipc
%defattr(-, root, root)
%{_libdir}/libecore_ipc.so.*

%files job
%defattr(-, root, root)
%{_libdir}/libecore_job.so.*

%files txt
%defattr(-, root, root)
%{_libdir}/libecore_txt.so.*

%files x
%defattr(-, root, root)
%{_libdir}/libecore_x.so.*
