// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#ifndef __EBZIP_H__
#define __EBZIP_H__

#include "eb_sup.h"

#include <sys/types.h>

#ifndef HAVE_LIBEB
typedef int Zio;
#endif

class EBZip {
  int file;
  Zio* zip;
  bool Open(const char* fileName);
  bool Close();
public:
  EBZip();
  EBZip(const char* fileName);
  virtual ~EBZip();
  bool Initialized(){ return zip!=NULL && file>=0; };
  off_t LSeek(off_t offset, int whence);
  bool Read(char* buf, size_t length);
  bool Read(unsigned char* buf,size_t len){
    return Read(reinterpret_cast<char*>(buf),len);
  }
  bool ReadBlock(int sect,char* buf);
  bool ReadBlock(int sect,unsigned char* buf){
    return ReadBlock(sect,reinterpret_cast<char*>(buf));
  }
};
#endif
