// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 2001 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/
#ifdef LIBXML_VERSION
#error This library can not be used with libxml. Use libxml functions instead.
#endif

#include <cstring>

struct xmlNode;
typedef xmlNode* xmlNodePtr;
typedef xmlNode* xmlDocPtr;
typedef char xmlChar;

struct xmlNode {
  xmlNodePtr xmlChildrenNode;
  xmlNodePtr next;
  xmlNodePtr parent;
  char* name;
  char* val;
  xmlNode(): xmlChildrenNode(NULL),next(NULL),
	     name(NULL),parent(NULL),val(NULL) { };
  ~xmlNode();
};

#define LIBXML_TEST_VERSION

#define xmlKeepBlanksDefault(x)
#define xmlDocGetRootElement(x) (x)

inline bool xmlIsBlankNode(xmlNodePtr node) { return false; };
inline int xmlStrcmp(const char* a,const char* b) { return strcmp(a,b); };

extern xmlNodePtr xmlParseFile(char* fname);
extern void xmlFreeDoc(xmlNodePtr top);

void xmlUnlinkNode(xmlNodePtr top);
void xmlFreeNode(xmlNodePtr top);
xmlNodePtr xmlNewChild(xmlNodePtr ptr,void * dummy,
			const xmlChar* name,const xmlChar* stringVal);
void xmlSaveFile(const char* fileName,xmlDocPtr doc);
void xmlSaveFileEnc(const char* fileName,xmlDocPtr doc,char* encoding);
xmlDocPtr xmlParseDoc(const char* str);
void xmlNodeSetContent(xmlNodePtr np,const xmlChar* str);
char* xmlNodeGetContent(xmlNodePtr node);
