/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "tile_options.h"

static int TileOptionsDisplayPrivateIndex;

static CompMetadata tileOptionsMetadata;

static CompPluginVTable *tilePluginVTable = NULL;
CompPluginVTable tileOptionsVTable;

#define TILE_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, TileOptions, o)
#define TILE_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, TileOptions, o)

typedef struct _TileOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[TileDisplayOptionNum];
    tileDisplayOptionChangeNotifyProc notify[TileDisplayOptionNum];
} TileOptionsDisplay;

typedef struct _TileOptionsScreen
{
} TileOptionsScreen;

int tileGetAnimateType (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionAnimateType].value.i;
}

CompOption * tileGetAnimateTypeOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionAnimateType];
}

void tileSetAnimateTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionAnimateType] = notify;
}

int tileGetAnimationDuration (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionAnimationDuration].value.i;
}

CompOption * tileGetAnimationDurationOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionAnimationDuration];
}

void tileSetAnimationDurationNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionAnimationDuration] = notify;
}

int tileGetTileToggleType (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileToggleType].value.i;
}

CompOption * tileGetTileToggleTypeOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggleType];
}

void tileSetTileToggleTypeNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileToggleType] = notify;
}

Bool tileGetTileJoin (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileJoin].value.b;
}

CompOption * tileGetTileJoinOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileJoin];
}

void tileSetTileJoinNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileJoin] = notify;
}

int tileGetTileDelta (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileDelta].value.i;
}

CompOption * tileGetTileDeltaOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileDelta];
}

void tileSetTileDeltaNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileDelta] = notify;
}

int tileGetTileLeftOccupancy (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return od->opt[TileDisplayOptionTileLeftOccupancy].value.i;
}

CompOption * tileGetTileLeftOccupancyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileLeftOccupancy];
}

void tileSetTileLeftOccupancyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileLeftOccupancy] = notify;
}

CompMatch * tileGetExcludeMatch (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionExcludeMatch].value.match;
}

CompOption * tileGetExcludeMatchOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionExcludeMatch];
}

void tileSetExcludeMatchNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionExcludeMatch] = notify;
}

CompAction * tileGetTileVerticallyKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileVerticallyKey].value.action;
}

void tileSetTileVerticallyKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileVerticallyKey].value.action.initiate = init;
}

void tileSetTileVerticallyKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileVerticallyKey].value.action.terminate = term;
}

CompOption * tileGetTileVerticallyKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileVerticallyKey];
}

void tileSetTileVerticallyKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileVerticallyKey] = notify;
}

CompAction * tileGetTileHorizontallyKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileHorizontallyKey].value.action;
}

void tileSetTileHorizontallyKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileHorizontallyKey].value.action.initiate = init;
}

void tileSetTileHorizontallyKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileHorizontallyKey].value.action.terminate = term;
}

CompOption * tileGetTileHorizontallyKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileHorizontallyKey];
}

void tileSetTileHorizontallyKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileHorizontallyKey] = notify;
}

CompAction * tileGetTileTileKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileTileKey].value.action;
}

void tileSetTileTileKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileTileKey].value.action.initiate = init;
}

void tileSetTileTileKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileTileKey].value.action.terminate = term;
}

CompOption * tileGetTileTileKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileTileKey];
}

void tileSetTileTileKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileTileKey] = notify;
}

CompAction * tileGetTileCascadeKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileCascadeKey].value.action;
}

void tileSetTileCascadeKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileCascadeKey].value.action.initiate = init;
}

void tileSetTileCascadeKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileCascadeKey].value.action.terminate = term;
}

CompOption * tileGetTileCascadeKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileCascadeKey];
}

void tileSetTileCascadeKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileCascadeKey] = notify;
}

CompAction * tileGetTileRestoreKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileRestoreKey].value.action;
}

void tileSetTileRestoreKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileRestoreKey].value.action.initiate = init;
}

void tileSetTileRestoreKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileRestoreKey].value.action.terminate = term;
}

CompOption * tileGetTileRestoreKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileRestoreKey];
}

void tileSetTileRestoreKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileRestoreKey] = notify;
}

CompAction * tileGetTileToggleKey (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggleKey].value.action;
}

void tileSetTileToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileToggleKey].value.action.initiate = init;
}

void tileSetTileToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    TILE_OPTIONS_DISPLAY(d);
    od->opt[TileDisplayOptionTileToggleKey].value.action.terminate = term;
}

CompOption * tileGetTileToggleKeyOption (CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[TileDisplayOptionTileToggleKey];
}

void tileSetTileToggleKeyNotify (CompDisplay *d, tileDisplayOptionChangeNotifyProc notify)
{
    TILE_OPTIONS_DISPLAY(d);
    od->notify[TileDisplayOptionTileToggleKey] = notify;
}

CompOption * tileGetDisplayOption (CompDisplay *d, TileDisplayOptions num)
{
    TILE_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo tileOptionsDisplayOptionInfo[] = {
    { "animate_type", "int", "<min>0</min><max>5</max>", 0, 0 },
    { "animation_duration", "int", "<min>100</min><max>2000</max>", 0, 0 },
    { "tile_toggle_type", "int", "<min>0</min><max>4</max>", 0, 0 },
    { "tile_join", "bool", 0, 0, 0 },
    { "tile_delta", "int", "<min>0</min><max>250</max>", 0, 0 },
    { "tile_left_occupancy", "int", "<min>20</min><max>80</max>", 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
    { "tile_vertically_key", "key", 0, 0, 0 },
    { "tile_horizontally_key", "key", 0, 0, 0 },
    { "tile_tile_key", "key", 0, 0, 0 },
    { "tile_cascade_key", "key", 0, 0, 0 },
    { "tile_restore_key", "key", 0, 0, 0 },
    { "tile_toggle_key", "key", 0, 0, 0 },
};

static Bool tileOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    TILE_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, TileDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case TileDisplayOptionAnimateType:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionAnimateType])
                (*od->notify[TileDisplayOptionAnimateType]) (d, o, TileDisplayOptionAnimateType);
            return TRUE;
        }
        break;
     case TileDisplayOptionAnimationDuration:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionAnimationDuration])
                (*od->notify[TileDisplayOptionAnimationDuration]) (d, o, TileDisplayOptionAnimationDuration);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileToggleType:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileToggleType])
                (*od->notify[TileDisplayOptionTileToggleType]) (d, o, TileDisplayOptionTileToggleType);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileJoin:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileJoin])
                (*od->notify[TileDisplayOptionTileJoin]) (d, o, TileDisplayOptionTileJoin);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileDelta:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileDelta])
                (*od->notify[TileDisplayOptionTileDelta]) (d, o, TileDisplayOptionTileDelta);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileLeftOccupancy:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileLeftOccupancy])
                (*od->notify[TileDisplayOptionTileLeftOccupancy]) (d, o, TileDisplayOptionTileLeftOccupancy);
            return TRUE;
        }
        break;
     case TileDisplayOptionExcludeMatch:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionExcludeMatch])
                (*od->notify[TileDisplayOptionExcludeMatch]) (d, o, TileDisplayOptionExcludeMatch);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileVerticallyKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileVerticallyKey])
                (*od->notify[TileDisplayOptionTileVerticallyKey]) (d, o, TileDisplayOptionTileVerticallyKey);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileHorizontallyKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileHorizontallyKey])
                (*od->notify[TileDisplayOptionTileHorizontallyKey]) (d, o, TileDisplayOptionTileHorizontallyKey);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileTileKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileTileKey])
                (*od->notify[TileDisplayOptionTileTileKey]) (d, o, TileDisplayOptionTileTileKey);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileCascadeKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileCascadeKey])
                (*od->notify[TileDisplayOptionTileCascadeKey]) (d, o, TileDisplayOptionTileCascadeKey);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileRestoreKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileRestoreKey])
                (*od->notify[TileDisplayOptionTileRestoreKey]) (d, o, TileDisplayOptionTileRestoreKey);
            return TRUE;
        }
        break;
     case TileDisplayOptionTileToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[TileDisplayOptionTileToggleKey])
                (*od->notify[TileDisplayOptionTileToggleKey]) (d, o, TileDisplayOptionTileToggleKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * tileOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    TILE_OPTIONS_DISPLAY(d);
    *count = TileDisplayOptionNum;
    return od->opt;
}

static Bool tileOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    TileOptionsScreen *os;
    
    TILE_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(TileOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void tileOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    TILE_OPTIONS_SCREEN (s);

    free (os);
}

static Bool tileOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    TileOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(TileOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[TileOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &tileOptionsMetadata, tileOptionsDisplayOptionInfo, od->opt, TileDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void tileOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    TILE_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, TileDisplayOptionNum);

    free (od);
}

static Bool tileOptionsInit (CompPlugin *p)
{
    TileOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (TileOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&tileOptionsMetadata, "tile",tileOptionsDisplayOptionInfo, TileDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&tileOptionsMetadata, "tile");
    if (tilePluginVTable && tilePluginVTable->init)
        return tilePluginVTable->init (p);
    return TRUE;
}

static void tileOptionsFini (CompPlugin *p)
{
    if (tilePluginVTable && tilePluginVTable->fini)
        tilePluginVTable->fini (p);

    if (TileOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (TileOptionsDisplayPrivateIndex);

    compFiniMetadata (&tileOptionsMetadata);
}

static CompBool tileOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) tileOptionsInitDisplay,
        (InitPluginObjectProc) tileOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void tileOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) tileOptionsFiniDisplay,
        (FiniPluginObjectProc) tileOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool tileOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = tileOptionsInitObject (p, o);
    if (tilePluginVTable->initObject)
        rv &= tilePluginVTable->initObject (p, o);
    return rv;
}

static void tileOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (tilePluginVTable->finiObject)
        tilePluginVTable->finiObject (p, o);
    tileOptionsFiniObject (p, o);
}

static CompOption * tileOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) tileOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool tileOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) tileOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
tileOptionsGetMetadata (CompPlugin *plugin)
{
    return &tileOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!tilePluginVTable)
    {
        tilePluginVTable = getCompPluginInfo ();
        memcpy(&tileOptionsVTable, tilePluginVTable, sizeof(CompPluginVTable));
        tileOptionsVTable.getMetadata = tileOptionsGetMetadata;
        tileOptionsVTable.init = tileOptionsInit;
        tileOptionsVTable.fini = tileOptionsFini;
        tileOptionsVTable.initObject = tileOptionsInitObjectWrapper;
        tileOptionsVTable.finiObject = tileOptionsFiniObjectWrapper;
        tileOptionsVTable.getObjectOptions = tileOptionsGetObjectOptions;
	tileOptionsVTable.setObjectOption = tileOptionsSetObjectOption;
	
    }
    return &tileOptionsVTable;
}

