/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _SNOW_OPTIONS_H
#define _SNOW_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    SnowDisplayOptionNumSnowflakes,
    SnowDisplayOptionSnowSize,
    SnowDisplayOptionSnowSpeed,
    SnowDisplayOptionSnowUpdateDelay,
    SnowDisplayOptionScreenBoxing,
    SnowDisplayOptionScreenDepth,
    SnowDisplayOptionSnowOverWindows,
    SnowDisplayOptionSnowRotation,
    SnowDisplayOptionSnowDirection,
    SnowDisplayOptionSnowTextures,
    SnowDisplayOptionUseBlending,
    SnowDisplayOptionUseTextures,
    SnowDisplayOptionToggleKey,
    SnowDisplayOptionNum
} SnowDisplayOptions;

typedef void (*snowDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, SnowDisplayOptions num);

CompOption *snowGetDisplayOption (CompDisplay *d, SnowDisplayOptions num);

typedef enum
{
    SnowScreenOptionNum
} SnowScreenOptions;

typedef void (*snowScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, SnowScreenOptions num);

CompOption *snowGetScreenOption (CompScreen *s, SnowScreenOptions num);

typedef enum
{
    SnowDirectionTopToBottom = 0,
    SnowDirectionBottomToTop = 1,
    SnowDirectionRightToLeft = 2,
    SnowDirectionLeftToRight = 3,
} SnowSnowDirectionEnum;

int              snowGetNumSnowflakes (CompDisplay *d);
CompOption *     snowGetNumSnowflakesOption (CompDisplay *d);
void             snowSetNumSnowflakesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

float            snowGetSnowSize (CompDisplay *d);
CompOption *     snowGetSnowSizeOption (CompDisplay *d);
void             snowSetSnowSizeNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

int              snowGetSnowSpeed (CompDisplay *d);
CompOption *     snowGetSnowSpeedOption (CompDisplay *d);
void             snowSetSnowSpeedNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

int              snowGetSnowUpdateDelay (CompDisplay *d);
CompOption *     snowGetSnowUpdateDelayOption (CompDisplay *d);
void             snowSetSnowUpdateDelayNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

int              snowGetScreenBoxing (CompDisplay *d);
CompOption *     snowGetScreenBoxingOption (CompDisplay *d);
void             snowSetScreenBoxingNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

int              snowGetScreenDepth (CompDisplay *d);
CompOption *     snowGetScreenDepthOption (CompDisplay *d);
void             snowSetScreenDepthNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

Bool             snowGetSnowOverWindows (CompDisplay *d);
CompOption *     snowGetSnowOverWindowsOption (CompDisplay *d);
void             snowSetSnowOverWindowsNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

Bool             snowGetSnowRotation (CompDisplay *d);
CompOption *     snowGetSnowRotationOption (CompDisplay *d);
void             snowSetSnowRotationNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

int              snowGetSnowDirection (CompDisplay *d);
CompOption *     snowGetSnowDirectionOption (CompDisplay *d);
void             snowSetSnowDirectionNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

CompListValue *  snowGetSnowTextures (CompDisplay *d);
CompOption *     snowGetSnowTexturesOption (CompDisplay *d);
void             snowSetSnowTexturesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

Bool             snowGetUseBlending (CompDisplay *d);
CompOption *     snowGetUseBlendingOption (CompDisplay *d);
void             snowSetUseBlendingNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

Bool             snowGetUseTextures (CompDisplay *d);
CompOption *     snowGetUseTexturesOption (CompDisplay *d);
void             snowSetUseTexturesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

CompAction *     snowGetToggleKey (CompDisplay *d);
void             snowSetToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             snowSetToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     snowGetToggleKeyOption (CompDisplay *d);
void             snowSetToggleKeyNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
