/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "fakeargb_options.h"

static int FakeargbOptionsDisplayPrivateIndex;

static CompMetadata fakeargbOptionsMetadata;

static CompPluginVTable *fakeargbPluginVTable = NULL;
CompPluginVTable fakeargbOptionsVTable;

#define FAKEARGB_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, FakeargbOptions, o)
#define FAKEARGB_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, FakeargbOptions, o)

typedef struct _FakeargbOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[FakeargbDisplayOptionNum];
    fakeargbDisplayOptionChangeNotifyProc notify[FakeargbDisplayOptionNum];
} FakeargbOptionsDisplay;

typedef struct _FakeargbOptionsScreen
{
} FakeargbOptionsScreen;

CompAction * fakeargbGetWindowToggleKey (CompDisplay *d)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    return &od->opt[FakeargbDisplayOptionWindowToggleKey].value.action;
}

void fakeargbSetWindowToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->opt[FakeargbDisplayOptionWindowToggleKey].value.action.initiate = init;
}

void fakeargbSetWindowToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->opt[FakeargbDisplayOptionWindowToggleKey].value.action.terminate = term;
}

CompOption * fakeargbGetWindowToggleKeyOption (CompDisplay *d)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    return &od->opt[FakeargbDisplayOptionWindowToggleKey];
}

void fakeargbSetWindowToggleKeyNotify (CompDisplay *d, fakeargbDisplayOptionChangeNotifyProc notify)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->notify[FakeargbDisplayOptionWindowToggleKey] = notify;
}

CompAction * fakeargbGetWindowToggleButton (CompDisplay *d)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    return &od->opt[FakeargbDisplayOptionWindowToggleButton].value.action;
}

void fakeargbSetWindowToggleButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->opt[FakeargbDisplayOptionWindowToggleButton].value.action.initiate = init;
}

void fakeargbSetWindowToggleButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->opt[FakeargbDisplayOptionWindowToggleButton].value.action.terminate = term;
}

CompOption * fakeargbGetWindowToggleButtonOption (CompDisplay *d)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    return &od->opt[FakeargbDisplayOptionWindowToggleButton];
}

void fakeargbSetWindowToggleButtonNotify (CompDisplay *d, fakeargbDisplayOptionChangeNotifyProc notify)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    od->notify[FakeargbDisplayOptionWindowToggleButton] = notify;
}

CompOption * fakeargbGetDisplayOption (CompDisplay *d, FakeargbDisplayOptions num)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo fakeargbOptionsDisplayOptionInfo[] = {
    { "window_toggle_key", "key", 0, 0, 0 },
    { "window_toggle_button", "button", 0, 0, 0 },
};

static Bool fakeargbOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, FakeargbDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FakeargbDisplayOptionWindowToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FakeargbDisplayOptionWindowToggleKey])
                (*od->notify[FakeargbDisplayOptionWindowToggleKey]) (d, o, FakeargbDisplayOptionWindowToggleKey);
            return TRUE;
        }
        break;
     case FakeargbDisplayOptionWindowToggleButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FakeargbDisplayOptionWindowToggleButton])
                (*od->notify[FakeargbDisplayOptionWindowToggleButton]) (d, o, FakeargbDisplayOptionWindowToggleButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * fakeargbOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    FAKEARGB_OPTIONS_DISPLAY(d);
    *count = FakeargbDisplayOptionNum;
    return od->opt;
}

static Bool fakeargbOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    FakeargbOptionsScreen *os;
    
    FAKEARGB_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(FakeargbOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void fakeargbOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    FAKEARGB_OPTIONS_SCREEN (s);

    free (os);
}

static Bool fakeargbOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    FakeargbOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(FakeargbOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[FakeargbOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &fakeargbOptionsMetadata, fakeargbOptionsDisplayOptionInfo, od->opt, FakeargbDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void fakeargbOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    FAKEARGB_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, FakeargbDisplayOptionNum);

    free (od);
}

static Bool fakeargbOptionsInit (CompPlugin *p)
{
    FakeargbOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (FakeargbOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&fakeargbOptionsMetadata, "fakeargb",fakeargbOptionsDisplayOptionInfo, FakeargbDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&fakeargbOptionsMetadata, "fakeargb");
    if (fakeargbPluginVTable && fakeargbPluginVTable->init)
        return fakeargbPluginVTable->init (p);
    return TRUE;
}

static void fakeargbOptionsFini (CompPlugin *p)
{
    if (fakeargbPluginVTable && fakeargbPluginVTable->fini)
        fakeargbPluginVTable->fini (p);

    if (FakeargbOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (FakeargbOptionsDisplayPrivateIndex);

    compFiniMetadata (&fakeargbOptionsMetadata);
}

static CompBool fakeargbOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) fakeargbOptionsInitDisplay,
        (InitPluginObjectProc) fakeargbOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void fakeargbOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) fakeargbOptionsFiniDisplay,
        (FiniPluginObjectProc) fakeargbOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool fakeargbOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = fakeargbOptionsInitObject (p, o);
    if (fakeargbPluginVTable->initObject)
        rv &= fakeargbPluginVTable->initObject (p, o);
    return rv;
}

static void fakeargbOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (fakeargbPluginVTable->finiObject)
        fakeargbPluginVTable->finiObject (p, o);
    fakeargbOptionsFiniObject (p, o);
}

static CompOption * fakeargbOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) fakeargbOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool fakeargbOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) fakeargbOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
fakeargbOptionsGetMetadata (CompPlugin *plugin)
{
    return &fakeargbOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!fakeargbPluginVTable)
    {
        fakeargbPluginVTable = getCompPluginInfo ();
        memcpy(&fakeargbOptionsVTable, fakeargbPluginVTable, sizeof(CompPluginVTable));
        fakeargbOptionsVTable.getMetadata = fakeargbOptionsGetMetadata;
        fakeargbOptionsVTable.init = fakeargbOptionsInit;
        fakeargbOptionsVTable.fini = fakeargbOptionsFini;
        fakeargbOptionsVTable.initObject = fakeargbOptionsInitObjectWrapper;
        fakeargbOptionsVTable.finiObject = fakeargbOptionsFiniObjectWrapper;
        fakeargbOptionsVTable.getObjectOptions = fakeargbOptionsGetObjectOptions;
	fakeargbOptionsVTable.setObjectOption = fakeargbOptionsSetObjectOption;
	
    }
    return &fakeargbOptionsVTable;
}

