/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "atlantis_options.h"

static int AtlantisOptionsDisplayPrivateIndex;

static CompMetadata atlantisOptionsMetadata;

static CompPluginVTable *atlantisPluginVTable = NULL;
CompPluginVTable atlantisOptionsVTable;

#define ATLANTIS_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, AtlantisOptions, o)
#define ATLANTIS_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, AtlantisOptions, o)

typedef struct _AtlantisOptionsDisplay
{
    int screenPrivateIndex;

} AtlantisOptionsDisplay;

typedef struct _AtlantisOptionsScreen
{
    CompOption opt[AtlantisScreenOptionNum];
    atlantisScreenOptionChangeNotifyProc notify[AtlantisScreenOptionNum];
} AtlantisOptionsScreen;

Bool atlantisGetShowWater (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionShowWater].value.b;
}

CompOption * atlantisGetShowWaterOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionShowWater];
}

void atlantisSetShowWaterNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionShowWater] = notify;
}

Bool atlantisGetShowWaterWire (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionShowWaterWire].value.b;
}

CompOption * atlantisGetShowWaterWireOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionShowWaterWire];
}

void atlantisSetShowWaterWireNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionShowWaterWire] = notify;
}

Bool atlantisGetShowGround (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionShowGround].value.b;
}

CompOption * atlantisGetShowGroundOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionShowGround];
}

void atlantisSetShowGroundNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionShowGround] = notify;
}

float atlantisGetWaterHeight (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterHeight].value.f;
}

CompOption * atlantisGetWaterHeightOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWaterHeight];
}

void atlantisSetWaterHeightNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWaterHeight] = notify;
}

unsigned short * atlantisGetWaterColor (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterColor].value.c;
}

unsigned short atlantisGetWaterColorRed (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterColor].value.c[0];
}

unsigned short atlantisGetWaterColorGreen (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterColor].value.c[1];
}

unsigned short atlantisGetWaterColorBlue (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterColor].value.c[2];
}

unsigned short atlantisGetWaterColorAlpha (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaterColor].value.c[3];
}

CompOption * atlantisGetWaterColorOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWaterColor];
}

void atlantisSetWaterColorNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWaterColor] = notify;
}

int atlantisGetGridQuality (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionGridQuality].value.i;
}

CompOption * atlantisGetGridQualityOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionGridQuality];
}

void atlantisSetGridQualityNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionGridQuality] = notify;
}

Bool atlantisGetRenderWaves (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionRenderWaves].value.b;
}

CompOption * atlantisGetRenderWavesOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionRenderWaves];
}

void atlantisSetRenderWavesNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionRenderWaves] = notify;
}

float atlantisGetWaveAmplitude (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaveAmplitude].value.f;
}

CompOption * atlantisGetWaveAmplitudeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWaveAmplitude];
}

void atlantisSetWaveAmplitudeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWaveAmplitude] = notify;
}

float atlantisGetWaveFrequency (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaveFrequency].value.f;
}

CompOption * atlantisGetWaveFrequencyOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWaveFrequency];
}

void atlantisSetWaveFrequencyNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWaveFrequency] = notify;
}

float atlantisGetWaveSpeed (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWaveSpeed].value.f;
}

CompOption * atlantisGetWaveSpeedOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWaveSpeed];
}

void atlantisSetWaveSpeedNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWaveSpeed] = notify;
}

float atlantisGetSmallWaveAmplitude (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionSmallWaveAmplitude].value.f;
}

CompOption * atlantisGetSmallWaveAmplitudeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionSmallWaveAmplitude];
}

void atlantisSetSmallWaveAmplitudeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionSmallWaveAmplitude] = notify;
}

float atlantisGetSmallWaveFrequency (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionSmallWaveFrequency].value.f;
}

CompOption * atlantisGetSmallWaveFrequencyOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionSmallWaveFrequency];
}

void atlantisSetSmallWaveFrequencyNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionSmallWaveFrequency] = notify;
}

float atlantisGetSmallWaveSpeed (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionSmallWaveSpeed].value.f;
}

CompOption * atlantisGetSmallWaveSpeedOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionSmallWaveSpeed];
}

void atlantisSetSmallWaveSpeedNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionSmallWaveSpeed] = notify;
}

int atlantisGetNumFish (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionNumFish].value.i;
}

CompOption * atlantisGetNumFishOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionNumFish];
}

void atlantisSetNumFishNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionNumFish] = notify;
}

Bool atlantisGetColors (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionColors].value.b;
}

CompOption * atlantisGetColorsOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionColors];
}

void atlantisSetColorsNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionColors] = notify;
}

int atlantisGetFishSize (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionFishSize].value.i;
}

CompOption * atlantisGetFishSizeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionFishSize];
}

void atlantisSetFishSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionFishSize] = notify;
}

int atlantisGetSharkSize (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionSharkSize].value.i;
}

CompOption * atlantisGetSharkSizeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionSharkSize];
}

void atlantisSetSharkSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionSharkSize] = notify;
}

int atlantisGetDolphinSize (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionDolphinSize].value.i;
}

CompOption * atlantisGetDolphinSizeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionDolphinSize];
}

void atlantisSetDolphinSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionDolphinSize] = notify;
}

int atlantisGetWhaleSize (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return os->opt[AtlantisScreenOptionWhaleSize].value.i;
}

CompOption * atlantisGetWhaleSizeOption (CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[AtlantisScreenOptionWhaleSize];
}

void atlantisSetWhaleSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    os->notify[AtlantisScreenOptionWhaleSize] = notify;
}

CompOption * atlantisGetScreenOption (CompScreen *s, AtlantisScreenOptions num)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo atlantisOptionsScreenOptionInfo[] = {
    { "show_water", "bool", 0, 0, 0 },
    { "show_water_wire", "bool", 0, 0, 0 },
    { "show_ground", "bool", 0, 0, 0 },
    { "water_height", "float", "<min>0.2</min><max>1</max>", 0, 0 },
    { "water_color", "color", 0, 0, 0 },
    { "grid_quality", "int", "<min>1</min><max>10</max>", 0, 0 },
    { "render_waves", "bool", 0, 0, 0 },
    { "wave_amplitude", "float", "<min>0</min><max>0.5</max>", 0, 0 },
    { "wave_frequency", "float", "<min>0</min><max>100</max>", 0, 0 },
    { "wave_speed", "float", "<min>0</min><max>10</max>", 0, 0 },
    { "small_wave_amplitude", "float", "<min>0</min><max>0.5</max>", 0, 0 },
    { "small_wave_frequency", "float", "<min>0</min><max>100</max>", 0, 0 },
    { "small_wave_speed", "float", "<min>0</min><max>10</max>", 0, 0 },
    { "num_fish", "int", "<min>5</min><max>100</max>", 0, 0 },
    { "colors", "bool", 0, 0, 0 },
    { "fish_size", "int", "<min>100</min><max>10000</max>", 0, 0 },
    { "shark_size", "int", "<min>100</min><max>10000</max>", 0, 0 },
    { "dolphin_size", "int", "<min>100</min><max>10000</max>", 0, 0 },
    { "whale_size", "int", "<min>100</min><max>10000</max>", 0, 0 },
};

static Bool atlantisOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, AtlantisScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case AtlantisScreenOptionShowWater:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionShowWater])
                (*os->notify[AtlantisScreenOptionShowWater]) (s, o, AtlantisScreenOptionShowWater);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionShowWaterWire:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionShowWaterWire])
                (*os->notify[AtlantisScreenOptionShowWaterWire]) (s, o, AtlantisScreenOptionShowWaterWire);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionShowGround:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionShowGround])
                (*os->notify[AtlantisScreenOptionShowGround]) (s, o, AtlantisScreenOptionShowGround);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWaterHeight:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWaterHeight])
                (*os->notify[AtlantisScreenOptionWaterHeight]) (s, o, AtlantisScreenOptionWaterHeight);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWaterColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWaterColor])
                (*os->notify[AtlantisScreenOptionWaterColor]) (s, o, AtlantisScreenOptionWaterColor);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionGridQuality:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionGridQuality])
                (*os->notify[AtlantisScreenOptionGridQuality]) (s, o, AtlantisScreenOptionGridQuality);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionRenderWaves:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionRenderWaves])
                (*os->notify[AtlantisScreenOptionRenderWaves]) (s, o, AtlantisScreenOptionRenderWaves);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWaveAmplitude:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWaveAmplitude])
                (*os->notify[AtlantisScreenOptionWaveAmplitude]) (s, o, AtlantisScreenOptionWaveAmplitude);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWaveFrequency:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWaveFrequency])
                (*os->notify[AtlantisScreenOptionWaveFrequency]) (s, o, AtlantisScreenOptionWaveFrequency);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWaveSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWaveSpeed])
                (*os->notify[AtlantisScreenOptionWaveSpeed]) (s, o, AtlantisScreenOptionWaveSpeed);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionSmallWaveAmplitude:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionSmallWaveAmplitude])
                (*os->notify[AtlantisScreenOptionSmallWaveAmplitude]) (s, o, AtlantisScreenOptionSmallWaveAmplitude);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionSmallWaveFrequency:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionSmallWaveFrequency])
                (*os->notify[AtlantisScreenOptionSmallWaveFrequency]) (s, o, AtlantisScreenOptionSmallWaveFrequency);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionSmallWaveSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionSmallWaveSpeed])
                (*os->notify[AtlantisScreenOptionSmallWaveSpeed]) (s, o, AtlantisScreenOptionSmallWaveSpeed);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionNumFish:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionNumFish])
                (*os->notify[AtlantisScreenOptionNumFish]) (s, o, AtlantisScreenOptionNumFish);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionColors:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionColors])
                (*os->notify[AtlantisScreenOptionColors]) (s, o, AtlantisScreenOptionColors);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionFishSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionFishSize])
                (*os->notify[AtlantisScreenOptionFishSize]) (s, o, AtlantisScreenOptionFishSize);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionSharkSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionSharkSize])
                (*os->notify[AtlantisScreenOptionSharkSize]) (s, o, AtlantisScreenOptionSharkSize);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionDolphinSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionDolphinSize])
                (*os->notify[AtlantisScreenOptionDolphinSize]) (s, o, AtlantisScreenOptionDolphinSize);
            return TRUE;
        }
        break;
     case AtlantisScreenOptionWhaleSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[AtlantisScreenOptionWhaleSize])
                (*os->notify[AtlantisScreenOptionWhaleSize]) (s, o, AtlantisScreenOptionWhaleSize);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * atlantisOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    ATLANTIS_OPTIONS_SCREEN(s);
    *count = AtlantisScreenOptionNum;
    return os->opt;
}

static Bool atlantisOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    AtlantisOptionsScreen *os;
    
    ATLANTIS_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(AtlantisOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &atlantisOptionsMetadata, atlantisOptionsScreenOptionInfo, os->opt, AtlantisScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void atlantisOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    ATLANTIS_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, AtlantisScreenOptionNum);

    free (os);
}

static Bool atlantisOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    AtlantisOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(AtlantisOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[AtlantisOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void atlantisOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    ATLANTIS_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool atlantisOptionsInit (CompPlugin *p)
{
    AtlantisOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (AtlantisOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&atlantisOptionsMetadata, "atlantis",0, 0, atlantisOptionsScreenOptionInfo, AtlantisScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&atlantisOptionsMetadata, "atlantis");
    if (atlantisPluginVTable && atlantisPluginVTable->init)
        return atlantisPluginVTable->init (p);
    return TRUE;
}

static void atlantisOptionsFini (CompPlugin *p)
{
    if (atlantisPluginVTable && atlantisPluginVTable->fini)
        atlantisPluginVTable->fini (p);

    if (AtlantisOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (AtlantisOptionsDisplayPrivateIndex);

    compFiniMetadata (&atlantisOptionsMetadata);
}

static CompBool atlantisOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) atlantisOptionsInitDisplay,
        (InitPluginObjectProc) atlantisOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void atlantisOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) atlantisOptionsFiniDisplay,
        (FiniPluginObjectProc) atlantisOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool atlantisOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = atlantisOptionsInitObject (p, o);
    if (atlantisPluginVTable->initObject)
        rv &= atlantisPluginVTable->initObject (p, o);
    return rv;
}

static void atlantisOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (atlantisPluginVTable->finiObject)
        atlantisPluginVTable->finiObject (p, o);
    atlantisOptionsFiniObject (p, o);
}

static CompOption * atlantisOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) atlantisOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool atlantisOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) atlantisOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
atlantisOptionsGetMetadata (CompPlugin *plugin)
{
    return &atlantisOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!atlantisPluginVTable)
    {
        atlantisPluginVTable = getCompPluginInfo ();
        memcpy(&atlantisOptionsVTable, atlantisPluginVTable, sizeof(CompPluginVTable));
        atlantisOptionsVTable.getMetadata = atlantisOptionsGetMetadata;
        atlantisOptionsVTable.init = atlantisOptionsInit;
        atlantisOptionsVTable.fini = atlantisOptionsFini;
        atlantisOptionsVTable.initObject = atlantisOptionsInitObjectWrapper;
        atlantisOptionsVTable.finiObject = atlantisOptionsFiniObjectWrapper;
        atlantisOptionsVTable.getObjectOptions = atlantisOptionsGetObjectOptions;
	atlantisOptionsVTable.setObjectOption = atlantisOptionsSetObjectOption;
	
    }
    return &atlantisOptionsVTable;
}

